/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.treetable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.JTableHeader;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.components.JTreeTable;

public class JTreeTablePanel
extends JPanel {
    protected CustomTreeTableViewport treeTableViewport;
    protected JPanel scrollBarPanel;
    protected JScrollBar scrollBar;
    protected JScrollPane treeTableScrollPane;
    protected JTreeTable treeTable;
    private boolean columnMarginChanged = false;
    private boolean internalScrollBarChange = false;

    public JTreeTablePanel(JTreeTable treeTable) {
        super(new BorderLayout());
        this.treeTable = treeTable;
        this.initComponents();
        this.hookHeaderColumnResize();
        this.hookScrollBarValueChange();
        this.hookTreeCollapsedExpanded();
    }

    public void setCorner(String key, Component corner) {
        this.treeTableScrollPane.setCorner(key, corner);
    }

    public JScrollPane getScrollPane() {
        return this.treeTableScrollPane;
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.updateScrollBarMaximum();
        this.updateScrollBarWidth();
    }

    private void hookHeaderColumnResize() {
        this.treeTable.getTableHeader().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent e) {
                JTreeTablePanel.this.treeTableViewport.repaint();
            }

            public void columnMoved(TableColumnModelEvent e) {
                JTreeTablePanel.this.treeTableViewport.repaint();
            }

            public void columnRemoved(TableColumnModelEvent e) {
                JTreeTablePanel.this.treeTableViewport.repaint();
            }

            public void columnMarginChanged(ChangeEvent e) {
                JTreeTablePanel.this.internalScrollBarChange = true;
                JTreeTablePanel.this.columnMarginChanged = true;
                JTreeTablePanel.this.updateScrollBarMaximum();
                JTreeTablePanel.this.treeTableViewport.repaint();
                JTreeTablePanel.this.updateScrollBarWidth();
                JTreeTablePanel.this.internalScrollBarChange = false;
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    private void hookScrollBarValueChange() {
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!JTreeTablePanel.this.internalScrollBarChange) {
                    JTreeTablePanel.this.treeTable.setTreeCellOffsetX(e.getValue());
                }
            }
        });
    }

    private void hookTreeCollapsedExpanded() {
        this.treeTable.getTree().addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                JTreeTablePanel.this.internalScrollBarChange = true;
                JTreeTablePanel.this.updateScrollBarMaximum();
                JTreeTablePanel.this.internalScrollBarChange = false;
            }

            public void treeExpanded(TreeExpansionEvent event) {
                JTreeTablePanel.this.internalScrollBarChange = true;
                JTreeTablePanel.this.updateScrollBarMaximum();
                JTreeTablePanel.this.internalScrollBarChange = false;
            }
        });
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeTableScrollPane = new JScrollPane(22, 31);
        this.treeTableScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.treeTableViewport = new CustomTreeTableViewport(this.treeTable);
        this.treeTableScrollPane.setViewport(this.treeTableViewport);
        this.treeTableScrollPane.addMouseWheelListener(this.treeTable);
        this.treeTableScrollPane.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (JTreeTablePanel.this.treeTableScrollPane.getVerticalScrollBar().getModel().getExtent() == JTreeTablePanel.this.treeTableScrollPane.getVerticalScrollBar().getModel().getMaximum()) {
                    JTreeTablePanel.this.treeTableScrollPane.getVerticalScrollBar().setEnabled(false);
                } else {
                    JTreeTablePanel.this.treeTableScrollPane.getVerticalScrollBar().setEnabled(true);
                }
            }
        });
        this.scrollBar = new JScrollBar(0);
        this.scrollBar.setUnitIncrement(10);
        this.scrollBarPanel = new JPanel(new BorderLayout());
        this.scrollBarPanel.add((Component)this.scrollBar, "West");
        this.treeTable.setTreeCellOffsetX(0);
        this.scrollBarPanel.setVisible(false);
        this.add((Component)this.treeTableScrollPane, "Center");
        this.add((Component)this.scrollBarPanel, "South");
    }

    private void updateScrollBarMaximum() {
        int treeWidth = this.treeTable.getTree().getPreferredSize().width + 3;
        int columnWidth = this.treeTable.getColumnModel().getColumn(0).getWidth();
        if (this.columnMarginChanged && this.treeTable.getTreeCellOffsetX() > 0 && treeWidth - this.treeTable.getTreeCellOffsetX() < columnWidth) {
            this.columnMarginChanged = false;
            if (treeWidth - columnWidth >= 0) {
                this.treeTable.setTreeCellOffsetX(treeWidth - columnWidth);
            }
        }
        int scrollBarMaximum = treeWidth - columnWidth;
        if (!this.isShowing()) {
            return;
        }
        if (scrollBarMaximum <= 0) {
            this.treeTable.setTreeCellOffsetX(0);
            this.scrollBarPanel.setVisible(false);
        } else {
            int value = this.treeTable.getTreeCellOffsetX();
            int extent = treeWidth;
            this.scrollBarPanel.setVisible(true);
            this.scrollBar.setValues(value, extent, 0, scrollBarMaximum + extent);
        }
    }

    private void updateScrollBarWidth() {
        this.scrollBar.setPreferredSize(new Dimension(this.treeTable.getTableHeader().getHeaderRect((int)0).width, this.scrollBar.getPreferredSize().height));
        this.scrollBar.setBlockIncrement((int)((float)this.scrollBar.getModel().getExtent() * 0.95f));
        this.scrollBar.invalidate();
        this.revalidate();
    }

    private class CustomTreeTableViewport
    extends JViewport {
        private JTableHeader tableHeader;

        public CustomTreeTableViewport(JTreeTable treeTable) {
            this.setView(treeTable);
            this.setBackground(treeTable.getBackground());
            this.tableHeader = treeTable.getTableHeader();
        }

        public void paint(Graphics g) {
            super.paint(g);
            this.paintVerticalLines(g);
        }

        private int getEmptySpaceY() {
            if (this.getView() == null) {
                return 0;
            }
            return this.getView().getHeight();
        }

        private void paintVerticalLines(Graphics g) {
            int emptySpaceY = this.getEmptySpaceY();
            if (emptySpaceY > 0) {
                g.setColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
                for (int i = 0; i < this.tableHeader.getColumnModel().getColumnCount(); ++i) {
                    Rectangle cellRect = this.tableHeader.getHeaderRect(i);
                    g.drawLine(cellRect.x + cellRect.width - 1, emptySpaceY, cellRect.x + cellRect.width - 1, this.getHeight() - 1);
                }
            }
        }
    }
}

