/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.treetable;

import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;

public class ExtendedTreeTableModel
extends AbstractTreeTableModel {
    private AbstractTreeTableModel realModel;
    private int[] columnsMapping;
    private boolean[] columnsVisibility;
    private int realColumnsCount;
    private int virtualColumnsCount;

    public ExtendedTreeTableModel(AbstractTreeTableModel realModel) {
        super(realModel.root, realModel.supportsSorting, realModel.initialSortingColumn, realModel.initialSortingOrder);
        this.virtualColumnsCount = this.realColumnsCount = realModel.getColumnCount();
        this.realModel = realModel;
        this.columnsMapping = new int[this.realColumnsCount];
        boolean[] initialColumnsVisibility = new boolean[this.realColumnsCount];
        for (int i = 0; i < this.realColumnsCount; ++i) {
            initialColumnsVisibility[i] = true;
        }
        this.setColumnsVisibility(initialColumnsVisibility);
    }

    public boolean isCellEditable(Object node, int column) {
        return this.realModel.isCellEditable(node, this.getRealColumn(column));
    }

    public Class getColumnClass(int col) {
        return this.realModel.getColumnClass(this.getRealColumn(col));
    }

    public int getColumnCount() {
        return this.virtualColumnsCount;
    }

    public String getColumnName(int col) {
        return this.realModel.getColumnName(this.getRealColumn(col));
    }

    public String getColumnToolTipText(int columnIndex) {
        int realColumn = this.getRealColumn(columnIndex);
        if (realColumn == -1) {
            return null;
        }
        return this.realModel.getColumnToolTipText(realColumn);
    }

    public void setColumnsVisibility(boolean[] columnsVisibility) {
        this.columnsVisibility = columnsVisibility;
        this.recomputeColumnsMapping();
    }

    public boolean[] getColumnsVisibility() {
        return this.columnsVisibility;
    }

    public boolean getInitialSorting(int column) {
        return this.realModel.getInitialSorting(this.getRealColumn(column));
    }

    public int getInitialSortingColumn() {
        return this.realModel.getInitialSortingColumn();
    }

    public boolean getInitialSortingOrder() {
        return this.realModel.getInitialSortingOrder();
    }

    public boolean isLeaf(Object node) {
        return this.realModel.isLeaf(node);
    }

    public int getRealColumn(int column) {
        if (column > -1 && column < this.columnsMapping.length) {
            return this.columnsMapping[column];
        }
        return -1;
    }

    public void setRealColumnVisibility(int column, boolean visible) {
        if (visible) {
            this.showRealColumn(column);
        } else {
            this.hideRealColumn(column);
        }
    }

    public boolean isRealColumnVisible(int column) {
        if (column > -1 && column < this.columnsMapping.length) {
            return this.columnsVisibility[column];
        }
        return false;
    }

    public void setRoot(Object root) {
        this.realModel.setRoot(root);
    }

    public Object getRoot() {
        return this.realModel.getRoot();
    }

    public void setValueAt(Object aValue, Object node, int column) {
        this.realModel.setValueAt(aValue, node, this.getRealColumn(column));
    }

    public Object getValueAt(Object node, int column) {
        return this.realModel.getValueAt(node, this.getRealColumn(column));
    }

    public int getVirtualColumn(int column) {
        for (int i = 0; i < this.virtualColumnsCount; ++i) {
            if (this.getRealColumn(i) != column) continue;
            return i;
        }
        return -1;
    }

    public void hideRealColumn(int column) {
        if (this.isRealColumnVisible(column)) {
            this.columnsVisibility[column] = false;
            this.recomputeColumnsMapping();
        }
    }

    public void showRealColumn(int column) {
        if (!this.isRealColumnVisible(column)) {
            this.columnsVisibility[column] = true;
            this.recomputeColumnsMapping();
        }
    }

    public void sortByColumn(int column, boolean order) {
        this.realModel.sortByColumn(this.getRealColumn(column), order);
    }

    private void recomputeColumnsMapping() {
        int i;
        this.virtualColumnsCount = 0;
        int virtualColumnIndex = 0;
        for (i = 0; i < this.realColumnsCount; ++i) {
            if (!this.columnsVisibility[i]) continue;
            this.columnsMapping[virtualColumnIndex] = i;
            ++this.virtualColumnsCount;
            ++virtualColumnIndex;
        }
        for (i = virtualColumnIndex; i < this.realColumnsCount; ++i) {
            this.columnsMapping[i] = -1;
        }
    }
}

