/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalLayout
implements LayoutManager {
    private int hgap;
    private int vgap;

    public VerticalLayout() {
        this(10, 10);
    }

    public VerticalLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHGap() {
        return this.hgap;
    }

    public int getVGap() {
        return this.vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int x = insets.left + this.hgap;
            int y = insets.top + this.vgap;
            int w = container.getSize().width - insets.left - insets.right - 2 * this.hgap;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                int h = component.getPreferredSize().height;
                component.setBounds(x, y, w, h);
                y += h + this.vgap;
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int width = insets.left + insets.right + 2 * this.hgap;
            int height = insets.top + insets.bottom + this.vgap;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension preferredDim = component.getPreferredSize();
                width = Math.max(width, preferredDim.width + insets.left + insets.right + 2 * this.hgap);
                height += preferredDim.height + this.vgap;
            }
            return new Dimension(width, height);
        }
    }

    public void removeLayoutComponent(Component comp) {
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ", vgap=" + this.vgap + "]";
    }
}

