/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jvm;

import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.MonitoredData;
import com.sun.tools.visualvm.jvm.JmxSupport;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeans;
import com.sun.tools.visualvm.tools.jvmstat.JvmJvmstatModel;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import sun.jvmstat.monitor.LongMonitor;

public class MonitoredDataImpl
extends MonitoredData {
    private final long loadedClasses;
    private final long sharedLoadedClasses;
    private final long sharedUnloadedClasses;
    private final long unloadedClasses;
    private final long threadsDaemon;
    private final long threadsLive;
    private final long threadsLivePeak;
    private final long threadsStarted;
    private final long applicationTime;
    private final long upTime;
    private final long[] genCapacity;
    private final long[] genUsed;
    private final long[] genMaxCapacity;
    private final Jvm jvm;

    MonitoredDataImpl(Jvm vm, JvmJvmstatModel jvmstatModel) {
        this.loadedClasses = jvmstatModel.getLoadedClasses();
        this.sharedLoadedClasses = jvmstatModel.getSharedLoadedClasses();
        this.sharedUnloadedClasses = jvmstatModel.getSharedUnloadedClasses();
        this.unloadedClasses = jvmstatModel.getUnloadedClasses();
        this.threadsDaemon = jvmstatModel.getThreadsDaemon();
        this.threadsLive = jvmstatModel.getThreadsLive();
        this.threadsLivePeak = jvmstatModel.getThreadsLivePeak();
        this.threadsStarted = jvmstatModel.getThreadsStarted();
        this.applicationTime = 1000L * jvmstatModel.getApplicationTime() / jvmstatModel.getOsFrequency();
        this.upTime = 1000L * jvmstatModel.getUpTime() / jvmstatModel.getOsFrequency();
        this.genCapacity = jvmstatModel.getGenCapacity();
        this.genUsed = jvmstatModel.getGenUsed();
        this.genMaxCapacity = jvmstatModel.getGenMaxCapacity();
        this.jvm = vm;
    }

    MonitoredDataImpl(Jvm vm, JmxSupport jmxSupport, JvmMXBeans jmxModel) {
        ClassLoadingMXBean classBean = jmxModel.getClassLoadingMXBean();
        ThreadMXBean threadBean = jmxModel.getThreadMXBean();
        RuntimeMXBean runtimeBean = jmxModel.getRuntimeMXBean();
        MemoryUsage mem = jmxModel.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage perm = jmxSupport.getPermGenPool().getUsage();
        this.unloadedClasses = classBean.getUnloadedClassCount();
        this.loadedClasses = (long)classBean.getLoadedClassCount() + this.unloadedClasses;
        this.sharedLoadedClasses = 0L;
        this.sharedUnloadedClasses = 0L;
        this.threadsDaemon = threadBean.getDaemonThreadCount();
        this.threadsLive = threadBean.getThreadCount();
        this.threadsLivePeak = threadBean.getPeakThreadCount();
        this.threadsStarted = threadBean.getTotalStartedThreadCount();
        this.applicationTime = 0L;
        this.upTime = runtimeBean.getUptime();
        this.genCapacity = new long[2];
        this.genUsed = new long[2];
        this.genMaxCapacity = new long[2];
        this.genCapacity[0] = mem.getCommitted();
        this.genUsed[0] = mem.getUsed();
        this.genMaxCapacity[0] = mem.getMax();
        this.genCapacity[1] = perm.getCommitted();
        this.genUsed[1] = perm.getUsed();
        this.genMaxCapacity[1] = perm.getMax();
        this.jvm = vm;
    }

    private long getLongValue(LongMonitor mon) {
        if (mon != null) {
            return mon.longValue();
        }
        return 0L;
    }

    public long getLoadedClasses() {
        return this.loadedClasses;
    }

    public long getSharedLoadedClasses() {
        return this.sharedLoadedClasses;
    }

    public long getSharedUnloadedClasses() {
        return this.sharedUnloadedClasses;
    }

    public long getUnloadedClasses() {
        return this.unloadedClasses;
    }

    public long getThreadsDaemon() {
        return this.threadsDaemon;
    }

    public long getThreadsLive() {
        return this.threadsLive;
    }

    public long getThreadsLivePeak() {
        return this.threadsLivePeak;
    }

    public long getThreadsStarted() {
        return this.threadsStarted;
    }

    public long getApplicationTime() {
        return this.applicationTime;
    }

    public Jvm getJVM() {
        return this.jvm;
    }

    public long getUpTime() {
        return this.upTime;
    }

    public long[] getGenCapacity() {
        return this.genCapacity;
    }

    public long[] getGenUsed() {
        return this.genUsed;
    }

    public long[] getGenMaxCapacity() {
        return this.genMaxCapacity;
    }
}

