/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.BatchUpdateException;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.MaterialStatement;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.StatementCallbackInterface;

public class Statement
implements java.sql.Statement,
StatementCallbackInterface {
    public static final int CLOSE_CURRENT_RESULT = 1;
    public static final int KEEP_CURRENT_RESULT = 2;
    public static final int CLOSE_ALL_RESULTS = 3;
    public MaterialStatement materialStatement_ = null;
    Connection connection_;
    public Section section_;
    Agent agent_;
    private java.sql.Statement owner = null;
    ResultSet resultSet_;
    int updateCount_ = -1;
    int returnValueFromProcedure_;
    static final int executeQueryMethod__ = 1;
    static final int executeUpdateMethod__ = 2;
    static final int executeMethod__ = 3;
    protected int sqlMode_ = 0;
    static final int isQuery__ = 1;
    static final int isCall__ = 2;
    static final int isUpdate__ = 4;
    int sqlUpdateMode_ = 0;
    public static final int isCommitSql__ = 1;
    public static final int isRollbackSql__ = 2;
    static final int isPositionedUpdateDeleteSql__ = 16;
    static final int isInsertSql__ = 32;
    static final int isDeleteSql__ = 64;
    static final int isUpdateSql__ = 128;
    ColumnMetaData resultSetMetaData_;
    public Cursor cachedCursor_ = null;
    public Cursor cachedSingletonRowData_ = null;
    boolean isPreparedStatement_ = false;
    String cursorName_ = null;
    boolean openOnClient_ = true;
    boolean openOnServer_ = false;
    protected int indexOfCurrentResultSet_ = -1;
    ResultSet[] resultSetList_ = null;
    protected static final String TIMEOUT_STATEMENT = "SET STATEMENT_TIMEOUT ";
    protected ArrayList timeoutArrayList = new ArrayList(1);
    protected boolean doWriteTimeout = false;
    int timeout_ = 0;
    int maxRows_ = 0;
    int maxFieldSize_ = 0;
    boolean isAutoCommittableStatement_ = true;
    boolean isCatalogQuery_ = false;
    final ArrayList batch_ = new ArrayList();
    public int resultSetType_ = 1003;
    public int resultSetConcurrency_ = 1007;
    public int resultSetHoldability_;
    public int fetchSize_ = 0;
    public int fetchDirection_ = 1000;
    public Cursor singletonRowData_ = null;
    public int numInvisibleRS_ = 0;
    public String cursorAttributesToSendOnPrepare_ = null;
    public PreparedStatement preparedStatementForAutoGeneratedKeys_;
    public ResultSet generatedKeysResultSet_;
    public String[] generatedKeysColumnNames_;
    public int[] generatedKeysColumnIndexes_;
    public int autoGeneratedKeys_ = 2;
    private SqlWarning warnings_ = null;
    protected boolean isPoolable = false;
    private Section setSpecialRegisterSection_ = null;

    private Statement() {
        this.initStatement();
    }

    private void resetStatement() {
        this.initStatement();
    }

    private void initStatement() {
        this.materialStatement_ = null;
        this.connection_ = null;
        this.agent_ = null;
        this.resultSetType_ = 1003;
        this.resultSetConcurrency_ = 1007;
        this.resultSetHoldability_ = 0;
        this.cursorAttributesToSendOnPrepare_ = null;
        if (this.timeoutArrayList.size() == 0) {
            this.timeoutArrayList.add(null);
        }
        this.initResetStatement();
    }

    private void initResetStatement() {
        this.initResetPreparedStatement();
        if (this.section_ != null) {
            this.section_.free();
        }
        if (this.setSpecialRegisterSection_ != null) {
            this.setSpecialRegisterSection_.free();
            this.setSpecialRegisterSection_ = null;
        }
        this.sqlMode_ = 0;
        this.sqlUpdateMode_ = 0;
        this.resultSetMetaData_ = null;
    }

    protected void initResetPreparedStatement() {
        this.warnings_ = null;
        this.resultSet_ = null;
        this.updateCount_ = -1;
        this.returnValueFromProcedure_ = 0;
        this.openOnClient_ = true;
        this.openOnServer_ = false;
        this.indexOfCurrentResultSet_ = -1;
        this.resultSetList_ = null;
        this.isCatalogQuery_ = false;
        this.isAutoCommittableStatement_ = true;
        this.batch_.clear();
        this.singletonRowData_ = null;
        this.numInvisibleRS_ = 0;
        this.preparedStatementForAutoGeneratedKeys_ = null;
        this.generatedKeysResultSet_ = null;
        this.generatedKeysColumnNames_ = null;
        this.generatedKeysColumnIndexes_ = null;
        this.autoGeneratedKeys_ = 2;
        this.resetUserControllableAttributes();
    }

    private void resetUserControllableAttributes() {
        this.cursorName_ = null;
        this.timeout_ = 0;
        this.doWriteTimeout = false;
        this.maxRows_ = 0;
        this.maxFieldSize_ = 0;
        this.fetchSize_ = 0;
        this.fetchDirection_ = 1000;
        this.isPoolable = this.isPreparedStatement_;
    }

    public void reset(boolean bl) throws SqlException {
        if (bl) {
            this.connection_.resetStatement(this);
        } else {
            this.initResetStatement();
            this.materialStatement_.reset_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetForReuse() throws SqlException {
        this.batch_.clear();
        this.clearWarningsX();
        int n = 0;
        if (this.resultSetList_ != null) {
            n = this.resultSetList_.length;
        }
        try {
            if (this.willTickleServer(n, this.connection_.autoCommit_)) {
                this.flowClose();
            } else {
                this.flowCloseOutsideUOW();
            }
        }
        finally {
            this.markResultSetsClosed();
            this.removeClientCursorNameFromCache();
            this.markPreparedStatementForAutoGeneratedKeysClosed();
            if (this.setSpecialRegisterSection_ != null) {
                this.setSpecialRegisterSection_.free();
                this.setSpecialRegisterSection_ = null;
            }
            this.resetUserControllableAttributes();
        }
    }

    public Statement(Agent agent, Connection connection) throws SqlException {
        this();
        this.initStatement(agent, connection);
    }

    public void resetStatement(Agent agent, Connection connection) throws SqlException {
        this.resetStatement();
        this.initStatement(agent, connection);
    }

    private void initStatement(Agent agent, Connection connection) {
        this.agent_ = agent;
        this.connection_ = connection;
    }

    public Statement(Agent agent, Connection connection, int n, int n2, int n3, int n4, String[] stringArray, int[] nArray) throws SqlException {
        this(agent, connection);
        this.initStatement(n, n2, n3, n4, stringArray, nArray);
    }

    public void resetStatement(Agent agent, Connection connection, int n, int n2, int n3, int n4, String[] stringArray, int[] nArray) throws SqlException {
        this.resetStatement(agent, connection);
        this.initStatement(n, n2, n3, n4, stringArray, nArray);
    }

    private void initStatement(int n, int n2, int n3, int n4, String[] stringArray, int[] nArray) throws SqlException {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                this.resultSetType_ = n;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Integer(n), (Object)"type", "createStatement()");
            }
        }
        switch (n2) {
            case 1007: 
            case 1008: {
                this.resultSetConcurrency_ = n2;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Integer(n2), (Object)"concurrency", "createStatement()");
            }
        }
        switch (n3) {
            case 1: 
            case 2: {
                this.resultSetHoldability_ = n3;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Integer(n3), (Object)"holdability", "createStatement()");
            }
        }
        switch (n4) {
            case 1: 
            case 2: {
                this.autoGeneratedKeys_ = n4;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Integer(n4), (Object)"autoGeneratedKeys", "createStatement");
            }
        }
        this.generatedKeysColumnNames_ = stringArray;
        this.generatedKeysColumnIndexes_ = nArray;
    }

    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize");
        }
        if (this.openOnClient_) {
            this.markClosed();
        }
        super.finalize();
    }

    protected SqlWarning getSqlWarnings() {
        return this.warnings_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "executeQuery", string);
                }
                ResultSet resultSet = this.executeQueryX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeQuery", resultSet);
                }
                return resultSet;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private ResultSet executeQueryX(String string) throws SqlException {
        this.flowExecute(1, string);
        return this.resultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", string);
                }
                int n = this.executeUpdateX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", n);
                }
                return n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private int executeUpdateX(String string) throws SqlException {
        this.flowExecute(2, string);
        return this.updateCount_;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        try {
            this.checkForClosedStatement();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return clazz.isInstance(this);
    }

    public boolean isClosed() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "isClosed", !this.openOnClient_);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isClosed", !this.openOnClient_);
        }
        return !this.openOnClient_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "close");
                }
                this.closeX();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeX() throws SqlException {
        if (!this.openOnClient_) {
            return;
        }
        int n = this.resultSetList_ == null ? 0 : this.resultSetList_.length;
        boolean bl = this.willTickleServer(n, true);
        try {
            if (bl) {
                this.flowClose();
            } else {
                this.flowCloseOutsideUOW();
            }
        }
        finally {
            this.markClosed(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPoolable() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "isPoolable");
                }
                this.checkForClosedStatement();
                return this.isPoolable;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolable(boolean bl) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setPoolable", bl);
                }
                this.checkForClosedStatement();
                this.isPoolable = bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getMaxFieldSize");
            }
            this.checkForClosedStatement();
            return this.maxFieldSize_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxFieldSize(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setMaxFieldSize", n);
                }
                this.checkForClosedStatement();
                if (n < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ066.S"), new Integer(n));
                }
                this.maxFieldSize_ = n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getMaxRows", this.maxRows_);
            }
            return this.maxRows_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRows(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setMaxRows", n);
                }
                this.checkForClosedStatement();
                if (n < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ063.S"), new Integer(n));
                }
                this.maxRows_ = n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setEscapeProcessing", bl);
                }
                this.checkForClosedStatement();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getQueryTimeout", this.timeout_);
            }
            return this.timeout_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryTimeout(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setQueryTimeout", n);
                }
                this.checkForClosedStatement();
                if (n < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ074.S"), new Integer(n));
                }
                if (n != this.timeout_) {
                    this.timeout_ = n;
                    this.doWriteTimeout = true;
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void cancel() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "cancel");
            }
            this.checkForClosedStatement();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.4"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getWarnings", this.warnings_);
        }
        try {
            this.checkForClosedStatement();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return this.warnings_ == null ? null : this.warnings_.getSQLWarning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearWarnings");
            }
            try {
                this.checkForClosedStatement();
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
            this.clearWarningsX();
        }
    }

    final void clearWarningsX() {
        this.warnings_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorName(String string) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setCursorName", string);
                }
                this.checkForClosedStatement();
                if (string == null || string.equals("")) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ202.S"), string);
                }
                if (this.resultSet_ != null && this.resultSet_.openOnClient_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0X95.S"), (Object)"setCursorName()", "Statement");
                }
                this.cursorName_ = string;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "execute", string);
                }
                boolean bl = this.executeX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    boolean executeX(String string) throws SqlException {
        this.flowExecute(3, string);
        return this.resultSet_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getResultSet() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getResultSet");
                }
                this.checkForClosedStatement();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getResultSet", this.resultSet_);
                }
                return this.resultSet_;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUpdateCount() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getUpdateCount");
                }
                this.checkForClosedStatement();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getUpdateCount", this.updateCount_);
                }
                return this.updateCount_;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getMoreResults");
                }
                boolean bl = this.getMoreResultsX(3);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getMoreResults", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setFetchDirection", n);
                }
                this.checkForClosedStatement();
                switch (n) {
                    case 1000: 
                    case 1001: 
                    case 1002: {
                        this.fetchDirection_ = n;
                        break;
                    }
                    default: {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ064.S"), new Integer(n));
                    }
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchDirection", this.fetchDirection_);
            }
            return this.fetchDirection_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setFetchSize", n);
                }
                this.checkForClosedStatement();
                if (n < 0 || this.maxRows_ != 0 && n > this.maxRows_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ065.S"), new Integer(n)).getSQLException();
                }
                this.fetchSize_ = n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchSize", this.fetchSize_);
            }
            return this.fetchSize_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getResultSetConcurrency", this.resultSetConcurrency_);
            }
            return this.resultSetConcurrency_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getResultSetType", this.resultSetType_);
            }
            return this.resultSetType_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(String string) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "addBatch", string);
                }
                this.checkForClosedStatement();
                string = this.connection_.nativeSQLX(string);
                this.batch_.add(string);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBatch() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "clearBatch");
                }
                this.checkForClosedStatement();
                this.batch_.clear();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeBatch");
                }
                int[] nArray = this.executeBatchX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeBatch", nArray);
                }
                return nArray;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private int[] executeBatchX() throws SqlException, BatchUpdateException {
        this.checkForClosedStatement();
        this.clearWarningsX();
        this.resultSetList_ = null;
        int[] nArray = new int[this.batch_.size()];
        Arrays.fill(nArray, -3);
        this.flowExecuteBatch(nArray);
        return nArray;
    }

    public java.sql.Connection getConnection() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getConnection", this.connection_);
            }
            return this.connection_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getMoreResults", n);
                }
                boolean bl = this.getMoreResultsX(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getMoreResults", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean getMoreResultsX(int n) throws SqlException {
        boolean bl;
        this.checkForClosedStatement();
        this.updateCount_ = -1;
        if (this.resultSetList_ == null) {
            if (this.resultSet_ != null) {
                if (n != 2) {
                    this.resultSet_.closeX();
                }
                this.resultSet_ = null;
            }
            bl = false;
        } else {
            if (this.numInvisibleRS_ == 0 && n == 1 && this.resultSetList_[this.indexOfCurrentResultSet_] != null) {
                this.resultSetList_[this.indexOfCurrentResultSet_].closeX();
            }
            boolean bl2 = bl = this.indexOfCurrentResultSet_ + 1 < this.resultSetList_.length;
        }
        if (n == 3 && this.numInvisibleRS_ == 0) {
            int n2 = this.resultSetList_ == null ? 0 : this.indexOfCurrentResultSet_ + 1;
            boolean bl3 = this.willTickleServer(n2, false);
            if (bl3) {
                this.flowCloseRetrievedResultSets();
            } else {
                this.flowCloseRetrievedResultSetsOutsideUOW();
            }
        }
        this.resultSet_ = bl ? this.resultSetList_[++this.indexOfCurrentResultSet_] : null;
        return bl;
    }

    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getGeneratedKeys");
            }
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getGeneratedKeys", this.generatedKeysResultSet_);
            }
            return this.generatedKeysResultSet_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", (Object)string, n);
                }
                this.autoGeneratedKeys_ = n;
                int n2 = this.executeUpdateX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", n2);
                }
                return n2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", (Object)string, (Object)nArray);
                }
                if (nArray != null && nArray.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                }
                this.generatedKeysColumnIndexes_ = nArray;
                int n = this.executeUpdateX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", n);
                }
                return n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", (Object)string, (Object)stringArray);
                }
                if (stringArray != null && stringArray.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                }
                this.generatedKeysColumnNames_ = stringArray;
                int n = this.executeUpdateX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", n);
                }
                return n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string, int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)string, n);
                }
                this.autoGeneratedKeys_ = n;
                boolean bl = this.executeX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)string, (Object)nArray);
                }
                if (nArray != null && nArray.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                }
                this.generatedKeysColumnIndexes_ = nArray;
                boolean bl = this.executeX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)string, (Object)stringArray);
                }
                if (stringArray != null && stringArray.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                }
                this.generatedKeysColumnNames_ = stringArray;
                boolean bl = this.executeX(string);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getResultSetHoldability");
            }
            this.checkForClosedStatement();
            return this.resultSetHoldability_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void writeSetSpecialRegister(ArrayList arrayList) throws SqlException {
        if (this.setSpecialRegisterSection_ == null) {
            this.setSpecialRegisterSection_ = this.agent_.sectionManager_.getDynamicSection(1);
        }
        this.materialStatement_.writeSetSpecialRegister_(this.setSpecialRegisterSection_, arrayList);
    }

    public void readSetSpecialRegister() throws SqlException {
        this.materialStatement_.readSetSpecialRegister_();
    }

    public void writeExecuteImmediate(String string, Section section) throws SqlException {
        this.materialStatement_.writeExecuteImmediate_(string, section);
    }

    public void readExecuteImmediate() throws SqlException {
        this.materialStatement_.readExecuteImmediate_();
    }

    public void completeExecuteImmediate(Sqlca sqlca) {
        int n = this.completeSqlca(sqlca);
        if (n < 0) {
            return;
        }
        if (sqlca != null) {
            this.updateCount_ = sqlca.getUpdateCount();
        }
    }

    public void readExecuteImmediateForBatch(String string) throws SqlException {
        this.materialStatement_.readExecuteImmediateForBatch_(string);
    }

    public void writePrepareDescribeOutput(String string, Section section) throws SqlException {
        this.materialStatement_.writePrepareDescribeOutput_(string, section);
    }

    public void readPrepareDescribeOutput() throws SqlException {
        this.materialStatement_.readPrepareDescribeOutput_();
    }

    public void completePrepareDescribeOutput(ColumnMetaData columnMetaData, Sqlca sqlca) {
        this.completePrepare(sqlca);
        this.resultSetMetaData_ = columnMetaData;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceResultSetMetaData(this, this.resultSetMetaData_);
        }
    }

    public void writePrepare(String string, Section section) throws SqlException {
        this.materialStatement_.writePrepare_(string, section);
    }

    public void readPrepare() throws SqlException {
        this.materialStatement_.readPrepare_();
    }

    public void completePrepare(Sqlca sqlca) {
        int n = this.completeSqlca(sqlca);
        if (n < 0) {
            return;
        }
        this.markPrepared();
    }

    public void writeOpenQuery(Section section, int n, int n2) throws SqlException {
        this.materialStatement_.writeOpenQuery_(section, n, n2);
    }

    public void readOpenQuery() throws SqlException {
        this.materialStatement_.readOpenQuery_();
    }

    public void completeOpenQuery(Sqlca sqlca, ResultSet resultSet) {
        this.completeSqlca(sqlca);
        this.resultSet_ = resultSet;
        if (resultSet == null) {
            return;
        }
        resultSet.resultSetMetaData_ = this.resultSetMetaData_;
        resultSet.resultSetMetaData_.resultSetConcurrency_ = resultSet.resultSetConcurrency_;
        resultSet.createLOBColumnTracker();
        if (this.cachedCursor_ == null && this.isPreparedStatement_) {
            this.cachedCursor_ = this.resultSet_.cursor_;
        }
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            return;
        }
        this.openOnServer_ = true;
        resultSet.cursor_.rowsRead_ = 0;
        if (this.resultSet_.fetchSize_ == 0 && (this.resultSet_.resultSetType_ == 1004 || this.resultSet_.resultSetType_ == 1005)) {
            this.resultSet_.setFetchSize_(64);
        }
    }

    public void completeExecuteCallOpenQuery(Sqlca sqlca, ResultSet resultSet, ColumnMetaData columnMetaData, Section section) {
        resultSet.completeSqlca(sqlca);
        resultSet.resultSetMetaData_ = columnMetaData;
        resultSet.createLOBColumnTracker();
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            return;
        }
        this.openOnServer_ = true;
        resultSet.cursor_.rowsRead_ = 0;
        resultSet.generatedSection_ = section;
        if (resultSet.fetchSize_ == 0) {
            resultSet.fetchSize_ = 64;
        }
    }

    public void writeExecuteCall(boolean bl, String string, Section section, int n, boolean bl2, int n2, ColumnMetaData columnMetaData, Object[] objectArray) throws SqlException {
        this.materialStatement_.writeExecuteCall_(bl, string, section, n, bl2, n2, columnMetaData, objectArray);
    }

    public void readExecuteCall() throws SqlException {
        this.materialStatement_.readExecuteCall_();
    }

    public void completeExecuteCall(Sqlca sqlca, Cursor cursor, ResultSet[] resultSetArray) {
        this.completeExecuteCall(sqlca, cursor);
        this.resultSetList_ = resultSetArray;
        if (resultSetArray != null) {
            this.resultSet_ = resultSetArray[0];
        }
        this.indexOfCurrentResultSet_ = 0;
    }

    public void completeExecuteCall(Sqlca sqlca, Cursor cursor) {
        this.completeExecute(sqlca);
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            this.singletonRowData_ = null;
        } else {
            this.singletonRowData_ = cursor;
            if (this.cachedSingletonRowData_ == null && this.isPreparedStatement_) {
                this.cachedSingletonRowData_ = this.singletonRowData_;
            }
        }
    }

    public void completeExecute(Sqlca sqlca) {
        if (sqlca == null) {
            return;
        }
        int n = sqlca.getSqlCode();
        if (n < 0) {
            this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
            this.returnValueFromProcedure_ = n;
        } else {
            this.updateCount_ = sqlca.getUpdateCount();
            if (this.sqlMode_ == 2) {
                this.updateCount_ = -1;
                this.returnValueFromProcedure_ = sqlca.getSqlErrd()[0];
            }
            if (n > 0 && n != 466 && n != 100) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
            }
        }
    }

    public void setUpdateCount(int n) {
        this.updateCount_ = n;
    }

    protected final void setOwner(java.sql.Statement statement) {
        this.owner = statement;
    }

    final java.sql.Statement getOwner() {
        return this.owner;
    }

    private boolean willTickleServer(int n, boolean bl) throws SqlException {
        boolean bl2 = false;
        if (this.resultSetList_ != null) {
            for (int i = 0; i < n; ++i) {
                if (this.resultSetList_[i] == null) continue;
                if (this.resultSetList_[i].openOnServer_) {
                    return true;
                }
                if (this.resultSetList_[i].autoCommitted_ || !bl) continue;
                bl2 = true;
            }
        } else if (this.generatedKeysResultSet_ != null && this.generatedKeysResultSet_.openOnServer_) {
            this.generatedKeysResultSet_.writeClose();
        } else if (this.resultSet_ != null) {
            if (this.resultSet_.openOnServer_) {
                return true;
            }
            if (!this.resultSet_.autoCommitted_ && bl) {
                bl2 = true;
            }
        }
        if (this.connection_.autoCommit_ && bl2) {
            if (this.connection_.isXAConnection_) {
                return this.connection_.getXAState() == 0;
            }
            return true;
        }
        return false;
    }

    private void flowClose() throws SqlException {
        this.agent_.beginWriteChain(this);
        this.writeClose(true);
        this.agent_.flow(this);
        this.readClose(true);
        this.agent_.endReadChain();
    }

    private void flowCloseOutsideUOW() throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeClose(true);
        this.agent_.flowOutsideUOW();
        this.readClose(true);
        this.agent_.endReadChain();
    }

    final void writeClose(boolean bl) throws SqlException {
        this.writeCloseResultSets(bl);
    }

    final void readClose(boolean bl) throws SqlException {
        this.readCloseResultSets(bl);
    }

    final boolean writeCloseResultSets(boolean bl) throws SqlException {
        int n = this.resultSetList_ == null ? 0 : this.resultSetList_.length;
        return this.writeCloseResultSets(n, bl);
    }

    boolean writeCloseResultSets(int n, boolean bl) throws SqlException {
        boolean bl2 = false;
        if (this.resultSetList_ != null) {
            for (int i = 0; i < n; ++i) {
                if (this.resultSetList_[i] == null) continue;
                if (this.resultSetList_[i].openOnServer_) {
                    this.resultSetList_[i].writeClose();
                }
                if (this.resultSetList_[i].autoCommitted_ || !bl) continue;
                bl2 = true;
            }
        } else if (this.generatedKeysResultSet_ != null && this.generatedKeysResultSet_.openOnServer_) {
            this.generatedKeysResultSet_.writeClose();
        } else if (this.resultSet_ != null) {
            if (this.resultSet_.openOnServer_) {
                this.resultSet_.writeClose();
            }
            if (!this.resultSet_.autoCommitted_ && bl) {
                bl2 = true;
            }
        }
        if (this.connection_.autoCommit_ && bl2 && this.isAutoCommittableStatement_) {
            this.connection_.writeAutoCommit();
            if (this.connection_.isXAConnection_) {
                return this.connection_.getXAState() == 0;
            }
            return true;
        }
        return false;
    }

    final void readCloseResultSets(boolean bl) throws SqlException {
        int n = this.resultSetList_ == null ? 0 : this.resultSetList_.length;
        this.readCloseResultSets(n, bl);
    }

    void readCloseResultSets(int n, boolean bl) throws SqlException {
        boolean bl2 = false;
        if (this.resultSetList_ != null) {
            for (int i = 0; i < n; ++i) {
                if (this.resultSetList_[i] == null) continue;
                if (this.resultSetList_[i].openOnServer_) {
                    this.resultSetList_[i].readClose();
                } else {
                    this.resultSetList_[i].markClosed();
                }
                if (this.resultSetList_[i].autoCommitted_ || !bl) continue;
                bl2 = true;
            }
        } else if (this.generatedKeysResultSet_ != null) {
            if (this.generatedKeysResultSet_.openOnServer_) {
                this.generatedKeysResultSet_.readClose();
            } else {
                this.generatedKeysResultSet_.markClosed();
            }
        } else if (this.resultSet_ != null) {
            if (this.resultSet_.openOnServer_) {
                this.resultSet_.readClose();
            } else {
                this.resultSet_.markClosed();
            }
            if (!this.resultSet_.autoCommitted_ && bl) {
                bl2 = true;
            }
        }
        if (this.connection_.autoCommit_ && bl2 && this.isAutoCommittableStatement_) {
            this.connection_.readAutoCommit();
        }
    }

    private void flowCloseRetrievedResultSets() throws SqlException {
        int n = this.resultSetList_ == null ? 0 : this.indexOfCurrentResultSet_ + 1;
        this.agent_.beginWriteChain(this);
        this.writeCloseResultSets(n, false);
        this.agent_.flow(this);
        this.readCloseResultSets(n, false);
        this.agent_.endReadChain();
    }

    private void flowCloseRetrievedResultSetsOutsideUOW() throws SqlException {
        int n = this.resultSetList_ == null ? 0 : this.indexOfCurrentResultSet_ + 1;
        this.agent_.beginWriteChainOutsideUOW();
        this.writeCloseResultSets(n, false);
        this.agent_.flowOutsideUOW();
        this.readCloseResultSets(n, false);
        this.agent_.endReadChain();
    }

    public int completeSqlca(Sqlca sqlca) {
        if (sqlca == null) {
            return 0;
        }
        int n = sqlca.getSqlCode();
        if (n < 0) {
            this.connection_.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
        } else if (n > 0) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
        }
        return n;
    }

    public void completeExecuteSetStatement(Sqlca sqlca) {
    }

    void markClosedOnServer() {
        if (this.section_ != null) {
            this.section_.free();
            this.section_ = null;
        }
        this.openOnServer_ = false;
        if (this.materialStatement_ != null) {
            this.materialStatement_.markClosedOnServer_();
        }
    }

    void markClosed() {
        this.markClosed(false);
    }

    void markClosed(boolean bl) {
        this.openOnClient_ = false;
        this.markResultSetsClosed();
        this.removeClientCursorNameFromCache();
        this.markPreparedStatementForAutoGeneratedKeysClosed();
        this.markClosedOnServer();
        if (this.resultSetMetaData_ != null) {
            this.resultSetMetaData_.markClosed();
            this.resultSetMetaData_ = null;
        }
        if (bl) {
            this.connection_.openStatements_.remove(this);
        }
        if (this.setSpecialRegisterSection_ != null) {
            this.setSpecialRegisterSection_.free();
            this.setSpecialRegisterSection_ = null;
        }
    }

    void markPreparedStatementForAutoGeneratedKeysClosed() {
        if (this.preparedStatementForAutoGeneratedKeys_ != null) {
            this.preparedStatementForAutoGeneratedKeys_.markClosed();
        }
    }

    void markResultSetsClosed() {
        this.markResultSetsClosed(false);
    }

    final void markResultSetsClosed(boolean bl) {
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                if (this.resultSetList_[i] != null) {
                    this.resultSetList_[i].markClosed(bl);
                }
                this.resultSetList_[i] = null;
            }
        }
        if (this.generatedKeysResultSet_ != null) {
            this.generatedKeysResultSet_.markClosed(bl);
        }
        if (this.resultSet_ != null) {
            this.resultSet_.markClosed(bl);
        }
        this.resultSet_ = null;
        this.resultSetList_ = null;
        this.generatedKeysResultSet_ = null;
    }

    private void flowExecute(int n, String string) throws SqlException {
        this.checkForClosedStatement();
        this.clearWarningsX();
        string = this.escape(string);
        this.parseSqlAndSetSqlModes(string);
        this.checkAutoGeneratedKeysParameters();
        this.updateCount_ = this.sqlMode_ == 4 ? 0 : -1;
        this.checkForAppropriateSqlMode(n, this.sqlMode_);
        if (this.sqlMode_ == 1) {
            this.checkForDuplicateCursorName();
        }
        boolean bl = false;
        this.agent_.beginWriteChain(this);
        boolean bl2 = this.writeCloseResultSets(true);
        ResultSet resultSet = null;
        Section section = null;
        boolean bl3 = false;
        if (this.doWriteTimeout && this.timeout_ > 0) {
            this.timeoutArrayList.set(0, TIMEOUT_STATEMENT + this.timeout_);
            this.writeSetSpecialRegister(this.timeoutArrayList);
            bl = true;
        }
        switch (this.sqlMode_) {
            case 1: {
                section = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
                this.writePrepareDescribeOutput(string, section);
                this.writeOpenQuery(section, this.fetchSize_, this.resultSetType_);
                break;
            }
            case 4: {
                String[] stringArray;
                String string2 = null;
                if ((this.sqlUpdateMode_ == 64 || this.sqlUpdateMode_ == 128) && (stringArray = this.extractCursorNameFromWhereCurrentOf(string)) != null) {
                    string2 = stringArray[0];
                    string = stringArray[1];
                }
                if (string2 != null) {
                    section = this.agent_.sectionManager_.getPositionedUpdateSection(string2, true);
                    if (section == null) {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ202.S"), string2);
                    }
                    resultSet = this.agent_.sectionManager_.getPositionedUpdateResultSet(string2);
                    if (resultSet != null && !resultSet.isRowsetCursor_ && !(bl3 = resultSet.repositionScrollableResultSetBeforeJDBC1PositionedUpdateDelete())) {
                        resultSet = null;
                    }
                    if (section.getClientCursorName() != null && string2.compareTo(section.getClientCursorName()) == 0) {
                        string = this.substituteClientCursorNameWithServerCursorName(string, section);
                    }
                    this.writeExecuteImmediate(string, section);
                } else {
                    section = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
                    this.writeExecuteImmediate(string, section);
                    if (this.sqlUpdateMode_ == 32 && this.autoGeneratedKeys_ == 1) {
                        this.prepareAutoGeneratedKeysStatement();
                        this.writeOpenQuery(this.preparedStatementForAutoGeneratedKeys_.section_, this.preparedStatementForAutoGeneratedKeys_.fetchSize_, this.preparedStatementForAutoGeneratedKeys_.resultSetType_);
                    }
                }
                if (!this.connection_.autoCommit_) break;
                this.connection_.writeAutoCommit();
                break;
            }
            case 2: {
                section = this.writeExecuteCall(string, false);
            }
        }
        this.agent_.flow(this);
        this.readCloseResultSets(true);
        if (bl) {
            this.readSetSpecialRegister();
        }
        if (bl2) {
            this.connection_.completeTransactionStart();
        }
        this.markResultSetsClosed(true);
        this.markClosedOnServer();
        this.section_ = section;
        switch (this.sqlMode_) {
            case 1: {
                this.readPrepareDescribeOutput();
                this.readOpenQuery();
                if (this.resultSet_ == null) break;
                this.resultSet_.parseScrollableRowset();
                this.setupCursorNameCacheAndMappings();
                break;
            }
            case 4: {
                if (resultSet != null && !resultSet.isRowsetCursor_) {
                    resultSet.readPositioningFetch_();
                }
                this.readExecuteImmediate();
                if (this.sqlUpdateMode_ == 32 && this.autoGeneratedKeys_ == 1) {
                    this.readPrepareAutoGeneratedKeysStatement();
                    this.preparedStatementForAutoGeneratedKeys_.readOpenQuery();
                    this.generatedKeysResultSet_ = this.preparedStatementForAutoGeneratedKeys_.resultSet_;
                    this.preparedStatementForAutoGeneratedKeys_.resultSet_ = null;
                }
                if (!this.connection_.autoCommit_) break;
                this.connection_.readAutoCommit();
                break;
            }
            case 2: {
                this.readPrepare();
                this.readExecuteCall();
            }
        }
        this.agent_.endReadChain();
        if (this.resultSet_ != null && this.resultSet_.resultSetHoldability_ != this.resultSetHoldability_ && this.sqlMode_ != 2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ204.S"), new Integer(this.resultSetHoldability_));
        }
        if (this.sqlMode_ == 2) {
            this.parseStorProcReturnedScrollableRowset();
            this.checkForStoredProcResultSetCount(n);
            if (this.connection_.autoCommit_ && this.resultSet_ == null && this.resultSetList_ == null) {
                this.connection_.flowAutoCommit();
            }
        }
        if (n == 2 && this.updateCount_ < 0) {
            this.updateCount_ = 0;
        }
    }

    void flowExecuteBatch(int[] nArray) throws SqlException, BatchUpdateException {
        String string;
        int n;
        SqlException sqlException = null;
        boolean bl = true;
        this.agent_.beginBatchedWriteChain(this);
        for (n = 0; n < this.batch_.size(); ++n) {
            boolean bl2 = true;
            string = (String)this.batch_.get(n);
            this.parseSqlAndSetSqlModes(string);
            try {
                this.checkForInvalidBatchedSql(string);
            }
            catch (SqlException sqlException2) {
                bl2 = false;
            }
            if (!bl2) continue;
            if (this.section_ != null) {
                this.section_.free();
            }
            if (this.sqlMode_ != 2) {
                this.section_ = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
                this.writeExecuteImmediate(string, this.section_);
                continue;
            }
            this.section_ = this.writeExecuteCall(string, true);
        }
        if (this.connection_.autoCommit_) {
            this.connection_.writeAutoCommit();
        }
        this.agent_.flowBatch(this, this.batch_.size());
        try {
            for (n = 0; n < this.batch_.size(); ++n) {
                this.agent_.setBatchedExceptionLabelIndex(n);
                SqlException sqlException3 = null;
                string = (String)this.batch_.get(n);
                this.parseSqlAndSetSqlModes(string);
                try {
                    this.checkForInvalidBatchedSql(string);
                }
                catch (SqlException sqlException4) {
                    sqlException3 = sqlException4;
                }
                if (sqlException3 == null) {
                    this.updateCount_ = -1;
                    if (this.sqlMode_ != 2) {
                        this.readExecuteImmediateForBatch(string);
                    } else {
                        if (bl) {
                            this.readPrepare();
                        }
                        this.readExecuteCall();
                    }
                } else {
                    this.agent_.accumulateReadException(sqlException3);
                    this.updateCount_ = -3;
                    sqlException3 = null;
                }
                nArray[n] = this.updateCount_;
                if (nArray[n] != -1) continue;
                nArray[n] = 0;
            }
            this.agent_.disableBatchedExceptionTracking();
            if (this.connection_.autoCommit_) {
                this.connection_.readAutoCommit();
            }
        }
        catch (SqlException sqlException5) {
            sqlException = sqlException5;
            sqlException.setNextException(new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ211.S")));
        }
        this.batch_.clear();
        this.agent_.endBatchedReadChain(nArray, sqlException);
    }

    private Section writeExecuteCall(String string, boolean bl) throws SqlException {
        Section section = null;
        section = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
        this.writePrepare(string, section);
        this.writeExecuteCall(false, null, section, this.fetchSize_, bl, this.resultSetType_, null, null);
        return section;
    }

    public void listenToUnitOfWork() {
    }

    public void completeLocalCommit(Iterator iterator) {
    }

    public void completeLocalRollback(Iterator iterator) {
    }

    public void accumulateWarning(SqlWarning sqlWarning) {
        if (this.warnings_ == null) {
            this.warnings_ = sqlWarning;
        } else {
            this.warnings_.setNextWarning(sqlWarning);
        }
    }

    private void markPrepared() {
        this.openOnServer_ = true;
        this.listenToUnitOfWork();
    }

    protected String getJdbcStatementInterfaceName() {
        return "java.sql.Statement";
    }

    void parseSqlAndSetSqlModes(String string) throws SqlException {
        String string2 = "\t\n\r\f=? (";
        StringTokenizer stringTokenizer = null;
        String string3 = null;
        if (string.trim().startsWith("--")) {
            int n = -1;
            String string4 = "\n\r\f";
            stringTokenizer = new StringTokenizer(string, string4, true);
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (string4.indexOf(string3) != -1) {
                    n = string.indexOf(string3, n + 1);
                    continue;
                }
                if (string3.trim().startsWith("--")) continue;
            }
            if (string3.startsWith("--")) {
                this.sqlMode_ = 1;
                return;
            }
            stringTokenizer = new StringTokenizer(string.substring(n + 1), string2);
        } else {
            stringTokenizer = new StringTokenizer(string, string2);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ206.S"), string);
        }
        this.sqlUpdateMode_ = 0;
        string3 = stringTokenizer.nextToken();
        if (string3.equalsIgnoreCase("select") || string3.equalsIgnoreCase("values")) {
            this.sqlMode_ = 1;
        } else if (string3.equalsIgnoreCase("call")) {
            this.sqlMode_ = 2;
        } else {
            this.parseUpdateSql(string3);
        }
    }

    private void parseUpdateSql(String string) throws SqlException {
        this.sqlMode_ = 4;
        if (string.equalsIgnoreCase("insert")) {
            this.sqlUpdateMode_ = 32;
        }
        if (string.equalsIgnoreCase("delete")) {
            this.sqlUpdateMode_ = 64;
        }
        if (string.equalsIgnoreCase("update")) {
            this.sqlUpdateMode_ = 128;
        }
    }

    String getProcedureName(String string) throws SqlException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t\n\r\f= (?");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ206.S"), string);
        }
        String string2 = stringTokenizer.nextToken();
        if (!string2.equalsIgnoreCase("call")) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("42X74"));
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("42X74"));
        }
        return stringTokenizer.nextToken();
    }

    public static String upperCaseProcedureName(String string) throws SqlException {
        char[] cArray = null;
        if (string.indexOf("\"") == -1) {
            return string.toUpperCase();
        }
        cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\"') {
                bl = !bl;
                continue;
            }
            if (bl || cArray[i] == '.') continue;
            cArray[i] = Character.toUpperCase(cArray[i]);
        }
        return new String(cArray);
    }

    final void checkForAppropriateSqlMode(int n, int n2) throws SqlException {
        if (n == 1 && n2 == 4) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ207.S"));
        }
        if (n == 2 && n2 == 1) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0Y79.S"));
        }
    }

    private void checkResultSetCount(int n) throws SqlException {
        switch (n) {
            case 1: {
                if (this.resultSetList_ != null && this.resultSetList_.length > 1) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0Y78.S.1"), (Object)this.getJdbcStatementInterfaceName(), this.getJdbcStatementInterfaceName());
                }
                if (this.resultSet_ != null && this.resultSetList_.length != 0) break;
                ClientMessageId clientMessageId = new ClientMessageId("X0Y78.S.2");
                throw new SqlException(this.agent_.logWriter_, clientMessageId, (Object)this.getJdbcStatementInterfaceName(), this.getJdbcStatementInterfaceName());
            }
            case 2: {
                if (this.resultSet_ == null || this.resultSetList_.length <= 0) break;
                ClientMessageId clientMessageId = new ClientMessageId("X0Y79.S");
                throw new SqlException(this.agent_.logWriter_, clientMessageId);
            }
        }
    }

    protected final void checkForStoredProcResultSetCount(int n) throws SqlException {
        try {
            this.checkResultSetCount(n);
        }
        catch (SqlException sqlException) {
            if (this.connection_.autoCommit_) {
                this.connection_.flowRollback();
            }
            throw sqlException;
        }
    }

    final void checkForClosedStatement() throws SqlException {
        if (this.connection_ == null || this.connection_.isClosed()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08003"));
        }
        if (!this.openOnClient_) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ012.S"), "Statement");
        }
        this.agent_.checkForDeferredExceptions();
    }

    void checkForInvalidBatchedSql(String string) throws SqlException {
        if (string == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ067.S"));
        }
        if (this.sqlMode_ != 2 && (this.sqlMode_ != 4 || this.sqlUpdateMode_ != 32 && this.sqlUpdateMode_ != 64 && this.sqlUpdateMode_ != 128 && this.sqlUpdateMode_ != 0)) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("42ZA1"), string);
        }
    }

    protected void checkForDuplicateCursorName() throws SqlException {
        if (this.cursorName_ != null && this.connection_.clientCursorNameCache_.containsKey(this.cursorName_)) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ203.S"), this.cursorName_);
        }
    }

    protected void setupCursorNameCacheAndMappings() {
        if (this.cursorName_ != null) {
            this.agent_.sectionManager_.mapCursorNameToQuerySection(this.cursorName_, this.section_);
            this.section_.setClientCursorName(this.cursorName_);
            this.connection_.clientCursorNameCache_.put(this.cursorName_, this.cursorName_);
        } else {
            this.agent_.sectionManager_.mapCursorNameToQuerySection(this.section_.getServerCursorName(), this.section_);
        }
        this.mapCursorNameToResultSet();
    }

    String[] extractCursorNameFromWhereCurrentOf(String string) {
        int n;
        String string2 = string.toLowerCase();
        int n2 = string2.lastIndexOf("current");
        if (n2 != -1 && (n = string2.lastIndexOf("where")) != -1) {
            String[] stringArray = new String[]{"where", "current", "of"};
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n));
            while (stringTokenizer.hasMoreTokens()) {
                String string3;
                if (!stringTokenizer.nextToken().equalsIgnoreCase(stringArray[0]) || !stringTokenizer.nextToken().equalsIgnoreCase(stringArray[1]) || !stringTokenizer.nextToken().equalsIgnoreCase(stringArray[2])) continue;
                String string4 = string3 = stringTokenizer.nextToken();
                int n3 = string3.length();
                int n4 = string.lastIndexOf(string3);
                string3 = string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"' ? string3.substring(1, string3.length() - 1) : string3.toUpperCase();
                string = string.length() > n4 + n3 ? string.substring(0, n4) + string3 + string.substring(n4 + string4.length(), string.length()) : string.substring(0, n4) + string3;
                return new String[]{string3, string};
            }
        }
        return null;
    }

    protected String substituteClientCursorNameWithServerCursorName(String string, Section section) throws SqlException {
        String string2 = section.getClientCursorName();
        int n = string.lastIndexOf(string2);
        if (string.length() > n + string2.length()) {
            return string.substring(0, n) + section.getServerCursorNameForPositionedUpdate() + string.substring(n + string2.length(), string.length());
        }
        return string.substring(0, n) + section.getServerCursorNameForPositionedUpdate();
    }

    public ConnectionCallbackInterface getConnectionCallbackInterface() {
        return this.connection_;
    }

    void resetCursorNameAndRemoveFromWhereCurrentOfMappings() {
        if (this.section_ != null) {
            this.agent_.sectionManager_.removeCursorNameToResultSetMapping(this.cursorName_, this.section_.getServerCursorNameForPositionedUpdate());
            this.agent_.sectionManager_.removeCursorNameToResultSetMapping(this.cursorName_, this.section_.getServerCursorName());
            this.agent_.sectionManager_.removeCursorNameToQuerySectionMapping(this.cursorName_, this.section_.getServerCursorNameForPositionedUpdate());
        }
    }

    void mapCursorNameToResultSet() {
        if (this.cursorName_ != null) {
            this.agent_.sectionManager_.mapCursorNameToResultSet(this.cursorName_, this.resultSet_);
        } else {
            this.agent_.sectionManager_.mapCursorNameToResultSet(this.section_.getServerCursorName(), this.resultSet_);
        }
    }

    void parseStorProcReturnedScrollableRowset() throws SqlException {
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                if (!this.resultSetList_[i].scrollable_ || !this.resultSetList_[i].cursor_.dataBufferHasUnprocessedData()) continue;
                this.resultSetList_[i].parseScrollableRowset();
                if (!this.resultSetList_[i].rowCountIsUnknown()) continue;
                this.resultSetList_[i].getRowCount();
            }
        }
    }

    String escape(String string) throws SqlException {
        String string2 = string;
        string2 = this.connection_.nativeSQLX(string);
        return string2;
    }

    String cacheCursorAttributesToSendOnPrepare() throws SqlException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.resultSetType_ == 1005) {
            stringBuffer.append("SENSITIVE STATIC SCROLL ");
        } else if (this.resultSetType_ == 1004) {
            stringBuffer.append("INSENSITIVE SCROLL ");
        }
        if (this.resultSetConcurrency_ == 1008) {
            stringBuffer.append("FOR UPDATE ");
        }
        if (this.resultSetHoldability_ == 1) {
            stringBuffer.append("WITH HOLD ");
        }
        return stringBuffer == null || stringBuffer.toString().equals("") ? null : stringBuffer.toString();
    }

    void getPreparedStatementForAutoGeneratedKeys() throws SqlException {
        if (this.preparedStatementForAutoGeneratedKeys_ == null) {
            String string = "select IDENTITY_VAL_LOCAL() from SYSIBM.SYSDUMMY1";
            this.preparedStatementForAutoGeneratedKeys_ = this.connection_.newPreparedStatement_(string, 1003, 1007, 1, 2, null, null);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WITH HOLD ");
            this.preparedStatementForAutoGeneratedKeys_.cursorAttributesToSendOnPrepare_ = stringBuffer.toString();
        }
    }

    void prepareAutoGeneratedKeysStatement() throws SqlException {
        this.getPreparedStatementForAutoGeneratedKeys();
        if (!this.preparedStatementForAutoGeneratedKeys_.openOnServer_) {
            this.preparedStatementForAutoGeneratedKeys_.materialPreparedStatement_.writePrepareDescribeOutput_(this.preparedStatementForAutoGeneratedKeys_.sql_, this.preparedStatementForAutoGeneratedKeys_.section_);
        }
    }

    void readPrepareAutoGeneratedKeysStatement() throws SqlException {
        if (!this.preparedStatementForAutoGeneratedKeys_.openOnServer_) {
            this.preparedStatementForAutoGeneratedKeys_.materialPreparedStatement_.readPrepareDescribeOutput_();
        }
    }

    void checkAutoGeneratedKeysParameters() throws SqlException {
        if (this.autoGeneratedKeys_ != 2 && this.autoGeneratedKeys_ != 1) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Integer(this.autoGeneratedKeys_), (Object)"autoGeneratedKeys", "Statement.execute()/executeQuery()");
        }
        if (this.sqlUpdateMode_ == 32) {
            if (this.generatedKeysColumnNames_ != null && this.generatedKeysColumnNames_.length > 1) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0X0D.S"), new Integer(this.generatedKeysColumnNames_.length));
            }
            if (this.generatedKeysColumnIndexes_ != null && this.generatedKeysColumnIndexes_.length > 1) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0X0D.S"), new Integer(this.generatedKeysColumnIndexes_.length));
            }
        }
    }

    public ColumnMetaData getGuessedResultSetMetaData() {
        return this.resultSetMetaData_;
    }

    public boolean isQueryMode() {
        return this.sqlMode_ == 1;
    }

    protected void removeClientCursorNameFromCache() {
        if (this.cursorName_ != null && this.connection_.clientCursorNameCache_.containsKey(this.cursorName_)) {
            this.connection_.clientCursorNameCache_.remove(this.cursorName_);
        }
    }

    public void resultSetCommitting(ResultSet resultSet) throws SqlException {
        this.resultSetCommitting(resultSet, false);
    }

    public boolean resultSetCommitting(ResultSet resultSet, boolean bl) throws SqlException {
        if (!this.connection_.autoCommit_ || resultSet.autoCommitted_) {
            return false;
        }
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                ResultSet resultSet2 = this.resultSetList_[i];
                if (resultSet2 == null || !resultSet2.openOnClient_ || resultSet2 == resultSet) continue;
                return false;
            }
        }
        if (bl) {
            this.connection_.writeAutoCommit();
            return true;
        }
        if (this.connection_.flowAutoCommit()) {
            this.markAutoCommitted();
            return true;
        }
        return false;
    }

    public void markAutoCommitted() {
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                if (this.resultSetList_[i] == null) continue;
                this.resultSetList_[i].markAutoCommitted();
            }
        } else if (this.resultSet_ != null) {
            this.resultSet_.markAutoCommitted();
        }
    }

    protected SQLException jdbc3FeatureNotSupported(boolean bl) throws SQLException {
        try {
            if (bl) {
                this.checkForClosedStatement();
            }
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    protected SQLException jdbc3FeatureNotSupported() throws SQLException {
        return this.jdbc3FeatureNotSupported(true);
    }
}

