/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jnlp.sample.servlet.DownloadRequest;
import jnlp.sample.servlet.DownloadResponse;
import jnlp.sample.servlet.JnlpResource;
import jnlp.sample.servlet.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JnlpFileHandler {
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final String HEADER_LASTMOD = "Last-Modified";
    private ServletContext _servletContext;
    private Logger _log = null;
    private HashMap _jnlpFiles = null;

    public JnlpFileHandler(ServletContext servletContext, Logger logger) {
        this._servletContext = servletContext;
        this._log = logger;
        this._jnlpFiles = new HashMap();
    }

    public synchronized DownloadResponse getJnlpFile(JnlpResource jnlpResource, DownloadRequest downloadRequest) throws IOException {
        String string;
        JnlpFileEntry jnlpFileEntry;
        String string2 = jnlpResource.getPath();
        URL uRL = jnlpResource.getResource();
        long l = jnlpResource.getLastModified();
        this._log.addDebug("lastModified: " + l + " " + new Date(l));
        if (l == 0L) {
            this._log.addWarning("servlet.log.warning.nolastmodified", string2);
        }
        if ((jnlpFileEntry = (JnlpFileEntry)this._jnlpFiles.get(string = HttpUtils.getRequestURL((HttpServletRequest)downloadRequest.getHttpRequest()).toString())) != null && jnlpFileEntry.getLastModified() == l) {
            return jnlpFileEntry.getResponse();
        }
        long l2 = l;
        String string3 = this._servletContext.getMimeType(string2);
        if (string3 == null) {
            string3 = JNLP_MIME_TYPE;
        }
        StringBuffer stringBuffer = new StringBuffer();
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), "UTF-8"));
        String string4 = bufferedReader.readLine();
        if (string4 != null && string4.startsWith("TS:")) {
            l2 = this.parseTimeStamp(string4.substring(3));
            this._log.addDebug("Timestamp: " + l2 + " " + new Date(l2));
            if (l2 == 0L) {
                this._log.addWarning("servlet.log.warning.notimestamp", string2);
                l2 = l;
            }
            string4 = bufferedReader.readLine();
        }
        while (string4 != null) {
            stringBuffer.append(string4);
            string4 = bufferedReader.readLine();
        }
        String string5 = this.specializeJnlpTemplate(downloadRequest.getHttpRequest(), string2, stringBuffer.toString());
        byte[] byArray = string5.getBytes("UTF-8");
        DownloadResponse downloadResponse = DownloadResponse.getFileDownloadResponse(byArray, string3, l2, jnlpResource.getReturnVersionId());
        jnlpFileEntry = new JnlpFileEntry(downloadResponse, l);
        this._jnlpFiles.put(string, jnlpFileEntry);
        return downloadResponse;
    }

    public synchronized DownloadResponse getJnlpFileEx(JnlpResource jnlpResource, DownloadRequest downloadRequest) throws IOException {
        Object object;
        byte[] byArray;
        JnlpFileEntry jnlpFileEntry;
        String string = jnlpResource.getPath();
        URL uRL = jnlpResource.getResource();
        long l = jnlpResource.getLastModified();
        this._log.addDebug("lastModified: " + l + " " + new Date(l));
        if (l == 0L) {
            this._log.addWarning("servlet.log.warning.nolastmodified", string);
        }
        String string2 = HttpUtils.getRequestURL((HttpServletRequest)downloadRequest.getHttpRequest()).toString();
        if (downloadRequest.getQuery() != null) {
            string2 = string2 + downloadRequest.getQuery();
        }
        if ((jnlpFileEntry = (JnlpFileEntry)this._jnlpFiles.get(string2)) != null && jnlpFileEntry.getLastModified() == l) {
            return jnlpFileEntry.getResponse();
        }
        long l2 = l;
        String string3 = this._servletContext.getMimeType(string);
        if (string3 == null) {
            string3 = JNLP_MIME_TYPE;
        }
        StringBuffer stringBuffer = new StringBuffer();
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), "UTF-8"));
        String string4 = bufferedReader.readLine();
        if (string4 != null && string4.startsWith("TS:")) {
            l2 = this.parseTimeStamp(string4.substring(3));
            this._log.addDebug("Timestamp: " + l2 + " " + new Date(l2));
            if (l2 == 0L) {
                this._log.addWarning("servlet.log.warning.notimestamp", string);
                l2 = l;
            }
            string4 = bufferedReader.readLine();
        }
        while (string4 != null) {
            stringBuffer.append(string4);
            string4 = bufferedReader.readLine();
        }
        String string5 = this.specializeJnlpTemplate(downloadRequest.getHttpRequest(), string, stringBuffer.toString());
        String string6 = downloadRequest.getQuery();
        String string7 = downloadRequest.getTestJRE();
        this._log.addDebug("Double check query string: " + string6);
        if (string6 != null) {
            byArray = string5.getBytes("UTF-8");
            object = new ByteArrayInputStream(byArray);
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse((InputStream)object);
                if (document != null && document.getNodeType() == 9) {
                    Object object2;
                    Object object3;
                    Object object4;
                    boolean bl = false;
                    Element element = document.getDocumentElement();
                    if (element.hasAttribute("href") && string6 != null) {
                        object4 = element.getAttribute("href");
                        element.setAttribute("href", (String)object4 + "?" + string6);
                        bl = true;
                    }
                    if (string7 != null && (object4 = element.getElementsByTagName("j2se")) != null && ((String)(object3 = (object2 = (Element)object4.item(0)).getAttribute("version"))).length() > 0) {
                        object2.setAttribute("version", string7);
                        bl = true;
                    }
                    object4 = TransformerFactory.newInstance();
                    object2 = ((TransformerFactory)object4).newTransformer();
                    object3 = new DOMSource(document);
                    StringWriter stringWriter = new StringWriter();
                    StreamResult streamResult = new StreamResult(stringWriter);
                    ((Transformer)object2).transform((Source)object3, streamResult);
                    string5 = stringWriter.toString();
                    this._log.addDebug("Converted jnlpFileContent: " + string5);
                    if (bl) {
                        l2 = new Date().getTime();
                        this._log.addDebug("Last modified on the fly:  " + l2);
                    }
                }
            }
            catch (Exception exception) {
                this._log.addDebug(exception.toString(), exception);
            }
        }
        byArray = string5.getBytes("UTF-8");
        object = DownloadResponse.getFileDownloadResponse(byArray, string3, l2, jnlpResource.getReturnVersionId());
        jnlpFileEntry = new JnlpFileEntry((DownloadResponse)object, l);
        this._jnlpFiles.put(string2, jnlpFileEntry);
        return object;
    }

    private String specializeJnlpTemplate(HttpServletRequest httpServletRequest, String string, String string2) {
        String string3 = this.getUrlPrefix(httpServletRequest);
        int n = string.lastIndexOf(47);
        String string4 = string.substring(n + 1);
        String string5 = string.substring(0, n + 1);
        string2 = this.substitute(string2, "$$name", string4);
        string2 = this.substitute(string2, "$$hostname", httpServletRequest.getServerName());
        string2 = this.substitute(string2, "$$codebase", string3 + httpServletRequest.getContextPath() + string5);
        string2 = this.substitute(string2, "$$context", string3 + httpServletRequest.getContextPath());
        string2 = this.substitute(string2, "$$site", string3);
        return string2;
    }

    private String getUrlPrefix(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = httpServletRequest.getScheme();
        int n = httpServletRequest.getServerPort();
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(httpServletRequest.getServerPort());
        }
        return stringBuffer.toString();
    }

    private String substitute(String string, String string2, String string3) {
        int n = 0;
        int n2;
        while ((n2 = string.indexOf(string2, n)) != -1) {
            string = string.substring(0, n2) + string3 + string.substring(n2 + string2.length());
            n = n2 + string3.length();
        }
        return string;
    }

    private long parseTimeStamp(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        block10: {
            n6 = 0;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            n = 0;
            string = string.trim();
            try {
                if (this.matchPattern("####-##-## ##:##", string)) {
                    n6 = this.getIntValue(string, 0, 4);
                    n5 = this.getIntValue(string, 5, 7);
                    n4 = this.getIntValue(string, 8, 10);
                    n3 = this.getIntValue(string, 11, 13);
                    n2 = this.getIntValue(string, 14, 16);
                    if (this.matchPattern(":##", string = string.substring(16))) {
                        n = this.getIntValue(string, 1, 3);
                        string = string.substring(3);
                    }
                    break block10;
                }
                if (this.matchPattern("############", string)) {
                    n6 = this.getIntValue(string, 0, 4);
                    n5 = this.getIntValue(string, 4, 6);
                    n4 = this.getIntValue(string, 6, 8);
                    n3 = this.getIntValue(string, 8, 10);
                    n2 = this.getIntValue(string, 10, 12);
                    if (this.matchPattern("##", string = string.substring(12))) {
                        n = this.getIntValue(string, 0, 2);
                        string = string.substring(2);
                    }
                    break block10;
                }
                return 0L;
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }
        String string2 = null;
        string = string.trim();
        if (string.equalsIgnoreCase("Z")) {
            string2 = "GMT";
        } else if (string.startsWith("+") || string.startsWith("-")) {
            string2 = "GMT" + string;
        }
        if (string2 == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(n6, n5 - 1, n4, n3, n2, n);
            return calendar.getTime().getTime();
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(string2));
        calendar.set(n6, n5 - 1, n4, n3, n2, n);
        return calendar.getTime().getTime();
    }

    private int getIntValue(String string, int n, int n2) {
        return Integer.parseInt(string.substring(n, n2));
    }

    private boolean matchPattern(String string, String string2) {
        if (string2.length() < string.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char c2 = string2.charAt(i);
            if (c == '#' && Character.isDigit(c2) || c == c2) continue;
            return false;
        }
        return true;
    }

    private static class JnlpFileEntry {
        DownloadResponse _response;
        private long _lastModified;

        JnlpFileEntry(DownloadResponse downloadResponse, long l) {
            this._response = downloadResponse;
            this._lastModified = l;
        }

        public DownloadResponse getResponse() {
            return this._response;
        }

        long getLastModified() {
            return this._lastModified;
        }
    }
}

