/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class SaveAsAction
extends AbstractAction
implements ContextAwareAction,
LookupListener,
PropertyChangeListener {
    private Lookup context;
    private Lookup.Result<SaveAsCapable> lkpInfo;
    private boolean isEditorWindowActivated;

    private SaveAsAction() {
        this(Utilities.actionsGlobalContext());
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private SaveAsAction(Lookup lookup) {
        super(NbBundle.getMessage(DataObject.class, (String)"CTL_SaveAsAction"));
        this.context = lookup;
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public static ContextAwareAction create() {
        return new SaveAsAction();
    }

    void init() {
        assert (SwingUtilities.isEventDispatchThread()) : "this shall be called just from AWT thread";
        if (this.lkpInfo != null) {
            return;
        }
        Lookup.Template template = new Lookup.Template(SaveAsCapable.class);
        this.lkpInfo = this.context.lookup(template);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.propertyChange(null);
    }

    public boolean isEnabled() {
        this.init();
        return super.isEnabled();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.init();
        Collection collection = this.lkpInfo.allInstances();
        if (collection.size() > 0) {
            SaveAsCapable saveAsCapable = (SaveAsCapable)collection.iterator().next();
            File file = this.getNewFileName();
            if (null != file) {
                FileObject fileObject = null;
                try {
                    File file2 = file.getParentFile();
                    if (null == file2) {
                        throw new IOException(file.getAbsolutePath());
                    }
                    fileObject = FileUtil.createFolder((File)file2);
                }
                catch (IOException iOException) {
                    NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_CannotCreateTargetFolder"), NbBundle.getMessage(DataObject.class, (String)"LBL_SaveAsTitle"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                    DialogDisplayer.getDefault().notify(notifyDescriptor);
                    return;
                }
                try {
                    saveAsCapable.saveAs(fileObject, file.getName());
                }
                catch (IOException iOException) {
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(DataObject.class, (String)"MSG_SaveAsFailed"));
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, null, iOException);
                }
            }
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnabled(null != this.lkpInfo && this.lkpInfo.allItems().size() != 0 && this.isEditorWindowActivated);
    }

    private File getNewFileName() {
        File file = null;
        FileObject fileObject = this.getCurrentFileObject();
        if (null != fileObject) {
            file = FileUtil.toFile((FileObject)fileObject);
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(NbBundle.getMessage(DataObject.class, (String)"LBL_SaveAsTitle"));
        jFileChooser.setMultiSelectionEnabled(false);
        if (null != file) {
            jFileChooser.setSelectedFile(file);
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, (File)file.getParentFile());
        }
        File file2 = file;
        if (0 != jFileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow())) {
            return null;
        }
        file = jFileChooser.getSelectedFile();
        if (null == file || file.equals(file2)) {
            return null;
        }
        return file;
    }

    private FileObject getCurrentFileObject() {
        DataObject dataObject;
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null != topComponent && null != (dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class))) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new SaveAsAction(lookup);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        this.isEditorWindowActivated = null != topComponent && WindowManager.getDefault().isEditorTopComponent(topComponent);
        this.resultChanged(null);
    }
}

