/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.DropGlassPane;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.PasteType;

final class TreeViewDropSupport
implements DropTargetListener,
Runnable {
    protected static final int FUSSY_POINTING = 3;
    private static final int DELAY_TIME_FOR_EXPAND = 1000;
    private static final int SHIFT_DOWN = -1;
    private static final int SHIFT_RIGHT = 10;
    private static final int SHIFT_LEFT = 15;
    boolean active = false;
    boolean dropTargetPopupAllowed;
    DropTarget dropTarget;
    Rectangle lastNodeArea;
    private int upperNodeIdx = -1;
    private int lowerNodeIdx = -1;
    private int dropIndex = -1;
    Timer timer;
    DropGlassPane dropPane;
    private int pointAt = 0;
    protected TreeView view;
    protected JTree tree;

    public TreeViewDropSupport(TreeView treeView, JTree jTree, boolean bl) {
        this.view = treeView;
        this.tree = jTree;
        this.dropTargetPopupAllowed = bl;
    }

    public void setDropTargetPopupAllowed(boolean bl) {
        this.dropTargetPopupAllowed = bl;
    }

    public boolean isDropTargetPopupAllowed() {
        return this.dropTargetPopupAllowed;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.checkStoredGlassPane();
        this.dropIndex = -1;
        this.doDragOver(dropTargetDragEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.checkStoredGlassPane();
        this.doDragOver(dropTargetDragEvent);
    }

    private void checkStoredGlassPane() {
        if (!DropGlassPane.isOriginalPaneStored()) {
            Component component = this.tree.getRootPane().getGlassPane();
            DropGlassPane.setOriginalPane(this.tree, component, component.isVisible());
            this.dropPane = DropGlassPane.getDefault(this.tree);
            this.tree.getRootPane().setGlassPane(this.dropPane);
            this.dropPane.revalidate();
            this.dropPane.setVisible(true);
        }
    }

    private void doDragOver(DropTargetDragEvent dropTargetDragEvent) {
        Object object;
        Object object2;
        ExplorerDnDManager.getDefault().setMaybeExternalDragAndDrop(true);
        int n = dropTargetDragEvent.getDropAction();
        int n2 = this.view.getAllowedDropActions();
        n = ExplorerDnDManager.getDefault().getAdjustedDropAction(n, n2);
        TreePath treePath = this.getTreePath(dropTargetDragEvent, n);
        Point point = dropTargetDragEvent.getLocation();
        if (treePath == null) {
            Node node = this.view.manager.getRootContext();
            if (this.canDrop(node, n, dropTargetDragEvent.getTransferable())) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
            return;
        }
        Node[] nodeArray = this.getNodeForDrop(point);
        if (nodeArray == null) {
            this.dropIndex = -1;
            dropTargetDragEvent.rejectDrag();
            this.removeDropLine();
            return;
        }
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        int n3 = rectangle.x + rectangle.width;
        int n4 = this.tree.getRowForPath(treePath);
        if (rectangle != null) {
            this.pointAt = 0;
            if (point.y <= rectangle.y + 3) {
                if (n4 != 0) {
                    this.pointAt = -1;
                    object2 = this.tree.getPathForRow(n4 - 1);
                    if (object2 != null && !((TreePath)object2).equals(treePath)) {
                        n3 = Math.max(rectangle.x + rectangle.width, this.tree.getPathBounds((TreePath)object2).x + this.tree.getPathBounds((TreePath)object2).width);
                    }
                    if (nodeArray.getParentNode() != null) {
                        nodeArray = nodeArray.getParentNode();
                        treePath = null;
                    }
                }
            } else if (point.y >= rectangle.y + rectangle.height - 3 && !this.view.isExpanded((Node)nodeArray)) {
                this.pointAt = 1;
                object2 = this.tree.getPathForRow(n4 + 1);
                if (object2 != null && !((TreePath)object2).equals(treePath)) {
                    n3 = Math.max(rectangle.x + rectangle.width, this.tree.getPathBounds((TreePath)object2).x + this.tree.getPathBounds((TreePath)object2).width);
                }
                if (nodeArray.getParentNode() != null) {
                    nodeArray = nodeArray.getParentNode();
                    treePath = null;
                }
            }
        }
        n3 += 10;
        object2 = (Index)nodeArray.getCookie(Index.class);
        if (object2 != null) {
            if (this.pointAt == -1) {
                this.lowerNodeIdx = object2.indexOf(this.getNodeForDrop(point));
                this.upperNodeIdx = this.lowerNodeIdx - 1;
            } else if (this.pointAt == 1) {
                this.upperNodeIdx = object2.indexOf(this.getNodeForDrop(point));
                this.lowerNodeIdx = this.upperNodeIdx + 1;
            }
            this.dropIndex = this.lowerNodeIdx;
        }
        if (nodeArray == this.getNodeForDrop(point)) {
            this.dropIndex = -1;
        }
        if (!(this.timer != null && this.timer.isRunning() || nodeArray == null || nodeArray.isLeaf() || this.view.isExpanded((Node)nodeArray))) {
            object = nodeArray;
            this.removeTimer();
            this.timer = new Timer(1000, new ActionListener((Node)object){
                final /* synthetic */ Node val$cn;
                {
                    this.val$cn = node;
                }

                public final void actionPerformed(ActionEvent actionEvent) {
                    TreeViewDropSupport.this.view.expandNode(this.val$cn);
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }
        if (this.pointAt == 0) {
            this.dropPane.setDropLine(null);
        } else if (this.pointAt == -1) {
            object = new Line2D.Double(rectangle.x - 15, rectangle.y + -1, n3, rectangle.y + -1);
            this.convertBoundsAndSetDropLine((Line2D)object);
            Rectangle rectangle2 = new Rectangle(rectangle.x - 15, rectangle.y + -1 - 3, n3 - rectangle.x + 15, 5);
            rectangle = (Rectangle)rectangle.createUnion(rectangle2);
        } else {
            object = new Line2D.Double(rectangle.x - 15, rectangle.y + rectangle.height + -1, n3, rectangle.y + rectangle.height + -1);
            this.convertBoundsAndSetDropLine((Line2D)object);
            Rectangle rectangle3 = new Rectangle(rectangle.x - 15, rectangle.y + rectangle.height, n3 - rectangle.x + 15, 2);
            rectangle = (Rectangle)rectangle.createUnion(rectangle3);
        }
        if (this.lastNodeArea != null && !this.lastNodeArea.equals(rectangle)) {
            NodeRenderer.dragExit();
            this.repaint(this.lastNodeArea);
        }
        if (!rectangle.equals(this.lastNodeArea)) {
            if (treePath != null) {
                NodeRenderer.dragEnter(treePath.getLastPathComponent());
            }
            this.repaint(rectangle);
            this.lastNodeArea = rectangle;
            this.removeTimer();
        }
        if (this.canDrop((Node)nodeArray, n, dropTargetDragEvent.getTransferable())) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            object = ExplorerDnDManager.getDefault().getDraggedNodes();
            if (null != object && this.canReorderWhenMoving((Node)nodeArray, (Node[])object)) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }
    }

    private void repaint(Rectangle rectangle) {
        this.tree.repaint(rectangle.x - 5, rectangle.y - 5, rectangle.width + 10, rectangle.height + 10);
    }

    private void convertBoundsAndSetDropLine(Line2D line2D) {
        int n = (int)line2D.getX1();
        int n2 = (int)line2D.getX2();
        int n3 = (int)line2D.getY1();
        int n4 = (int)line2D.getY2();
        Point point = SwingUtilities.convertPoint(this.tree, n, n3, this.tree.getRootPane());
        Point point2 = SwingUtilities.convertPoint(this.tree, n2, n4, this.tree.getRootPane());
        line2D.setLine(point, point2);
        this.dropPane.setDropLine(line2D);
    }

    private void removeTimer() {
        if (this.timer != null) {
            ActionListener[] actionListenerArray = (ActionListener[])this.timer.getListeners(ActionListener.class);
            for (int i = 0; i < actionListenerArray.length; ++i) {
                this.timer.removeActionListener(actionListenerArray[i]);
            }
            this.timer.stop();
            this.timer = null;
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        Node[] nodeArray = ExplorerDnDManager.getDefault().getDraggedNodes();
        if (null != nodeArray) {
            int n = ExplorerDnDManager.getDefault().getAdjustedDropAction(dropTargetDragEvent.getDropAction(), this.view.getAllowedDropActions());
            for (int i = 0; i < nodeArray.length; ++i) {
                if ((this.view.getAllowedDropActions() & n) != 0 && DragDropUtilities.checkNodeForAction(nodeArray[i], n)) continue;
                dropTargetDragEvent.rejectDrag();
                return;
            }
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.dropIndex = -1;
        ExplorerDnDManager.getDefault().setMaybeExternalDragAndDrop(false);
        this.stopDragging();
    }

    private void removeDropLine() {
        if (null != this.dropPane) {
            this.dropPane.setDropLine(null);
        }
        if (this.lastNodeArea != null) {
            NodeRenderer.dragExit();
            this.repaint(this.lastNodeArea);
            this.lastNodeArea = null;
        }
    }

    private void stopDragging() {
        this.removeDropLine();
        this.removeTimer();
        if (DropGlassPane.isOriginalPaneStored()) {
            DropGlassPane.putBackOriginal();
        }
    }

    private Node getNodeForDrop(Point point) {
        if (point != null) {
            TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
            if (null == treePath) {
                treePath = this.tree.getPathForLocation(point.x, point.y - this.tree.getRowHeight() / 2);
            }
            if (treePath != null) {
                return DragDropUtilities.secureFindNode(treePath.getLastPathComponent());
            }
        }
        return null;
    }

    private boolean canReorderWhenMoving(Node node, Node[] nodeArray) {
        if ((ExplorerDnDManager.getDefault().getNodeAllowedActions() & 2) == 0) {
            return false;
        }
        return this.canReorder(node, nodeArray);
    }

    private boolean canReorder(Node node, Node[] nodeArray) {
        if (node == null || nodeArray.length == 0) {
            return false;
        }
        Index index = (Index)node.getCookie(Index.class);
        if (index == null) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i] == null) {
                return false;
            }
            if (nodeArray[i].getParentNode() == null) {
                return false;
            }
            if (nodeArray[i].getParentNode().equals((Object)node)) continue;
            return false;
        }
        return true;
    }

    private void performReorder(Node node, Node[] nodeArray, int n, int n2) {
        block11: {
            try {
                int n3;
                int n4;
                Index index = (Index)node.getCookie(Index.class);
                if (index == null) break block11;
                int[] nArray = new int[index.getNodesCount()];
                int[] nArray2 = new int[nodeArray.length];
                int n5 = 0;
                for (n4 = 0; n4 < nodeArray.length; ++n4) {
                    n3 = index.indexOf(nodeArray[n4]);
                    if (n3 < 0 || n3 >= nArray.length) continue;
                    nArray2[n5++] = n3;
                }
                Arrays.sort(nArray2);
                if (n < 0 || n2 >= nArray.length || n5 == 0) {
                    return;
                }
                n4 = 0;
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    int n6;
                    if (n3 <= n2) {
                        if (!this.containsNumber(nArray2, n5, n3)) {
                            nArray[n3] = n4++;
                        }
                        if (n3 != n2) continue;
                        for (n6 = 0; n6 < n5; ++n6) {
                            if (nArray2[n6] > n2) continue;
                            nArray[nArray2[n6]] = n4++;
                        }
                        continue;
                    }
                    if (n3 == n) {
                        for (n6 = 0; n6 < n5; ++n6) {
                            if (nArray2[n6] < n) continue;
                            nArray[nArray2[n6]] = n4++;
                        }
                    }
                    if (this.containsNumber(nArray2, n5, n3)) continue;
                    nArray[n3] = n4++;
                }
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    if (nArray[n3] == n3) continue;
                    index.reorder(nArray);
                    break;
                }
            }
            catch (Exception exception) {
                Logger.getLogger(TreeViewDropSupport.class.getName()).log(Level.WARNING, null, exception);
            }
        }
    }

    private boolean containsNumber(int[] nArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] != n2) continue;
            return true;
        }
        return false;
    }

    private Node[] findDropedNodes(Node node, Node[] nodeArray) {
        if (node == null || nodeArray.length == 0) {
            return null;
        }
        Node[] nodeArray2 = new Node[nodeArray.length];
        Children children = node.getChildren();
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray2[i] = children.findChild(nodeArray[i].getName());
        }
        return nodeArray2;
    }

    private boolean canDrop(Node node, int n, Transferable transferable) {
        Object object;
        if (node == null) {
            return false;
        }
        if ((this.view.getAllowedDropActions() & n) == 0) {
            return false;
        }
        if ((2 & n) != 0 && (object = ExplorerDnDManager.getDefault().getDraggedNodes()) != null) {
            for (int i = 0; i < ((Node[])object).length; ++i) {
                if (!node.equals((Object)object[i].getParentNode())) continue;
                return false;
            }
        }
        object = ExplorerDnDManager.getDefault().getDraggedTransferable((2 & n) != 0);
        if (object == null && null == (object = transferable)) {
            return false;
        }
        PasteType pasteType = DragDropUtilities.getDropType(node, (Transferable)object, n, this.dropIndex);
        return pasteType != null;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        this.stopDragging();
        Node node = this.getNodeForDrop(dropTargetDropEvent.getLocation());
        if (node == null) {
            node = this.view.manager.getRootContext();
        } else if (this.pointAt != 0) {
            node = node.getParentNode();
        }
        Node[] nodeArray = ExplorerDnDManager.getDefault().getDraggedNodes();
        int n = ExplorerDnDManager.getDefault().getAdjustedDropAction(dropTargetDropEvent.getDropAction(), this.view.getAllowedDropActions());
        ExplorerDnDManager.getDefault().setMaybeExternalDragAndDrop(false);
        dropTargetDropEvent.acceptDrop(n);
        if (!this.canDrop(node, n, dropTargetDropEvent.getTransferable())) {
            if (null != nodeArray && this.canReorderWhenMoving(node, nodeArray)) {
                this.performReorder(node, nodeArray, this.lowerNodeIdx, this.upperNodeIdx);
                dropTargetDropEvent.dropComplete(true);
            } else {
                dropTargetDropEvent.dropComplete(false);
            }
            return;
        }
        if (0x40000000 == n && null != nodeArray) {
            int n2;
            object = new PasteType[]{};
            PasteType[] pasteTypeArray = new PasteType[]{};
            if ((ExplorerDnDManager.getDefault().getNodeAllowedActions() & 2) != 0) {
                object = DragDropUtilities.getPasteTypes(node, ExplorerDnDManager.getDefault().getDraggedTransferable(true));
            }
            if ((ExplorerDnDManager.getDefault().getNodeAllowedActions() & 1) != 0) {
                pasteTypeArray = DragDropUtilities.getPasteTypes(node, ExplorerDnDManager.getDefault().getDraggedTransferable(false));
            }
            TreeSet<PasteType> treeSet = new TreeSet<PasteType>(new Comparator<PasteType>(){

                @Override
                public int compare(PasteType pasteType, PasteType pasteType2) {
                    return pasteType.getName().compareTo(pasteType2.getName());
                }
            });
            for (n2 = 0; n2 < ((PasteType[])object).length; ++n2) {
                treeSet.add(object[n2]);
            }
            for (n2 = 0; n2 < pasteTypeArray.length; ++n2) {
                treeSet.add(pasteTypeArray[n2]);
            }
            DragDropUtilities.createDropFinishPopup(treeSet).show(this.tree, Math.max(dropTargetDropEvent.getLocation().x - 5, 0), Math.max(dropTargetDropEvent.getLocation().y - 5, 0));
            if (this.canReorder(node, nodeArray)) {
                final Node node2 = node;
                final int n3 = this.upperNodeIdx;
                final int n4 = this.lowerNodeIdx;
                final Node[] nodeArray2 = nodeArray;
                DragDropUtilities.setPostDropRun(new Runnable(){

                    public void run() {
                        TreeViewDropSupport.this.performReorder(node2, TreeViewDropSupport.this.findDropedNodes(node2, nodeArray2), n4, n3);
                    }
                });
            }
        } else if (n != 0x40000000) {
            object = ExplorerDnDManager.getDefault().getDraggedTransferable((2 & n) != 0);
            if (null == object) {
                object = dropTargetDropEvent.getTransferable();
            }
            PasteType pasteType = DragDropUtilities.getDropType(node, (Transferable)object, n, this.dropIndex);
            final Node[] nodeArray3 = node.getChildren().getNodes(true);
            final Node node3 = node;
            Node[] nodeArray4 = DragDropUtilities.performPaste(pasteType, node);
            ExplorerDnDManager.getDefault().setDraggedNodes(nodeArray4);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Node[] nodeArray = TreeViewDropSupport.this.getDiffNodes(node3, nodeArray3);
                    if (TreeViewDropSupport.this.canReorder(node3, nodeArray)) {
                        TreeViewDropSupport.this.performReorder(node3, nodeArray, TreeViewDropSupport.this.lowerNodeIdx, TreeViewDropSupport.this.upperNodeIdx);
                    }
                }
            });
        }
        object = this.tree.getCellEditor();
        if (object instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)object).setDnDActive(false);
        }
        dropTargetDropEvent.dropComplete(true);
    }

    private Node[] getDiffNodes(Node node, Node[] nodeArray) {
        Node[] nodeArray2 = node.getChildren().getNodes(true);
        List<Node> list = Arrays.asList(nodeArray);
        List<Node> list2 = Arrays.asList(nodeArray2);
        Iterator<Node> iterator = list2.iterator();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (iterator.hasNext()) {
            Node node2 = iterator.next();
            if (list.contains(node2)) continue;
            arrayList.add(node2);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        this.getDropTarget().setActive(bl);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        DragDropUtilities.dropNotSuccesfull();
    }

    TreePath getTreePath(DropTargetDragEvent dropTargetDragEvent, int n) {
        Point point = dropTargetDragEvent.getLocation();
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        if (null == treePath) {
            treePath = this.tree.getPathForLocation(point.x, point.y - this.tree.getRowHeight() / 2);
        }
        return treePath != null && DragDropUtilities.secureFindNode(treePath.getLastPathComponent()) != null ? treePath : null;
    }

    DropTarget getDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this.tree, this.view.getAllowedDropActions(), this, false);
        }
        return this.dropTarget;
    }
}

