/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import com.sun.tools.visualvm.profiler.ProfilerSnapshot;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProfilerSnapshotCategory
extends SnapshotCategory<ProfilerSnapshot> {
    private static final Logger LOGGER = Logger.getLogger(ProfilerSnapshotCategory.class.getName());
    private static final String NAME = NbBundle.getMessage(ProfilerSnapshotCategory.class, (String)"MSG_Profiler_Snapshots");
    private static final String PREFIX = "snapshot";
    private static final String SUFFIX = ".nps";

    public ProfilerSnapshotCategory() {
        super(NAME, ProfilerSnapshot.class, PREFIX, SUFFIX, 30);
    }

    public boolean supportsOpenSnapshot() {
        return true;
    }

    public void openSnapshot(final File file) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle pHandleF;
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ProfilerSnapshotCategory.class, (String)"MSG_Opening_Profiler_Snapshot"));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    try {
                        FileObject fileObject = FileUtil.toFileObject((File)file);
                        final LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().loadSnapshot(fileObject);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ResultsManager.getDefault().openSnapshot(loadedSnapshot);
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "Error loading profiler snapshot", e);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                NetBeansProfiler.getDefaultNB().displayError(NbBundle.getMessage(ProfilerSnapshotCategory.class, (String)"MSG_Opening_snapshot_failed."));
                            }
                        });
                    }
                    pHandleF = pHandle;
                }
                catch (Throwable throwable) {
                    ProgressHandle pHandleF2 = pHandle;
                    SwingUtilities.invokeLater(new Runnable(pHandleF2){
                        final /* synthetic */ ProgressHandle val$pHandleF;
                        {
                            this.val$pHandleF = progressHandle;
                        }

                        public void run() {
                            if (this.val$pHandleF != null) {
                                this.val$pHandleF.finish();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }
}

