/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui.actions;

import com.sun.tools.visualvm.core.snapshot.RegisteredSnapshotCategories;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategoriesListener;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

class LoadSnapshotAction
extends AbstractAction {
    private static final String ICON_PATH = "com/sun/tools/visualvm/core/ui/resources/loadSnapshot.png";
    private static final Image ICON = Utilities.loadImage((String)"com/sun/tools/visualvm/core/ui/resources/loadSnapshot.png");
    private String lastFile = null;
    private static LoadSnapshotAction instance;

    public static synchronized LoadSnapshotAction instance() {
        if (instance == null) {
            instance = new LoadSnapshotAction();
            instance.updateEnabled();
            RegisteredSnapshotCategories.sharedInstance().addCategoriesListener(new SnapshotCategoriesListener(){

                public void categoryRegistered(SnapshotCategory category) {
                    instance.updateEnabled();
                }

                public void categoryUnregistered(SnapshotCategory category) {
                    instance.updateEnabled();
                }
            });
        }
        return instance;
    }

    public void actionPerformed(ActionEvent e) {
        List<SnapshotCategory> categories = RegisteredSnapshotCategories.sharedInstance().getOpenSnapshotCategories();
        if (categories.isEmpty()) {
            return;
        }
        ArrayList<FileFilter> fileFilters = new ArrayList<FileFilter>();
        for (SnapshotCategory category : categories) {
            fileFilters.add(category.getFileFilter());
        }
        JFileChooser chooser = new JFileChooser(){

            public void setSelectedFile(File file) {
                super.setSelectedFile(file);
                if (!(this.getUI() instanceof BasicFileChooserUI)) {
                    return;
                }
                BasicFileChooserUI ui = (BasicFileChooserUI)this.getUI();
                ui.setFileName(file == null ? "" : file.getName());
            }
        };
        chooser.setDialogTitle(NbBundle.getMessage(LoadSnapshotAction.class, (String)"LBL_Load"));
        if (this.lastFile != null) {
            chooser.setSelectedFile(new File(this.lastFile));
        }
        chooser.setAcceptAllFileFilterUsed(false);
        for (FileFilter fileFilter : fileFilters) {
            chooser.addChoosableFileFilter(fileFilter);
        }
        chooser.setFileFilter((FileFilter)fileFilters.get(0));
        if (chooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile == null || !selectedFile.exists()) {
                NetBeansProfiler.getDefaultNB().displayError(NbBundle.getMessage(LoadSnapshotAction.class, (String)"MSG_Selected_file_does_not_exist"));
            } else {
                FileFilter fileFilter;
                fileFilter = chooser.getFileFilter();
                if (fileFilter.accept(selectedFile)) {
                    this.lastFile = selectedFile.getAbsolutePath();
                    categories.get(fileFilters.indexOf(fileFilter)).openSnapshot(selectedFile);
                } else {
                    NetBeansProfiler.getDefaultNB().displayError(NbBundle.getMessage(LoadSnapshotAction.class, (String)"MSG_Selected_file_does_not_match_snapshot_type"));
                }
            }
        }
    }

    private void updateEnabled() {
        final boolean isEnabled = !RegisteredSnapshotCategories.sharedInstance().getOpenSnapshotCategories().isEmpty();
        IDEUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            public void run() {
                LoadSnapshotAction.this.setEnabled(isEnabled);
            }
        });
    }

    private LoadSnapshotAction() {
        this.putValue("Name", NbBundle.getMessage(LoadSnapshotAction.class, (String)"LBL_Load1"));
        this.putValue("ShortDescription", NbBundle.getMessage(LoadSnapshotAction.class, (String)"LBL_Load_Snapshot"));
        this.putValue("SmallIcon", new ImageIcon(ICON));
        this.putValue("iconBase", ICON_PATH);
    }
}

