/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.snapshot;

import com.sun.tools.visualvm.core.datasupport.Positionable;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.snapshot.SnapshotsSupport;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SnapshotCategory<X extends Snapshot>
implements Positionable {
    private static final String PREFIX_DIVIDER = "-";
    public static final int POSITION_NONE = Integer.MIN_VALUE;
    private final String name;
    private final Class<X> type;
    private final String prefix;
    private final String suffix;
    private final int preferredPosition;

    public SnapshotCategory(String name, Class<X> type, String prefix, String suffix, int preferredPosition) {
        this.name = name;
        this.type = type;
        this.prefix = prefix;
        this.suffix = suffix;
        this.preferredPosition = preferredPosition;
    }

    public final String getName() {
        return this.name;
    }

    public final Class<X> getType() {
        return this.type;
    }

    @Override
    public final int getPreferredPosition() {
        return this.preferredPosition;
    }

    public boolean supportsOpenSnapshot() {
        return false;
    }

    public void openSnapshot(File file) {
        throw new UnsupportedOperationException("Open snapshot not supported");
    }

    protected final String getPrefix() {
        return this.prefix;
    }

    protected final String getSuffix() {
        return this.suffix;
    }

    protected boolean isSnapshot(File file) {
        return this.isSnapshot(file.getName());
    }

    protected boolean isSnapshot(String fileName) {
        String suff = this.getSuffix();
        return suff == null || fileName.endsWith(suff);
    }

    protected String getBaseFileName(String fileName) {
        String pref = this.getPrefix();
        String suff = this.getSuffix();
        if (pref != null && fileName.startsWith(pref + PREFIX_DIVIDER)) {
            fileName = fileName.substring(pref.length() + 1);
        }
        if (suff != null && fileName.endsWith(suff)) {
            fileName = fileName.substring(0, fileName.length() - suff.length());
        }
        return fileName;
    }

    protected String getTimeStamp(String fileName) {
        String timeStamp = null;
        try {
            long time = Long.parseLong(this.getBaseFileName(fileName));
            return SnapshotsSupport.getInstance().getTimeStamp(time);
        }
        catch (NumberFormatException numberFormatException) {
            return timeStamp;
        }
    }

    public String createFileName() {
        String pref = this.getPrefix();
        String suff = this.getSuffix();
        String fileName = System.currentTimeMillis() + "";
        if (pref != null) {
            fileName = pref + PREFIX_DIVIDER + fileName;
        }
        if (suff != null) {
            fileName = fileName + suff;
        }
        return fileName;
    }

    public FilenameFilter getFilenameFilter() {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return SnapshotCategory.this.isSnapshot(name);
            }
        };
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                String suff = SnapshotCategory.this.getSuffix();
                return f.isDirectory() || suff == null || f.getName().endsWith(suff);
            }

            public String getDescription() {
                String suff = SnapshotCategory.this.getSuffix();
                return SnapshotCategory.this.getName() + (suff != null ? " (*" + suff + ")" : "");
            }
        };
    }
}

