/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

public abstract class DataBuffer {
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_USHORT = 1;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DOUBLE = 5;
    public static final int TYPE_UNDEFINED = 32;
    protected int dataType;
    protected int banks;
    protected int offset;
    protected int size;
    protected int[] offsets;
    private static final int[] dataTypeSize = new int[]{8, 16, 16, 32, 32, 64};

    public static int getDataTypeSize(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Unknown data type " + n);
        }
        return dataTypeSize[n];
    }

    protected DataBuffer(int n, int n2) {
        this.dataType = n;
        this.banks = 1;
        this.size = n2;
        this.offset = 0;
        this.offsets = new int[1];
    }

    protected DataBuffer(int n, int n2, int n3) {
        this.dataType = n;
        this.banks = n3;
        this.size = n2;
        this.offset = 0;
        this.offsets = new int[this.banks];
    }

    protected DataBuffer(int n, int n2, int n3, int n4) {
        this.dataType = n;
        this.banks = n3;
        this.size = n2;
        this.offset = n4;
        this.offsets = new int[n3];
        for (int i = 0; i < n3; ++i) {
            this.offsets[i] = n4;
        }
    }

    protected DataBuffer(int n, int n2, int n3, int[] nArray) {
        if (n3 != nArray.length) {
            throw new ArrayIndexOutOfBoundsException("Number of banks does not match number of bank offsets");
        }
        this.dataType = n;
        this.banks = n3;
        this.size = n2;
        this.offset = nArray[0];
        this.offsets = (int[])nArray.clone();
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset() {
        return this.offset;
    }

    public int[] getOffsets() {
        return (int[])this.offsets.clone();
    }

    public int getNumBanks() {
        return this.banks;
    }

    public int getElem(int n) {
        return this.getElem(0, n);
    }

    public abstract int getElem(int var1, int var2);

    public void setElem(int n, int n2) {
        this.setElem(0, n, n2);
    }

    public abstract void setElem(int var1, int var2, int var3);

    public float getElemFloat(int n) {
        return this.getElem(n);
    }

    public float getElemFloat(int n, int n2) {
        return this.getElem(n, n2);
    }

    public void setElemFloat(int n, float f) {
        this.setElem(n, (int)f);
    }

    public void setElemFloat(int n, int n2, float f) {
        this.setElem(n, n2, (int)f);
    }

    public double getElemDouble(int n) {
        return this.getElem(n);
    }

    public double getElemDouble(int n, int n2) {
        return this.getElem(n, n2);
    }

    public void setElemDouble(int n, double d) {
        this.setElem(n, (int)d);
    }

    public void setElemDouble(int n, int n2, double d) {
        this.setElem(n, n2, (int)d);
    }

    static int[] toIntArray(Object object) {
        if (object instanceof int[]) {
            return (int[])object;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            int[] nArray = new int[sArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                nArray[i] = sArray[i] & 0xFFFF;
            }
            return nArray;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int[] nArray = new int[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                nArray[i] = 0xFF & byArray[i];
            }
            return nArray;
        }
        return null;
    }
}

