/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.EventQueue;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import sun.awt.EventListenerAggregate;

public class Clipboard {
    String name;
    protected ClipboardOwner owner;
    protected Transferable contents;
    private EventListenerAggregate flavorListeners;
    private Set currentDataFlavors;

    public Clipboard(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        final ClipboardOwner clipboardOwner2 = this.owner;
        final Transferable transferable2 = this.contents;
        this.owner = clipboardOwner;
        this.contents = transferable;
        if (clipboardOwner2 != null && clipboardOwner2 != clipboardOwner) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    clipboardOwner2.lostOwnership(Clipboard.this, transferable2);
                }
            });
        }
        this.fireFlavorsChanged();
    }

    public synchronized Transferable getContents(Object object) {
        return this.contents;
    }

    public DataFlavor[] getAvailableDataFlavors() {
        Transferable transferable = this.getContents(null);
        if (transferable == null) {
            return new DataFlavor[0];
        }
        return transferable.getTransferDataFlavors();
    }

    public boolean isDataFlavorAvailable(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            throw new NullPointerException("flavor");
        }
        Transferable transferable = this.getContents(null);
        if (transferable == null) {
            return false;
        }
        return transferable.isDataFlavorSupported(dataFlavor);
    }

    public Object getData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor == null) {
            throw new NullPointerException("flavor");
        }
        Transferable transferable = this.getContents(null);
        if (transferable == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return transferable.getTransferData(dataFlavor);
    }

    public synchronized void addFlavorListener(FlavorListener flavorListener) {
        if (flavorListener == null) {
            return;
        }
        if (this.flavorListeners == null) {
            this.currentDataFlavors = this.getAvailableDataFlavorSet();
            this.flavorListeners = new EventListenerAggregate(FlavorListener.class);
        }
        this.flavorListeners.add(flavorListener);
    }

    public synchronized void removeFlavorListener(FlavorListener flavorListener) {
        if (flavorListener == null || this.flavorListeners == null) {
            return;
        }
        this.flavorListeners.remove(flavorListener);
    }

    public synchronized FlavorListener[] getFlavorListeners() {
        return this.flavorListeners == null ? new FlavorListener[]{} : (FlavorListener[])this.flavorListeners.getListenersCopy();
    }

    private void fireFlavorsChanged() {
        if (this.flavorListeners == null) {
            return;
        }
        Set set = this.currentDataFlavors;
        this.currentDataFlavors = this.getAvailableDataFlavorSet();
        if (((Object)set).equals(this.currentDataFlavors)) {
            return;
        }
        FlavorListener[] flavorListenerArray = (FlavorListener[])this.flavorListeners.getListenersInternal();
        for (int i = 0; i < flavorListenerArray.length; ++i) {
            final FlavorListener flavorListener = flavorListenerArray[i];
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    flavorListener.flavorsChanged(new FlavorEvent(Clipboard.this));
                }
            });
        }
    }

    private Set getAvailableDataFlavorSet() {
        DataFlavor[] dataFlavorArray;
        HashSet<DataFlavor> hashSet = new HashSet<DataFlavor>();
        Transferable transferable = this.getContents(null);
        if (transferable != null && (dataFlavorArray = transferable.getTransferDataFlavors()) != null) {
            hashSet.addAll(Arrays.asList(dataFlavorArray));
        }
        return hashSet;
    }
}

