/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.util.ASCIIUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.JAXBException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

public final class JAXBAttachment
implements Attachment,
DataSource {
    private final String contentId;
    private final String mimeType;
    private final Object jaxbObject;
    private final Bridge bridge;

    public JAXBAttachment(@NotNull String string, Object object, Bridge bridge, String string2) {
        this.contentId = string;
        this.jaxbObject = object;
        this.bridge = bridge;
        this.mimeType = string2;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getContentType() {
        return this.mimeType;
    }

    public byte[] asByteArray() {
        try {
            return ASCIIUtility.getBytes(this.asInputStream());
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
    }

    public DataHandler asDataHandler() {
        return new DataHandler(this);
    }

    public Source asSource() {
        return new StreamSource(this.asInputStream());
    }

    public InputStream asInputStream() {
        ByteOutputStream byteOutputStream = new ByteOutputStream();
        try {
            this.writeTo(byteOutputStream);
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        return byteOutputStream.newInputStream();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            this.bridge.marshal(this.jaxbObject, outputStream, null);
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
    }

    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
        attachmentPart.setDataHandler(this.asDataHandler());
        attachmentPart.setContentId(this.contentId);
        sOAPMessage.addAttachmentPart(attachmentPart);
    }

    public InputStream getInputStream() throws IOException {
        return this.asInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return null;
    }
}

