/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.addressing.model.InvalidMapException;
import com.sun.xml.internal.ws.addressing.model.MapRequiredException;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLOutput;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.model.CheckedExceptionImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLOperationImpl;
import java.util.Map;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;

public abstract class WsaTubeHelper {
    protected Unmarshaller unmarshaller;
    protected Marshaller marshaller;
    protected SEIModel seiModel;
    protected WSDLPort wsdlPort;
    protected WSBinding binding;
    protected final SOAPVersion soapVer;
    protected final AddressingVersion addVer;

    public WsaTubeHelper(WSBinding wSBinding, SEIModel sEIModel, WSDLPort wSDLPort) {
        this.binding = wSBinding;
        this.wsdlPort = wSDLPort;
        this.seiModel = sEIModel;
        this.soapVer = wSBinding.getSOAPVersion();
        this.addVer = wSBinding.getAddressingVersion();
    }

    public String getFaultAction(Packet packet, Packet packet2) {
        String string = null;
        if (this.seiModel != null) {
            string = this.getFaultActionFromSEIModel(packet, packet2);
        }
        if (string != null) {
            return string;
        }
        string = this.addVer.getDefaultFaultAction();
        if (this.wsdlPort == null) {
            return string;
        }
        WSDLBoundOperation wSDLBoundOperation = packet.getMessage().getOperation(this.wsdlPort);
        return this.getFaultAction(wSDLBoundOperation, packet2);
    }

    String getFaultActionFromSEIModel(Packet packet, Packet packet2) {
        String string = null;
        if (this.seiModel == null || this.wsdlPort == null) {
            return string;
        }
        try {
            SOAPMessage sOAPMessage = packet2.getMessage().copy().readAsSOAPMessage();
            if (sOAPMessage == null) {
                return string;
            }
            if (sOAPMessage.getSOAPBody() == null) {
                return string;
            }
            if (sOAPMessage.getSOAPBody().getFault() == null) {
                return string;
            }
            Detail detail = sOAPMessage.getSOAPBody().getFault().getDetail();
            if (detail == null) {
                return string;
            }
            String string2 = detail.getFirstChild().getNamespaceURI();
            String string3 = detail.getFirstChild().getLocalName();
            JavaMethodImpl javaMethodImpl = (JavaMethodImpl)packet.getMessage().getMethod(this.seiModel);
            for (CheckedExceptionImpl checkedExceptionImpl : javaMethodImpl.getCheckedExceptions()) {
                if (!checkedExceptionImpl.getDetailType().tagName.getLocalPart().equals(string3) || !checkedExceptionImpl.getDetailType().tagName.getNamespaceURI().equals(string2)) continue;
                return checkedExceptionImpl.getFaultAction();
            }
            return string;
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    String getFaultAction(@Nullable WSDLBoundOperation wSDLBoundOperation, Packet packet) {
        String string = this.addVer.getDefaultFaultAction();
        if (wSDLBoundOperation == null) {
            return string;
        }
        try {
            SOAPMessage sOAPMessage = packet.getMessage().copy().readAsSOAPMessage();
            if (sOAPMessage == null) {
                return string;
            }
            if (sOAPMessage.getSOAPBody() == null) {
                return string;
            }
            if (sOAPMessage.getSOAPBody().getFault() == null) {
                return string;
            }
            Detail detail = sOAPMessage.getSOAPBody().getFault().getDetail();
            if (detail == null) {
                return string;
            }
            String string2 = detail.getFirstChild().getNamespaceURI();
            String string3 = detail.getFirstChild().getLocalName();
            WSDLOperation wSDLOperation = wSDLBoundOperation.getOperation();
            WSDLFault wSDLFault = wSDLOperation.getFault(new QName(string2, string3));
            if (wSDLFault == null) {
                return string;
            }
            WSDLOperationImpl wSDLOperationImpl = (WSDLOperationImpl)wSDLOperation;
            Map<String, String> map = wSDLOperationImpl.getFaultActionMap();
            if (map == null) {
                return string;
            }
            string = map.get(wSDLFault.getName());
            return string;
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    public String getInputAction(Packet packet) {
        WSDLBoundOperation wSDLBoundOperation;
        String string = null;
        if (this.wsdlPort != null && (wSDLBoundOperation = this.wsdlPort.getBinding().getOperation(packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart())) != null) {
            WSDLOperation wSDLOperation = wSDLBoundOperation.getOperation();
            string = wSDLOperation.getInput().getAction();
        }
        return string;
    }

    public String getEffectiveInputAction(Packet packet) {
        if (packet.soapAction != null && !packet.soapAction.equals("")) {
            return packet.soapAction;
        }
        String string = null;
        if (this.wsdlPort != null) {
            WSDLBoundOperation wSDLBoundOperation = this.wsdlPort.getBinding().getOperation(packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart());
            if (wSDLBoundOperation != null) {
                WSDLOperation wSDLOperation = wSDLBoundOperation.getOperation();
                string = wSDLOperation.getInput().getAction();
            } else {
                string = packet.soapAction;
            }
        } else {
            string = packet.soapAction;
        }
        return string;
    }

    public boolean isInputActionDefault(Packet packet) {
        if (this.wsdlPort == null) {
            return false;
        }
        WSDLBoundOperation wSDLBoundOperation = this.wsdlPort.getBinding().getOperation(packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart());
        if (wSDLBoundOperation == null) {
            return false;
        }
        WSDLOperation wSDLOperation = wSDLBoundOperation.getOperation();
        return ((WSDLOperationImpl)wSDLOperation).getInput().isDefaultAction();
    }

    public String getSOAPAction(Packet packet) {
        String string = "";
        if (packet == null) {
            return string;
        }
        if (packet.getMessage() == null) {
            return string;
        }
        WSDLBoundOperation wSDLBoundOperation = packet.getMessage().getOperation(this.wsdlPort);
        if (wSDLBoundOperation == null) {
            return string;
        }
        string = wSDLBoundOperation.getSOAPAction();
        return string;
    }

    public String getOutputAction(Packet packet) {
        Object object;
        String string = "http://jax-ws.dev.java.net/addressing/output-action-not-set";
        if (this.seiModel != null && ((JavaMethodImpl)(object = (JavaMethodImpl)packet.getMessage().getMethod(this.seiModel))).getOutputAction() != null && !((JavaMethodImpl)object).getOutputAction().equals("")) {
            return ((JavaMethodImpl)object).getOutputAction();
        }
        if (this.wsdlPort != null) {
            object = this.wsdlPort.getBinding().getOperation(packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart());
            return this.getOutputAction((WSDLBoundOperation)object);
        }
        return string;
    }

    String getOutputAction(@Nullable WSDLBoundOperation wSDLBoundOperation) {
        WSDLOutput wSDLOutput;
        String string = "http://jax-ws.dev.java.net/addressing/output-action-not-set";
        if (wSDLBoundOperation != null && (wSDLOutput = wSDLBoundOperation.getOperation().getOutput()) != null) {
            string = wSDLOutput.getAction();
        }
        return string;
    }

    public SOAPFault newInvalidMapFault(InvalidMapException invalidMapException, AddressingVersion addressingVersion) {
        QName qName = invalidMapException.getMapQName();
        QName qName2 = invalidMapException.getSubsubcode();
        QName qName3 = addressingVersion.invalidMapTag;
        String string = String.format(addressingVersion.getInvalidMapText(), qName, qName2);
        try {
            SOAPFault sOAPFault;
            if (this.soapVer == SOAPVersion.SOAP_12) {
                SOAPFactory sOAPFactory = SOAPVersion.SOAP_12.saajSoapFactory;
                sOAPFault = sOAPFactory.createFault();
                sOAPFault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                sOAPFault.appendFaultSubcode(qName3);
                sOAPFault.appendFaultSubcode(qName2);
                this.getInvalidMapDetail(qName, sOAPFault.addDetail());
            } else {
                SOAPFactory sOAPFactory = SOAPVersion.SOAP_11.saajSoapFactory;
                sOAPFault = sOAPFactory.createFault();
                sOAPFault.setFaultCode(qName2);
            }
            sOAPFault.setFaultString(string);
            return sOAPFault;
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    public SOAPFault newMapRequiredFault(MapRequiredException mapRequiredException, AddressingVersion addressingVersion) {
        QName qName = addressingVersion.mapRequiredTag;
        QName qName2 = addressingVersion.mapRequiredTag;
        String string = addressingVersion.getMapRequiredText();
        try {
            SOAPFault sOAPFault;
            if (this.soapVer == SOAPVersion.SOAP_12) {
                SOAPFactory sOAPFactory = SOAPVersion.SOAP_12.saajSoapFactory;
                sOAPFault = sOAPFactory.createFault();
                sOAPFault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                sOAPFault.appendFaultSubcode(qName);
                sOAPFault.appendFaultSubcode(qName2);
                this.getMapRequiredDetail(mapRequiredException.getMapQName(), sOAPFault.addDetail());
            } else {
                SOAPFactory sOAPFactory = SOAPVersion.SOAP_11.saajSoapFactory;
                sOAPFault = sOAPFactory.createFault();
                sOAPFault.setFaultCode(qName2);
            }
            sOAPFault.setFaultString(string);
            return sOAPFault;
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    public abstract void getProblemActionDetail(String var1, Element var2);

    public abstract void getInvalidMapDetail(QName var1, Element var2);

    public abstract void getMapRequiredDetail(QName var1, Element var2);
}

