/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.netbeans.lib.profiler.wireprotocol.Response;

public class MonitoredNumbersResponse
extends Response {
    public static final int FREE_MEMORY_IDX = 0;
    public static final int TOTAL_MEMORY_IDX = 1;
    public static final int USER_THREADS_IDX = 2;
    public static final int SYSTEM_THREADS_IDX = 3;
    public static final int SURVIVING_GENERATIONS_IDX = 4;
    public static final int GC_TIME_IDX = 5;
    public static final int GC_PAUSE_IDX = 6;
    public static final int LOADED_CLASSES_IDX = 7;
    public static final int TIMESTAMP_IDX = 8;
    public static final int GENERAL_NUMBERS_SIZE = 9;
    private long[] gcFinishs;
    private long[] gcStarts;
    private long[] generalNumbers = new long[9];
    private String[] newThreadClassNames;
    private int[] newThreadIds;
    private String[] newThreadNames;
    private long[] stateTimestamps = new long[10];
    private int[] threadIds = new int[10];
    private byte[] threadStates = new byte[100];
    private int nNewThreads;
    private int nThreadStates;
    private int nThreads;

    public MonitoredNumbersResponse(long[] generalNumbers) {
        super(true, 9);
        this.generalNumbers = generalNumbers;
        this.nNewThreads = 0;
    }

    MonitoredNumbersResponse() {
        super(true, 9);
    }

    public void setDataOnNewThreads(int nNewThreads, int[] newThreadIds, String[] newThreadNames, String[] newThreadClassNames) {
        this.nNewThreads = nNewThreads;
        this.newThreadIds = newThreadIds;
        this.newThreadNames = newThreadNames;
        this.newThreadClassNames = newThreadClassNames;
    }

    public void setDataOnThreads(int nThreads, int nThreadStates, int[] threadIds, long[] stateTimestamps, byte[] threadStates) {
        this.nThreads = nThreads;
        this.nThreadStates = nThreadStates;
        this.threadIds = threadIds;
        this.stateTimestamps = stateTimestamps;
        this.threadStates = threadStates;
    }

    public long[] getGCFinishs() {
        return this.gcFinishs;
    }

    public long[] getGCStarts() {
        return this.gcStarts;
    }

    public void setGCstartFinishData(long[] start, long[] finish) {
        this.gcStarts = start;
        this.gcFinishs = finish;
    }

    public long[] getGeneralMonitoredNumbers() {
        return this.generalNumbers;
    }

    public int getNNewThreads() {
        return this.nNewThreads;
    }

    public int getNThreadStates() {
        return this.nThreadStates;
    }

    public int getNThreads() {
        return this.nThreads;
    }

    public String[] getNewThreadClassNames() {
        return this.newThreadClassNames;
    }

    public int[] getNewThreadIds() {
        return this.newThreadIds;
    }

    public String[] getNewThreadNames() {
        return this.newThreadNames;
    }

    public long[] getStateTimestamps() {
        return this.stateTimestamps;
    }

    public int[] getThreadIds() {
        return this.threadIds;
    }

    public byte[] getThreadStates() {
        return this.threadStates;
    }

    public String toString() {
        return "MonitoredNumbersResponse, " + super.toString();
    }

    void readObject(ObjectInputStream in) throws IOException {
        int i;
        int len;
        for (int i2 = 0; i2 < this.generalNumbers.length; ++i2) {
            this.generalNumbers[i2] = in.readLong();
        }
        this.nThreads = in.readInt();
        this.nThreadStates = in.readInt();
        if (this.threadIds.length < this.nThreads) {
            this.threadIds = new int[this.nThreads];
        }
        if (this.stateTimestamps.length < this.nThreadStates) {
            this.stateTimestamps = new long[this.nThreadStates];
        }
        if (this.threadStates.length < (len = this.nThreads * this.nThreadStates)) {
            this.threadStates = new byte[len];
        }
        for (i = 0; i < this.nThreads; ++i) {
            this.threadIds[i] = in.readInt();
        }
        for (i = 0; i < this.nThreadStates; ++i) {
            this.stateTimestamps[i] = in.readLong();
        }
        in.readFully(this.threadStates, 0, len);
        this.nNewThreads = in.readInt();
        if (this.nNewThreads > 0) {
            if (this.newThreadIds == null || this.newThreadIds.length < this.nNewThreads) {
                this.newThreadIds = new int[this.nNewThreads];
                this.newThreadNames = new String[this.nNewThreads];
                this.newThreadClassNames = new String[this.nNewThreads];
            }
            for (i = 0; i < this.nNewThreads; ++i) {
                this.newThreadIds[i] = in.readInt();
                this.newThreadNames[i] = in.readUTF();
                this.newThreadClassNames[i] = in.readUTF();
            }
        }
        int arrSize = in.readInt();
        this.gcStarts = new long[arrSize];
        for (i = 0; i < arrSize; ++i) {
            this.gcStarts[i] = in.readLong();
        }
        arrSize = in.readInt();
        this.gcFinishs = new long[arrSize];
        for (i = 0; i < arrSize; ++i) {
            this.gcFinishs[i] = in.readLong();
        }
        Arrays.sort(this.gcStarts);
        Arrays.sort(this.gcFinishs);
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        int i;
        int i2;
        for (i2 = 0; i2 < this.generalNumbers.length; ++i2) {
            out.writeLong(this.generalNumbers[i2]);
        }
        out.writeInt(this.nThreads);
        out.writeInt(this.nThreadStates);
        for (i2 = 0; i2 < this.nThreads; ++i2) {
            out.writeInt(this.threadIds[i2]);
        }
        for (i2 = 0; i2 < this.nThreadStates; ++i2) {
            out.writeLong(this.stateTimestamps[i2]);
        }
        int len = this.nThreads * this.nThreadStates;
        out.write(this.threadStates, 0, len);
        if (this.nNewThreads == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.nNewThreads);
            for (i = 0; i < this.nNewThreads; ++i) {
                out.writeInt(this.newThreadIds[i]);
                out.writeUTF(this.newThreadNames[i]);
                out.writeUTF(this.newThreadClassNames[i]);
            }
        }
        out.writeInt(this.gcStarts.length);
        for (i = 0; i < this.gcStarts.length; ++i) {
            out.writeLong(this.gcStarts[i]);
        }
        out.writeInt(this.gcFinishs.length);
        for (i = 0; i < this.gcFinishs.length; ++i) {
            out.writeLong(this.gcFinishs[i]);
        }
    }
}

