/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;

public class StringUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.utils.Bundle");
    private static final String THIS_WEEK_FORMAT = messages.getString("StringUtils_ThisWeekFormat");
    private static final String LAST_WEEK_FORMAT = messages.getString("StringUtils_LastWeekFormat");
    private static final String YESTERDAY_FORMAT = messages.getString("StringUtils_YesterdayFormat");
    private static final String TODAY_FORMAT = messages.getString("StringUtils_TodayFormat");
    private static final String OTHER_DAY_FORMAT = messages.getString("StringUtils_OtherDayFormat");
    private static final String FULL_FORMAT = messages.getString("StringUtils_FullFormat");
    private static SimpleDateFormat thisWeekFormat = new SimpleDateFormat(THIS_WEEK_FORMAT);
    private static SimpleDateFormat lastWeekFormat = new SimpleDateFormat(LAST_WEEK_FORMAT);
    private static SimpleDateFormat yesterdayFormat = new SimpleDateFormat(YESTERDAY_FORMAT);
    private static SimpleDateFormat todayFormat = new SimpleDateFormat(TODAY_FORMAT);
    private static SimpleDateFormat otherFormat = new SimpleDateFormat(OTHER_DAY_FORMAT);
    private static SimpleDateFormat fullFormat = new SimpleDateFormat(FULL_FORMAT);
    static StringBuffer tmpBuf = new StringBuffer();
    private static char[] strBuf;

    public static void appendSplittedLongString(StringBuffer sb, String s, int maxLineLen) {
        int nLines = s.length() / maxLineLen + (s.length() % maxLineLen != 0 ? 1 : 0);
        int idx = 0;
        for (int i = 0; i < nLines; ++i) {
            int endIdx;
            if (i > 0) {
                sb.append('\n');
            }
            if ((endIdx = idx + maxLineLen) > s.length()) {
                endIdx = s.length();
            }
            sb.append(s.substring(idx, endIdx));
            idx = endIdx;
        }
    }

    public static String[][] convertPackedStringsIntoStringArrays(byte[] packedData, int[] packedArrayOffsets, int dim) {
        String[][] ret = new String[dim][];
        int len = packedArrayOffsets.length / dim;
        for (int i = 0; i < dim; ++i) {
            ret[i] = new String[len];
        }
        int idx = 0;
        int lastIdx = packedArrayOffsets.length - 1;
        for (int j = 0; j < len; ++j) {
            for (int i = 0; i < dim; ++i) {
                int utf8Len = idx < lastIdx ? packedArrayOffsets[idx + 1] - packedArrayOffsets[idx] : packedData.length - packedArrayOffsets[idx];
                ret[i][j] = StringUtils.utf8ToString(packedData, packedArrayOffsets[idx], utf8Len);
                ++idx;
            }
        }
        return ret;
    }

    public static String floatPerCentToString(float t) {
        tmpBuf.setLength(0);
        double floor = Math.floor(t);
        double diff = (double)t - floor;
        if (diff >= 0.95) {
            floor = Math.round(t);
            diff = 0.0;
        }
        tmpBuf.append((int)floor);
        tmpBuf.append('.');
        tmpBuf.append((int)Math.round(diff * 10.0));
        return tmpBuf.toString();
    }

    public static String formatFullDate(Date date) {
        return fullFormat.format(date);
    }

    public static String formatUserDate(Date date) {
        Calendar now = Calendar.getInstance();
        Calendar before = Calendar.getInstance();
        before.setTime(date);
        if (before.getTimeInMillis() <= now.getTimeInMillis()) {
            int daysDelta = StringUtils.getDaysDifference(before, now);
            if (daysDelta == 0) {
                return todayFormat.format(date);
            }
            if (daysDelta == 1) {
                return yesterdayFormat.format(date);
            }
            int weekDelta = StringUtils.getWeekDifference(before, now);
            if (weekDelta == 0) {
                return thisWeekFormat.format(date);
            }
            if (weekDelta == 1) {
                return lastWeekFormat.format(date);
            }
        }
        return otherFormat.format(date);
    }

    public static String mcsTimeToString(long t) {
        tmpBuf.setLength(0);
        if (t >= 100000L) {
            return Long.toString(t / 1000L);
        }
        if (t >= 10000L) {
            long x = t / 1000L;
            tmpBuf.append(Long.toString(x));
            tmpBuf.append('.');
            tmpBuf.append(Long.toString((t - x * 1000L) / 100L));
            return tmpBuf.toString();
        }
        if (t >= 1000L) {
            long x = t / 1000L;
            tmpBuf.append(Long.toString(x));
            tmpBuf.append('.');
            tmpBuf.append(Long.toString((t - x * 1000L) / 10L));
            return tmpBuf.toString();
        }
        if (t >= 100L) {
            tmpBuf.append("0.");
        } else if (t >= 10L) {
            tmpBuf.append("0.0");
        } else {
            tmpBuf.append("0.00");
        }
        return tmpBuf.append(Long.toString(t)).toString();
    }

    public static String nBytesToString(long b) {
        tmpBuf.setLength(0);
        if (b < 102400L) {
            return Long.toString(b) + " B";
        }
        if (b < 0x6400000L) {
            long k = b >> 10;
            tmpBuf.append(Long.toString(k));
            if (b < 0x6400000L) {
                tmpBuf.append('.');
                tmpBuf.append(Long.toString((b - (k << 10)) / 102L));
            }
            tmpBuf.append(" KB");
            return tmpBuf.toString();
        }
        long m = b >> 20;
        tmpBuf.append(Long.toString(m));
        if (b < 0x280000000L) {
            tmpBuf.append('.');
            tmpBuf.append(Long.toString((b - (m << 20)) / 104858L));
        }
        tmpBuf.append(" MB");
        return tmpBuf.toString();
    }

    public static String[] parseArgsString(String args) {
        if (args == null) {
            return new String[0];
        }
        ArrayList<String> listRes = new ArrayList<String>();
        int pos0 = 0;
        int len = args.length();
        while (pos0 < len) {
            int pos1;
            for (pos1 = pos0; pos1 < len && args.charAt(pos1) != ' ' && args.charAt(pos1) != '\b'; ++pos1) {
            }
            listRes.add(args.substring(pos0, pos1));
            for (pos0 = pos1 + 1; pos0 < len && (args.charAt(pos0) == ' ' || args.charAt(pos0) == '\b'); ++pos0) {
            }
        }
        return listRes.toArray(new String[listRes.size()]);
    }

    public static String userFormClassName(String className) {
        if (className == null) {
            return null;
        }
        if ((className = className.replace('/', '.')).startsWith("[")) {
            String elemType = null;
            int lastBrackPos = className.lastIndexOf(91);
            if (lastBrackPos == className.length() - 2) {
                switch (className.charAt(lastBrackPos + 1)) {
                    case 'C': {
                        elemType = "char";
                        break;
                    }
                    case 'B': {
                        elemType = "byte";
                        break;
                    }
                    case 'I': {
                        elemType = "int";
                        break;
                    }
                    case 'Z': {
                        elemType = "boolean";
                        break;
                    }
                    case 'F': {
                        elemType = "float";
                        break;
                    }
                    case 'D': {
                        elemType = "double";
                        break;
                    }
                    case 'S': {
                        elemType = "short";
                        break;
                    }
                    case 'J': {
                        elemType = "long";
                    }
                }
            } else {
                elemType = className.substring(lastBrackPos + 1);
            }
            int nDims = lastBrackPos + 1;
            tmpBuf.setLength(0);
            tmpBuf.append(elemType);
            for (int i = 0; i < nDims; ++i) {
                tmpBuf.append("[]");
            }
            return tmpBuf.toString();
        }
        return className;
    }

    public static String utf8ToString(byte[] src, int stPos, int utf8Len) {
        if (strBuf == null || strBuf.length < utf8Len) {
            strBuf = new char[utf8Len];
        }
        int i = stPos;
        int j = 0;
        int limit = stPos + utf8Len;
        while (i < limit) {
            int b;
            if ((b = src[i++] & 0xFF) >= 224) {
                b = (b & 0xF) << 12;
                b |= (src[i++] & 0x3F) << 6;
                b |= src[i++] & 0x3F;
            } else if (b >= 192) {
                b = (b & 0x1F) << 6;
                b |= src[i++] & 0x3F;
            }
            StringUtils.strBuf[j++] = (char)b;
        }
        return new String(strBuf, 0, j).intern();
    }

    private static int getDaysDifference(Calendar before, Calendar after) {
        int diff = after.get(6) - before.get(6);
        return diff += before.getMaximum(6) * (after.get(1) - before.get(1));
    }

    private static int getWeekDifference(Calendar before, Calendar after) {
        int diff = after.get(3) - before.get(3);
        return diff += before.getMaximum(3) * (after.get(1) - before.get(1));
    }
}

