/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;

public class RuntimeMemoryCCTNode
implements Cloneable,
RuntimeCCTNode {
    protected static final int TYPE_RuntimeMemoryCCTNode = 1;
    protected static final int TYPE_RuntimeObjAllocTermCCTNode = 2;
    protected static final int TYPE_RuntimeObjLivenessTermCCTNode = 3;
    Object children;
    int methodId;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RuntimeMemoryCCTNode() {
    }

    RuntimeMemoryCCTNode(int methodId) {
        this.methodId = methodId;
    }

    public int getType() {
        return 1;
    }

    public static RuntimeMemoryCCTNode create(int type) {
        switch (type) {
            case 1: {
                return new RuntimeMemoryCCTNode();
            }
            case 2: {
                return new RuntimeObjAllocTermCCTNode();
            }
            case 3: {
                return new RuntimeObjLivenessTermCCTNode();
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public void addAllJMethodIds(Set set) {
        if (this.methodId != 0) {
            set.add(new Integer(this.methodId));
        }
        if (this.children != null) {
            if (this.children instanceof RuntimeMemoryCCTNode) {
                ((RuntimeMemoryCCTNode)this.children).addAllJMethodIds(set);
            } else {
                RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])this.children;
                for (int i = 0; i < ar.length; ++i) {
                    ar[i].addAllJMethodIds(set);
                }
            }
        }
    }

    public RuntimeMemoryCCTNode addNewChild(int methodId) {
        if (this.children == null) {
            this.children = new RuntimeMemoryCCTNode(methodId);
            return (RuntimeMemoryCCTNode)this.children;
        }
        RuntimeMemoryCCTNode[] ar = this.addChildEntry();
        RuntimeMemoryCCTNode runtimeMemoryCCTNode = new RuntimeMemoryCCTNode(methodId);
        ar[ar.length - 1] = runtimeMemoryCCTNode;
        return runtimeMemoryCCTNode;
    }

    public void attachNodeAsChild(RuntimeMemoryCCTNode node) {
        if (this.children == null) {
            this.children = node;
        } else {
            RuntimeMemoryCCTNode[] ar = this.addChildEntry();
            ar[ar.length - 1] = node;
        }
    }

    public Object clone() {
        try {
            RuntimeMemoryCCTNode ret = (RuntimeMemoryCCTNode)super.clone();
            if (this.children != null) {
                if (this.children instanceof RuntimeMemoryCCTNode) {
                    ret.children = ((RuntimeMemoryCCTNode)this.children).clone();
                } else {
                    RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])this.children;
                    ret.children = new RuntimeMemoryCCTNode[ar.length];
                    for (int i = 0; i < ar.length; ++i) {
                        ((RuntimeMemoryCCTNode[])ret.children)[i] = (RuntimeMemoryCCTNode)ar[i].clone();
                    }
                }
            }
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Clone should never fail");
        }
    }

    public void readFromStream(DataInputStream in) throws IOException {
        this.methodId = in.readInt();
        int len = in.readInt();
        if (len == 0) {
            this.children = null;
        } else if (len == 1) {
            int type = in.readInt();
            this.children = RuntimeMemoryCCTNode.create(type);
            ((RuntimeMemoryCCTNode)this.children).readFromStream(in);
        } else {
            RuntimeMemoryCCTNode[] ar = new RuntimeMemoryCCTNode[len];
            for (int i = 0; i < len; ++i) {
                int type = in.readInt();
                ar[i] = RuntimeMemoryCCTNode.create(type);
                ar[i].readFromStream(in);
            }
            this.children = ar;
        }
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(this.methodId);
        if (this.children == null) {
            out.writeInt(0);
        } else if (this.children instanceof RuntimeMemoryCCTNode) {
            out.writeInt(1);
            out.writeInt(((RuntimeMemoryCCTNode)this.children).getType());
            ((RuntimeMemoryCCTNode)this.children).writeToStream(out);
        } else {
            RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])this.children;
            out.writeInt(ar.length);
            for (int i = 0; i < ar.length; ++i) {
                out.writeInt(ar[i].getType());
                ar[i].writeToStream(out);
            }
        }
    }

    private RuntimeMemoryCCTNode[] addChildEntry() {
        if (!$assertionsDisabled && this.children == null) {
            throw new AssertionError();
        }
        if (this.children instanceof RuntimeMemoryCCTNode) {
            RuntimeMemoryCCTNode[] ret = new RuntimeMemoryCCTNode[2];
            ret[0] = (RuntimeMemoryCCTNode)this.children;
            this.children = ret;
            return ret;
        }
        RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])this.children;
        RuntimeMemoryCCTNode[] newchildren = new RuntimeMemoryCCTNode[ar.length + 1];
        System.arraycopy(ar, 0, newchildren, 0, ar.length);
        this.children = newchildren;
        return newchildren;
    }

    static {
        $assertionsDisabled = !RuntimeMemoryCCTNode.class.desiredAssertionStatus();
    }
}

