/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.cct.nodes;

import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTNodeFactory;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.BaseCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;

public abstract class TimedCPUCCTNode
extends BaseCPUCCTNode
implements Cloneable,
RuntimeCPUCCTNode {
    public static final int FILTERED_NO = 0;
    public static final int FILTERED_YES = 2;
    public static final int FILTERED_MAYBE = 1;
    private TimingData timingData;
    private char filteredStatus;
    private int nCalls;
    private int nCallsDiff;
    private long lastWaitOrSleepStamp;

    public TimedCPUCCTNode(CPUCCTNodeFactory factory, boolean collectingTwoTimestamps) {
        super(factory);
        this.timingData = collectingTwoTimestamps ? new TimingDataExtended() : new TimingDataSimple();
    }

    public synchronized void setFilteredStatus(int status) {
        this.filteredStatus = (char)(status & 0xFF);
    }

    public synchronized int getFilteredStatus() {
        return this.filteredStatus;
    }

    public synchronized void setLastWaitOrSleepStamp(long time) {
        this.lastWaitOrSleepStamp = time;
    }

    public synchronized long getLastWaitOrSleepStamp() {
        return this.lastWaitOrSleepStamp;
    }

    public synchronized void setNCalls(int calls) {
        this.nCalls = calls;
    }

    public synchronized int getNCalls() {
        return this.nCalls;
    }

    public synchronized void setNCallsDiff(int calls) {
        this.nCallsDiff = calls;
    }

    public synchronized int getNCallsDiff() {
        return this.nCallsDiff;
    }

    public void setNetTime0(long time) {
        this.timingData.setNetTime0(time);
    }

    public long getNetTime0() {
        return this.timingData.getNetTime0();
    }

    public void setNetTime1(long time) {
        this.timingData.setNetTime1(time);
    }

    public long getNetTime1() {
        return this.timingData.getNetTime1();
    }

    public void setSleepTime0(long time) {
        this.timingData.setSleepTime0(time);
    }

    public long getSleepTime0() {
        return this.timingData.getSleepTime0();
    }

    public void setWaitTime0(long time) {
        this.timingData.setWaitTime0(time);
    }

    public synchronized long getWaitTime0() {
        return this.timingData.getWaitTime0();
    }

    public synchronized int addNCalls(int calls) {
        this.nCalls += calls;
        return this.nCalls;
    }

    public synchronized int addNCallsDiff(int calls) {
        this.nCallsDiff += calls;
        return this.nCallsDiff;
    }

    public long addNetTime0(long time) {
        return this.timingData.addNetTime0(time);
    }

    public long addNetTime1(long time) {
        return this.timingData.addNetTime1(time);
    }

    public long addSleepTime0(long time) {
        return this.timingData.addSleepTime0(time);
    }

    public long addWaitTime0(long time) {
        return this.timingData.addWaitTime0(time);
    }

    public synchronized Object clone() {
        TimedCPUCCTNode node = this.createSelfInstance();
        node.setNCalls(this.getNCalls());
        node.setNetTime0(this.getNetTime0());
        node.setNetTime1(this.getNetTime1());
        node.setSleepTime0(this.getSleepTime0());
        node.setWaitTime0(this.getWaitTime0());
        node.setFilteredStatus(this.getFilteredStatus());
        node.setNCallsDiff(0);
        return node;
    }

    protected abstract TimedCPUCCTNode createSelfInstance();

    private static class TimingDataSimple
    implements TimingData {
        private long netTime0;
        private long sleepTime0;
        private long waitTime0;

        private TimingDataSimple() {
        }

        public synchronized void setNetTime0(long time) {
            this.netTime0 = time;
        }

        public synchronized long getNetTime0() {
            return this.netTime0;
        }

        public void setNetTime1(long time) {
        }

        public long getNetTime1() {
            return 0L;
        }

        public synchronized void setSleepTime0(long time) {
            this.sleepTime0 = time;
        }

        public synchronized long getSleepTime0() {
            return this.sleepTime0;
        }

        public synchronized void setWaitTime0(long time) {
            this.waitTime0 = time;
        }

        public synchronized long getWaitTime0() {
            return this.waitTime0;
        }

        public synchronized long addNetTime0(long time) {
            this.netTime0 += time;
            return this.netTime0;
        }

        public long addNetTime1(long time) {
            return 0L;
        }

        public synchronized long addSleepTime0(long time) {
            this.sleepTime0 += time;
            return this.sleepTime0;
        }

        public synchronized long addWaitTime0(long time) {
            this.waitTime0 += time;
            return this.waitTime0;
        }
    }

    private static class TimingDataExtended
    extends TimingDataSimple {
        private long netTime1;

        private TimingDataExtended() {
        }

        public synchronized void setNetTime1(long time) {
            this.netTime1 = time;
        }

        public synchronized long getNetTime1() {
            return this.netTime1;
        }

        public synchronized long addNetTime1(long time) {
            this.netTime1 += time;
            return this.netTime1;
        }
    }

    private static interface TimingData {
        public void setNetTime0(long var1);

        public long getNetTime0();

        public void setNetTime1(long var1);

        public long getNetTime1();

        public void setSleepTime0(long var1);

        public long getSleepTime0();

        public void setWaitTime0(long var1);

        public long getWaitTime0();

        public long addNetTime0(long var1);

        public long addNetTime1(long var1);

        public long addSleepTime0(long var1);

        public long addWaitTime0(long var1);
    }
}

