/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.logging.Level;
import org.netbeans.lib.profiler.results.AbstractDataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;

public class CPUDataFrameProcessor
extends AbstractDataFrameProcessor {
    private volatile int currentThreadId = -1;

    public void doProcessDataFrame(byte[] buffer) {
        boolean collectingTwoTimeStamps;
        int position = 0;
        boolean bl = collectingTwoTimeStamps = this.client != null ? this.client.getStatus().collectingTwoTimeStamps() : false;
        block28: while (position < buffer.length) {
            byte eventType;
            if (((eventType = buffer[position++]) & 0xFFFFFF80) != 0) {
                char charEvent = (char)((eventType & 0xFF) << 8 | buffer[position++] & 0xFF);
                if ((byte)(eventType & 0xFFFFFFC0) == -64) {
                    this.fireMethodExitUnstamped(charEvent & 0x3FFF, this.currentThreadId, 1);
                    continue;
                }
                this.fireMethodEntryUnstamped(charEvent & 0x3FFF, this.currentThreadId, 1);
                continue;
            }
            if (eventType != 26 && eventType != 27 && eventType != 13 && eventType != 11 && eventType != 10) {
                int methodId = -1;
                long timeStamp0 = 0L;
                long timeStamp1 = 0L;
                if (eventType != 5 && eventType != 20 && eventType != 21 && eventType != 22 && eventType != 23 && eventType != 24 && eventType != 25) {
                    methodId = (buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF;
                }
                if (eventType != 16 && eventType != 17 && eventType != 18 && eventType != 19) {
                    timeStamp0 = ((long)buffer[position++] & 0xFFL) << 48 | ((long)buffer[position++] & 0xFFL) << 40 | ((long)buffer[position++] & 0xFFL) << 32 | ((long)buffer[position++] & 0xFFL) << 24 | ((long)buffer[position++] & 0xFFL) << 16 | ((long)buffer[position++] & 0xFFL) << 8 | (long)buffer[position++] & 0xFFL;
                    if (eventType != 20 && eventType != 21 && eventType != 22 && eventType != 23 && eventType != 24 && eventType != 25 && (collectingTwoTimeStamps || eventType < 6)) {
                        timeStamp1 = ((long)buffer[position++] & 0xFFL) << 48 | ((long)buffer[position++] & 0xFFL) << 40 | ((long)buffer[position++] & 0xFFL) << 32 | ((long)buffer[position++] & 0xFFL) << 24 | ((long)buffer[position++] & 0xFFL) << 16 | ((long)buffer[position++] & 0xFFL) << 8 | (long)buffer[position++] & 0xFFL;
                    }
                }
                switch (eventType) {
                    case 18: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Marker entry unstamped, tId=" + this.currentThreadId + ", mId=" + methodId);
                        }
                        this.fireMethodEntryUnstamped(methodId, this.currentThreadId, 3);
                        break;
                    }
                    case 16: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Method entry unstamped, tId=" + this.currentThreadId + ", mId=" + methodId);
                        }
                        this.fireMethodEntryUnstamped(methodId, this.currentThreadId, 1);
                        break;
                    }
                    case 19: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Marker exit unstamped, tId=" + this.currentThreadId + ", mId=" + methodId);
                        }
                        this.fireMethodExitUnstamped(methodId, this.currentThreadId, 3);
                        break;
                    }
                    case 17: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Method exit unstamped, tId=" + this.currentThreadId + ", mId=" + methodId);
                        }
                        this.fireMethodExitUnstamped(methodId, this.currentThreadId, 1);
                        break;
                    }
                    case 3: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Marker entry , tId=" + this.currentThreadId + ", mId=" + methodId);
                        }
                        this.fireMethodEntry(methodId, this.currentThreadId, 3, timeStamp0, timeStamp1);
                        break;
                    }
                    case 1: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Root entry , tId=" + this.currentThreadId + ", mId=" + methodId);
                        }
                        this.fireMethodEntry(methodId, this.currentThreadId, 2, timeStamp0, timeStamp1);
                        break;
                    }
                    case 6: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Method entry , tId=" + this.currentThreadId + ", mId=" + methodId);
                        }
                        this.fireMethodEntry(methodId, this.currentThreadId, 1, timeStamp0, timeStamp1);
                        break;
                    }
                    case 4: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Marker exit , tId=" + this.currentThreadId + ", mId=" + methodId);
                        }
                        this.fireMethodExit(methodId, this.currentThreadId, 3, timeStamp0, timeStamp1);
                        break;
                    }
                    case 2: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Root exit , tId=" + this.currentThreadId + ", mId=" + methodId);
                        }
                        this.fireMethodExit(methodId, this.currentThreadId, 2, timeStamp0, timeStamp1);
                        break;
                    }
                    case 7: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Method exit , tId=" + this.currentThreadId + ", mId=" + methodId);
                        }
                        this.fireMethodExit(methodId, this.currentThreadId, 1, timeStamp0, timeStamp1);
                        break;
                    }
                    case 5: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Adjust time , tId=" + this.currentThreadId);
                        }
                        this.fireAdjustTime(this.currentThreadId, timeStamp0, timeStamp1);
                        break;
                    }
                    case 22: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Monitor entry , tId=" + this.currentThreadId);
                        }
                        this.fireMonitorEntry(this.currentThreadId, timeStamp0, timeStamp1);
                        break;
                    }
                    case 23: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Monitor exit , tId=" + this.currentThreadId);
                        }
                        this.fireMonitorExit(this.currentThreadId, timeStamp0, timeStamp1);
                        break;
                    }
                    case 24: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Sleep entry , tId=" + this.currentThreadId);
                        }
                        this.fireSleepEntry(this.currentThreadId, timeStamp0, timeStamp1);
                        break;
                    }
                    case 25: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Sleep exit , tId=" + this.currentThreadId);
                        }
                        this.fireSleepExit(this.currentThreadId, timeStamp0, timeStamp1);
                        break;
                    }
                    case 20: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Wait entry , tId=" + this.currentThreadId);
                        }
                        this.fireWaitEntry(this.currentThreadId, timeStamp0, timeStamp1);
                        break;
                    }
                    case 21: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Wait exit , tId=" + this.currentThreadId);
                        }
                        this.fireWaitExit(this.currentThreadId, timeStamp0, timeStamp1);
                        break;
                    }
                    case 8: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Threads suspend");
                        }
                        this.fireThreadsSuspend(timeStamp0, timeStamp1);
                        break;
                    }
                    case 9: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Threads resume");
                        }
                        this.fireThreadsResumed(timeStamp0, timeStamp1);
                        break;
                    }
                    default: {
                        LOGGER.severe("*** Profiler Engine: internal error: got unknown event type in CPUDataFrameProcessor: " + eventType + " at " + position);
                        break;
                    }
                }
                continue;
            }
            switch (eventType) {
                case 26: {
                    int id = (buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF;
                    long timeStamp = ((long)buffer[position++] & 0xFFL) << 48 | ((long)buffer[position++] & 0xFFL) << 40 | ((long)buffer[position++] & 0xFFL) << 32 | ((long)buffer[position++] & 0xFFL) << 24 | ((long)buffer[position++] & 0xFFL) << 16 | ((long)buffer[position++] & 0xFFL) << 8 | (long)buffer[position++] & 0xFFL;
                    int threadId = (buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF;
                    this.fireProfilingPoint(threadId, id, timeStamp);
                    continue block28;
                }
                case 13: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Change current thread , tId=" + this.currentThreadId);
                    }
                    this.currentThreadId = (char)((buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF);
                    continue block28;
                }
                case 11: {
                    char threadId = (char)((buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF);
                    int strLen = (buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF;
                    String threadName = new String(buffer, position, strLen);
                    position += strLen;
                    strLen = (buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF;
                    String threadClassName = new String(buffer, position, strLen);
                    position += strLen;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Creating new thread , tId=" + threadId);
                    }
                    this.fireNewThread(threadId, threadName, threadClassName);
                    this.currentThreadId = threadId;
                    continue block28;
                }
                case 27: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Servlet track start , tId=" + this.currentThreadId);
                    }
                    byte requestType = buffer[position++];
                    int strLen = (buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF;
                    String servletPath = new String(buffer, position, strLen);
                    position += strLen;
                    int sessionId = (buffer[position++] & 0xFF) << 24 | (buffer[position++] & 0xFF) << 16 | (buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF;
                    this.fireServletRequest(this.currentThreadId, requestType, servletPath, sessionId);
                    continue block28;
                }
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    continue block28;
                }
            }
            LOGGER.severe("*** Profiler Engine: internal error: got unknown event type in CallGraphBuilder: " + eventType + " at " + position);
        }
    }

    private void fireAdjustTime(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).timeAdjust(threadId, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireMethodEntry(final int methodId, final int threadId, final int methodType, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).methodEntry(methodId, threadId, methodType, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireMethodEntryUnstamped(final int methodId, final int threadId, final int methodType) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).methodEntryUnstamped(methodId, threadId, methodType);
            }
        });
    }

    private void fireMethodExit(final int methodId, final int threadId, final int methodType, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).methodExit(methodId, threadId, methodType, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireMethodExitUnstamped(final int methodId, final int threadId, final int methodType) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).methodExitUnstamped(methodId, threadId, methodType);
            }
        });
    }

    private void fireMonitorEntry(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).monitorEntry(threadId, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireMonitorExit(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).monitorExit(threadId, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireNewThread(final int threadId, final String threadName, final String threadClassName) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).newThread(threadId, threadName, threadClassName);
            }
        });
    }

    private void fireServletRequest(final int threadId, final int requestType, final String servletPath, final int sessionId) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).servletRequest(threadId, requestType, servletPath, sessionId);
            }
        });
    }

    private void fireSleepEntry(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).sleepEntry(threadId, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireSleepExit(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).sleepExit(threadId, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireThreadsResumed(final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).threadsSuspend(timeStamp0, timeStamp1);
            }
        });
    }

    private void fireThreadsSuspend(final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).threadsSuspend(timeStamp0, timeStamp1);
            }
        });
    }

    private void fireWaitEntry(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).waitEntry(threadId, timeStamp0, timeStamp1);
            }
        });
    }

    private void fireWaitExit(final int threadId, final long timeStamp0, final long timeStamp1) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            public void execute(ProfilingResultListener listener) {
                ((CPUProfilingResultListener)listener).waitExit(threadId, timeStamp0, timeStamp1);
            }
        });
    }
}

