/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.ArrayList;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.classfile.PlaceholderClassInfo;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.RecursiveMethodInstrumentor;
import org.netbeans.lib.profiler.instrumentation.RootMethods;
import org.netbeans.lib.profiler.utils.Wildcards;

public class RecursiveMethodInstrumentor2
extends RecursiveMethodInstrumentor {
    public RecursiveMethodInstrumentor2(ProfilingSessionStatus status, ProfilerEngineSettings settings) {
        super(status, settings);
    }

    Object[] getInitialMethodsToInstrument(String[] loadedClasses, int[] loadedClassLoaderIds, byte[][] cachedClassFileBytes, RootMethods roots) {
        DynamicClassInfo[] loadedClassInfos = this.preGetInitialMethodsToInstrument(loadedClasses, loadedClassLoaderIds, cachedClassFileBytes);
        this.rootMethods = roots;
        for (int j = 0; j < loadedClassInfos.length; ++j) {
            if (loadedClassInfos[j] == null) continue;
            this.tryInstrumentSpawnedThreads(loadedClassInfos[j]);
            for (int rIdx = 0; rIdx < this.rootMethods.classNames.length; ++rIdx) {
                String rootClassName = this.rootMethods.classNames[rIdx];
                boolean isMatch = false;
                if (this.rootMethods.classesWildcard[rIdx]) {
                    if (this.matchesWildcard(Wildcards.unwildPackage(rootClassName), loadedClassInfos[j].getName())) {
                        isMatch = true;
                    }
                } else if (loadedClassInfos[j].getName().equals(rootClassName)) {
                    isMatch = true;
                }
                if (!isMatch) continue;
                if (Wildcards.isPackageWildcard(rootClassName) || Wildcards.isMethodWildcard(this.rootMethods.methodNames[rIdx])) {
                    if (this.rootMethods.markerMethods[rIdx]) {
                        this.markAllMethodsMarker(loadedClassInfos[j]);
                    } else {
                        this.markAllMethodsRoot(loadedClassInfos[j]);
                    }
                    String[] methodNames = loadedClassInfos[j].getMethodNames();
                    String[] signatures = loadedClassInfos[j].getMethodSignatures();
                    for (int methodIdx = 0; methodIdx < methodNames.length; ++methodIdx) {
                        this.checkAndScanMethod(loadedClassInfos[j], methodNames[methodIdx], signatures[methodIdx], false, false, false);
                    }
                    continue;
                }
                this.markMethod(loadedClassInfos[j], rIdx);
                this.checkAndScanMethod(loadedClassInfos[j], this.rootMethods.methodNames[rIdx], this.rootMethods.methodSignatures[rIdx], false, false, false);
            }
        }
        this.checkAndScanMethod(RecursiveMethodInstrumentor2.javaClassForName("java/lang/ClassLoader", 0), "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", true, false, true);
        return this.createInstrumentedMethodPack();
    }

    public Object[] getMethodsToInstrumentUponClassLoad(String className, int classLoaderId, boolean threadInCallGraph) {
        boolean normallyFilteredOut;
        className = className.replace('.', '/').intern();
        boolean isRootClass = false;
        for (int rIdx = 0; rIdx < this.rootMethods.classNames.length; ++rIdx) {
            String rootClassName = this.rootMethods.classNames[rIdx];
            if (this.rootMethods.classesWildcard[rIdx]) {
                if (!this.matchesWildcard(Wildcards.unwildPackage(rootClassName), className)) continue;
                isRootClass = true;
                break;
            }
            if (!className.equals(rootClassName)) continue;
            isRootClass = true;
            break;
        }
        boolean bl = normallyFilteredOut = !this.instrFilter.passesFilter(className);
        if (!isRootClass && normallyFilteredOut) {
            return null;
        }
        DynamicClassInfo clazz = RecursiveMethodInstrumentor2.javaClassForName(className, classLoaderId);
        if (clazz == null) {
            return null;
        }
        this.initInstrMethodData();
        this.instrumentClinit = threadInCallGraph;
        if (!clazz.isLoaded()) {
            clazz.setLoaded(true);
            this.addToSubclassList(clazz, normallyFilteredOut ? null : clazz);
            for (int rIdx = 0; rIdx < this.rootMethods.classNames.length; ++rIdx) {
                String rootClassName = this.rootMethods.classNames[rIdx];
                boolean isMatch = false;
                if (this.rootMethods.classesWildcard[rIdx]) {
                    if (this.matchesWildcard(Wildcards.unwildPackage(rootClassName), className)) {
                        isMatch = true;
                    }
                } else if (className.equals(rootClassName)) {
                    isMatch = true;
                }
                if (!isMatch) continue;
                if (Wildcards.isPackageWildcard(rootClassName) || Wildcards.isMethodWildcard(this.rootMethods.methodNames[rIdx])) {
                    if (this.rootMethods.markerMethods[rIdx]) {
                        this.markAllMethodsMarker(clazz);
                    } else {
                        this.markAllMethodsRoot(clazz);
                    }
                    String[] methodNames = clazz.getMethodNames();
                    String[] signatures = clazz.getMethodSignatures();
                    for (int methodIdx = 0; methodIdx < methodNames.length; ++methodIdx) {
                        this.checkAndScanMethod(clazz, methodNames[methodIdx], signatures[methodIdx], false, false, false);
                    }
                    continue;
                }
                this.markMethod(clazz, rIdx);
                this.checkAndScanMethod(clazz, this.rootMethods.methodNames[rIdx], this.rootMethods.methodSignatures[rIdx], false, false, false);
            }
            if (!clazz.isInterface()) {
                String[] methodNames = clazz.getMethodNames();
                String[] methodSignatures = clazz.getMethodSignatures();
                for (int i = 0; i < methodNames.length; ++i) {
                    if (!clazz.isMethodReachable(i) && (normallyFilteredOut || !this.instrumentClinit || methodNames[i] != "<clinit>")) continue;
                    this.checkAndScanMethod(clazz, methodNames[i], methodSignatures[i], false, false, false);
                }
            }
            this.tryInstrumentSpawnedThreads(clazz);
            return this.createInstrumentedMethodPack();
        }
        return null;
    }

    public Object[] getMethodsToInstrumentUponMethodInvocation(String className, int classLoaderId, String methodName, String methodSignature) {
        return null;
    }

    public Object[] getMethodsToInstrumentUponReflectInvoke(String className, int classLoaderId, String methodName, String methodSignature) {
        DynamicClassInfo clazz = RecursiveMethodInstrumentor2.javaClassForName(className = className.replace('.', '/').intern(), classLoaderId);
        if (clazz == null) {
            return null;
        }
        this.initInstrMethodData();
        this.instrumentClinit = true;
        methodName = methodName.intern();
        methodSignature = methodSignature.intern();
        this.checkAndScanMethod(clazz, methodName, methodSignature, false, false, false);
        return this.createInstrumentedMethodPack();
    }

    protected void findAndMarkOverridingMethodsReachable(DynamicClassInfo superClass, DynamicClassInfo subClass) {
        String[] methodNames = superClass.getMethodNames();
        String[] methodSignatures = superClass.getMethodSignatures();
        for (int i = 0; i < methodNames.length; ++i) {
            if (!superClass.isMethodVirtual(i) || !superClass.isMethodReachable(i)) continue;
            this.checkAndScanMethod(subClass, methodNames[i], methodSignatures[i], true, false, false);
        }
    }

    protected void processInvoke(DynamicClassInfo clazz, boolean virtualCall, int index) {
        byte[] savedCodeBytes = this.codeBytes;
        int savedOffset = this.offset;
        String[] cms = clazz.getRefMethodsClassNameAndSig(index);
        if (cms == null) {
            return;
        }
        String refClassName = cms[0];
        if (refClassName.startsWith("org/netbeans/lib/profiler/server/")) {
            return;
        }
        int loaderId = clazz.getLoaderId();
        BaseClassInfo refClazz = RecursiveMethodInstrumentor2.loadedJavaClassOrExistingPlaceholderForName(refClassName, loaderId);
        if (refClazz == null || refClazz instanceof PlaceholderClassInfo) {
            RecursiveMethodInstrumentor.ReachableMethodPlaceholder pci = refClazz == null ? new ReachableMethodPlaceholder2(refClassName, loaderId) : (RecursiveMethodInstrumentor.ReachableMethodPlaceholder)refClazz;
            pci.registerReachableMethod(cms[1], cms[2]);
            if (refClazz == null) {
                RecursiveMethodInstrumentor2.registerPlaceholder(pci);
            }
        } else {
            this.checkAndScanMethod((DynamicClassInfo)refClazz, cms[1], cms[2], virtualCall, true, true);
        }
        this.offset = savedOffset;
        this.codeBytes = savedCodeBytes;
    }

    protected boolean tryInstrumentSpawnedThreads(DynamicClassInfo clazz) {
        if (this.instrumentSpawnedThreads && clazz.implementsInterface("java/lang/Runnable") && clazz.getName() != "java/lang/Thread") {
            boolean res = this.markMethodRoot(clazz, "run", "()V");
            this.checkAndScanMethod(clazz, "run", "()V", false, false, false);
            return res;
        }
        return false;
    }

    private boolean checkAndScanMethod(DynamicClassInfo clazz, String methodName, String methodSignature, boolean virtualCall, boolean lookupInSuperIfNotFoundInThis, boolean checkSubclasses) {
        DynamicClassInfo superClazz;
        int i;
        ArrayList subclasses;
        String className = clazz.getName();
        int idx = clazz.getMethodIndex(methodName, methodSignature);
        if (idx != -1) {
            byte[] bytecode = null;
            if (!clazz.isMethodReachable(idx)) {
                clazz.setMethodReachable(idx);
                if (!(clazz.isMethodStatic(idx) || clazz.isMethodPrivate(idx) || clazz.isMethodFinal(idx) || methodName == "<init>")) {
                    clazz.setMethodVirtual(idx);
                }
                if (clazz.isMethodNative(idx) || clazz.isMethodAbstract(idx) || !clazz.isMethodRoot(idx) && !clazz.isMethodMarker(idx) && !this.instrFilter.passesFilter(className) || className == "java/lang/Object") {
                    clazz.setMethodUnscannable(idx);
                } else {
                    bytecode = clazz.getMethodBytecode(idx);
                    if (this.dontInstrumentEmptyMethods && RecursiveMethodInstrumentor2.isEmptyMethod(bytecode) || this.dontScanGetterSetterMethods && RecursiveMethodInstrumentor2.isGetterSetterMethod(bytecode)) {
                        clazz.setMethodUnscannable(idx);
                    } else if (this.isLeafMethod(bytecode)) {
                        clazz.setMethodLeaf(idx);
                    }
                }
            } else {
                if (clazz.isMethodScanned(idx) || clazz.isMethodUnscannable(idx)) {
                    return true;
                }
                bytecode = clazz.getMethodBytecode(idx);
            }
            if (!clazz.isLoaded()) {
                return true;
            }
            if (!clazz.isMethodUnscannable(idx)) {
                this.markClassAndMethodForInstrumentation(clazz, idx);
                clazz.setMethodScanned(idx);
                this.scanBytecode(clazz, bytecode);
            }
        }
        if (checkSubclasses && (idx != -1 && clazz.isMethodVirtual(idx) || idx == -1 && virtualCall) && (subclasses = clazz.getSubclasses()) != null) {
            for (i = 0; i < subclasses.size(); ++i) {
                this.checkAndScanMethod((DynamicClassInfo)subclasses.get(i), methodName, methodSignature, virtualCall, false, false);
            }
        }
        if (idx != -1) {
            return true;
        }
        if (!lookupInSuperIfNotFoundInThis) {
            return false;
        }
        if (!clazz.isInterface() && (superClazz = clazz.getSuperClass()) != null && superClazz.getName() != clazz.getName() && this.checkAndScanMethod(superClazz, methodName, methodSignature, virtualCall, true, false)) {
            return true;
        }
        DynamicClassInfo[] interfaces = clazz.getSuperInterfaces();
        if (interfaces == null) {
            return false;
        }
        for (i = 0; i < interfaces.length; ++i) {
            DynamicClassInfo intfClazz = interfaces[i];
            if (intfClazz == null || !this.checkAndScanMethod(intfClazz, methodName, methodSignature, virtualCall, true, false)) continue;
            return true;
        }
        return false;
    }

    private DynamicClassInfo[] preGetInitialMethodsToInstrument(String[] loadedClasses, int[] loadedClassLoaderIds, byte[][] cachedClassFileBytes) {
        RecursiveMethodInstrumentor2.resetLoadedClassData();
        RecursiveMethodInstrumentor2.storeClassFileBytesForCustomLoaderClasses(loadedClasses, loadedClassLoaderIds, cachedClassFileBytes);
        this.initInstrMethodData();
        DynamicClassInfo[] loadedClassInfos = null;
        loadedClassInfos = new DynamicClassInfo[loadedClasses.length];
        for (int i = 0; i < loadedClasses.length; ++i) {
            String className = loadedClasses[i].replace('.', '/').intern();
            DynamicClassInfo clazz = RecursiveMethodInstrumentor2.javaClassForName(className, loadedClassLoaderIds[i]);
            if (clazz == null) continue;
            clazz.setLoaded(true);
            this.addToSubclassList(clazz, clazz);
            loadedClassInfos[i] = clazz;
        }
        return loadedClassInfos;
    }

    protected class ReachableMethodPlaceholder2
    extends RecursiveMethodInstrumentor.ReachableMethodPlaceholder {
        public ReachableMethodPlaceholder2(String refClassName, int classLoaderId) {
            super(refClassName, classLoaderId);
        }

        public void transferDataIntoRealClass(DynamicClassInfo clazz) {
            super.transferDataIntoRealClass(clazz);
            int len = this.methodNamesAndSigs.size();
            for (int i = 0; i < len; i += 2) {
                RecursiveMethodInstrumentor2.this.checkAndScanMethod(clazz, (String)this.methodNamesAndSigs.get(i), (String)this.methodNamesAndSigs.get(i + 1), false, false, false);
            }
        }
    }
}

