/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofFieldValue;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LoadClass;

class ClassDump
extends HprofObject
implements JavaClass {
    final ClassDumpSegment classDumpSegment;
    private int instances;
    private long loadClassOffset;
    static final /* synthetic */ boolean $assertionsDisabled;

    ClassDump(ClassDumpSegment segment, long offset) {
        super(offset);
        this.classDumpSegment = segment;
        if (!$assertionsDisabled && this.getHprofBuffer().get(offset) != 32) {
            throw new AssertionError();
        }
    }

    public int getAllInstancesSize() {
        if (this.isArray()) {
            return (Integer)this.classDumpSegment.arrayMap.get(this);
        }
        return this.getInstancesCount() * this.getInstanceSize();
    }

    public boolean isArray() {
        return this.classDumpSegment.arrayMap.get(this) != null;
    }

    public Instance getClassLoader() {
        long loaderId = this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.classLoaderIDOffset);
        return this.getHprof().getInstanceByID(loaderId);
    }

    public Field getField(String name) {
        Iterator fIt = this.getFields().iterator();
        while (fIt.hasNext()) {
            Field field = (Field)fIt.next();
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public List getFields() {
        HprofByteBuffer buffer = this.getHprofBuffer();
        long offset = this.fileOffset + (long)this.getInstanceFieldOffset();
        int fields = buffer.getShort(offset);
        ArrayList<HprofField> filedsList = new ArrayList<HprofField>(fields);
        for (int i = 0; i < fields; ++i) {
            filedsList.add(new HprofField(this, offset + 2L + (long)(i * this.classDumpSegment.fieldSize)));
        }
        return filedsList;
    }

    public int getInstanceSize() {
        if (this.isArray()) {
            return -1;
        }
        return this.classDumpSegment.getMinimumInstanceSize() + this.getHprofBuffer().getInt(this.fileOffset + (long)this.classDumpSegment.instanceSizeOffset);
    }

    public List getInstances() {
        return this.getHprof().computeInstances(this);
    }

    public int getInstancesCount() {
        if (this.instances == 0) {
            this.getHprof().computeInstances();
        }
        return this.instances;
    }

    public long getJavaClassId() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.classIDOffset);
    }

    public String getName() {
        return this.getLoadClass().getName();
    }

    public List getStaticFieldValues() {
        HprofByteBuffer buffer = this.getHprofBuffer();
        long offset = this.fileOffset + (long)this.getStaticFieldOffset();
        HprofHeap heap = this.getHprof();
        int fields = buffer.getShort(offset);
        offset += 2L;
        ArrayList<HprofFieldObjectValue> filedsList = new ArrayList<HprofFieldObjectValue>(fields);
        for (int i = 0; i < fields; ++i) {
            byte type = buffer.get(offset + (long)this.classDumpSegment.fieldTypeOffset);
            int fieldSize = this.classDumpSegment.fieldSize + heap.getValueSize(type);
            HprofFieldValue value = type == 2 ? new HprofFieldObjectValue(this, offset) : new HprofFieldValue(this, offset);
            filedsList.add((HprofFieldObjectValue)value);
            offset += (long)fieldSize;
        }
        return filedsList;
    }

    public Collection getSubClasses() {
        List classes = this.classDumpSegment.hprofHeap.getAllClasses();
        ArrayList<JavaClass> subclasses = new ArrayList<JavaClass>(classes.size() / 10);
        HashMap<ClassDump, Boolean> subclassesMap = new HashMap<ClassDump, Boolean>(classes.size() * 4 / 3);
        subclassesMap.put(this, Boolean.TRUE);
        for (int i = 0; i < classes.size(); ++i) {
            JavaClass jcls = (JavaClass)classes.get(i);
            Boolean b = (Boolean)subclassesMap.get(jcls);
            if (b == null) {
                b = ClassDump.isSubClass(jcls, subclassesMap);
            }
            if (b != Boolean.TRUE || jcls == this) continue;
            subclasses.add(jcls);
        }
        return subclasses;
    }

    public JavaClass getSuperClass() {
        long superClassId = this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.superClassIDOffset);
        return this.classDumpSegment.getClassDumpByID(superClassId);
    }

    public Object getValueOfStaticField(String name) {
        Iterator fIt = this.getStaticFieldValues().iterator();
        while (fIt.hasNext()) {
            FieldValue fieldValue = (FieldValue)fIt.next();
            if (!fieldValue.getField().getName().equals(name)) continue;
            if (fieldValue instanceof HprofFieldObjectValue) {
                return ((HprofFieldObjectValue)fieldValue).getInstance();
            }
            return ((HprofFieldValue)fieldValue).getTypeValue();
        }
        return null;
    }

    List getAllInstanceFields() {
        ArrayList fields = new ArrayList(50);
        for (JavaClass jcls = this; jcls != null; jcls = jcls.getSuperClass()) {
            fields.addAll(jcls.getFields());
        }
        return fields;
    }

    void setClassLoadOffset(long offset) {
        this.loadClassOffset = offset;
    }

    int getConstantPoolSize() {
        long cpOffset = this.fileOffset + (long)this.classDumpSegment.constantPoolSizeOffset;
        HprofByteBuffer buffer = this.getHprofBuffer();
        int cpRecords = buffer.getShort(cpOffset);
        HprofHeap heap = this.getHprof();
        cpOffset += 2L;
        for (int i = 0; i < cpRecords; ++i) {
            byte type = buffer.get(cpOffset + 2L);
            int size = heap.getValueSize(type);
            cpOffset += (long)(3 + size);
        }
        return (int)(cpOffset - (this.fileOffset + (long)this.classDumpSegment.constantPoolSizeOffset));
    }

    HprofHeap getHprof() {
        return this.classDumpSegment.hprofHeap;
    }

    HprofByteBuffer getHprofBuffer() {
        return this.classDumpSegment.hprofHeap.dumpBuffer;
    }

    int getInstanceFieldOffset() {
        int staticFieldOffset = this.getStaticFieldOffset();
        return staticFieldOffset + this.getStaticFiledSize(staticFieldOffset);
    }

    LoadClass getLoadClass() {
        return new LoadClass(this.getHprof().getLoadClassSegment(), this.loadClassOffset);
    }

    List getReferences() {
        HprofByteBuffer buffer = this.getHprofBuffer();
        byte[] idArr = new byte[buffer.getIDSize()];
        buffer.get(this.fileOffset + 1L, idArr);
        return this.getHprof().findReferencesFor(this.getJavaClassId(), idArr);
    }

    int getStaticFieldOffset() {
        return this.classDumpSegment.constantPoolSizeOffset + this.getConstantPoolSize();
    }

    int getStaticFiledSize(int staticFieldOffset) {
        HprofByteBuffer buffer = this.getHprofBuffer();
        int idSize = buffer.getIDSize();
        long fieldOffset = this.fileOffset + (long)staticFieldOffset;
        int fields = this.getHprofBuffer().getShort(fieldOffset);
        HprofHeap heap = this.getHprof();
        fieldOffset += 2L;
        for (int i = 0; i < fields; ++i) {
            byte type = buffer.get(fieldOffset + (long)idSize);
            int size = heap.getValueSize(type);
            fieldOffset += (long)(idSize + 1 + size);
        }
        return (int)(fieldOffset - (long)staticFieldOffset - this.fileOffset);
    }

    void findStaticReferencesFor(long instanceId, List refs) {
        HprofByteBuffer buffer = this.getHprofBuffer();
        int idSize = buffer.getIDSize();
        long fieldOffset = this.fileOffset + (long)this.getStaticFieldOffset();
        int fields = this.getHprofBuffer().getShort(fieldOffset);
        List staticFileds = null;
        HprofHeap heap = this.getHprof();
        fieldOffset += 2L;
        for (int i = 0; i < fields; ++i) {
            byte type = buffer.get(fieldOffset + (long)idSize);
            int size = heap.getValueSize(type);
            if (type == 2 && instanceId == buffer.getID(fieldOffset + (long)idSize + 1L)) {
                if (staticFileds == null) {
                    staticFileds = this.getStaticFieldValues();
                }
                refs.add(staticFileds.get(i));
            }
            fieldOffset += (long)(idSize + 1 + size);
        }
    }

    void incrementInstance() {
        ++this.instances;
    }

    private static Boolean isSubClass(JavaClass jcls, Map subclassesMap) {
        Boolean b;
        JavaClass superClass = jcls.getSuperClass();
        if (superClass == null) {
            b = Boolean.FALSE;
        } else {
            b = (Boolean)subclassesMap.get(superClass);
            if (b == null) {
                b = ClassDump.isSubClass(superClass, subclassesMap);
            }
        }
        subclassesMap.put(jcls, b);
        return b;
    }

    static {
        $assertionsDisabled = !ClassDump.class.desiredAssertionStatus();
    }
}

