/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProfilerLogger {
    private static final Logger INSTANCE;
    private static final Level EXCEPTION_LEVEL;
    private static volatile Level DEFAULT_LEVEL;
    private static volatile boolean debugFlag;

    public static boolean isDebug() {
        return debugFlag;
    }

    public static void setLevel(Level level) {
        INSTANCE.setLevel(level);
        debugFlag = level.intValue() <= Level.FINEST.intValue();
    }

    public static Level getLevel() {
        return INSTANCE.getLevel();
    }

    public static void debug(String message) {
        INSTANCE.finest(message);
    }

    public static void info(String message) {
        INSTANCE.info(message);
    }

    public static void log(String message) {
        INSTANCE.log(DEFAULT_LEVEL, message);
    }

    public static void log(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        INSTANCE.log(EXCEPTION_LEVEL, sw.toString());
    }

    public static void severe(String message) {
        INSTANCE.severe(message);
    }

    public static void warning(String message) {
        INSTANCE.warning(message);
    }

    static {
        Level currentLevel;
        INSTANCE = Logger.getLogger("org.netbeans.lib.profiler.infolog");
        EXCEPTION_LEVEL = Level.SEVERE;
        DEFAULT_LEVEL = Level.INFO;
        debugFlag = false;
        Level newLevel = currentLevel = INSTANCE.getLevel();
        newLevel = DEFAULT_LEVEL.intValue() < EXCEPTION_LEVEL.intValue() ? DEFAULT_LEVEL : EXCEPTION_LEVEL;
        if (currentLevel == null || newLevel.intValue() < currentLevel.intValue()) {
            INSTANCE.setLevel(newLevel);
        }
    }
}

