/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.Util;

public final class UTF8Reader
extends Reader {
    private static final String READER_CLOSED = "Reader closed";
    private InputStream in;
    private final PositionedStoreStream positionedIn;
    private long rawStreamPos = 0L;
    private final long utfLen;
    private long utfCount;
    private long readerCharCount;
    private final long maxFieldSize;
    private final char[] buffer = new char[8192];
    private int charactersInBuffer;
    private int readPositionInBuffer;
    private boolean noMoreReads;
    private ConnectionChild parent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UTF8Reader(InputStream inputStream, long l, ConnectionChild connectionChild, Object object) throws IOException, SQLException {
        super(object);
        this.maxFieldSize = l;
        this.parent = connectionChild;
        connectionChild.setupContextStack();
        try {
            Object object2 = this.lock;
            synchronized (object2) {
                if (inputStream instanceof PositionedStoreStream) {
                    this.positionedIn = (PositionedStoreStream)inputStream;
                    this.in = inputStream;
                    try {
                        this.positionedIn.resetStream();
                    }
                    catch (StandardException standardException) {
                        IOException iOException = new IOException(standardException.getMessage());
                        iOException.initCause(standardException);
                        throw iOException;
                    }
                } else {
                    this.positionedIn = null;
                    this.in = new BufferedInputStream(inputStream);
                }
                this.utfLen = this.readUnsignedShort();
                if (this.positionedIn != null) {
                    this.rawStreamPos = this.positionedIn.getPosition();
                }
            }
        }
        finally {
            connectionChild.restoreContextStack();
        }
    }

    public UTF8Reader(InputStream inputStream, long l, long l2, ConnectionChild connectionChild, Object object) {
        super(object);
        this.maxFieldSize = l;
        this.parent = connectionChild;
        this.utfLen = l2;
        this.positionedIn = null;
        this.in = new BufferedInputStream(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return -1;
                }
                this.readPositionInBuffer = 0;
            }
            return this.buffer[this.readPositionInBuffer++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return -1;
                }
                this.readPositionInBuffer = 0;
            }
            if (n2 > (n3 = this.charactersInBuffer - this.readPositionInBuffer)) {
                n2 = n3;
            }
            System.arraycopy(this.buffer, this.readPositionInBuffer, cArray, n, n2);
            this.readPositionInBuffer += n2;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Number of characters to skip must be positive: " + l);
        }
        Object object = this.lock;
        synchronized (object) {
            int n;
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return 0L;
                }
                this.readPositionInBuffer = 0;
            }
            if (l > (long)(n = this.charactersInBuffer - this.readPositionInBuffer)) {
                l = n;
            }
            this.readPositionInBuffer = (int)((long)this.readPositionInBuffer + l);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closeIn();
            this.parent = null;
            this.noMoreReads = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInto(StringBuffer stringBuffer, int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n2;
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return -1;
                }
                this.readPositionInBuffer = 0;
            }
            if (n > (n2 = this.charactersInBuffer - this.readPositionInBuffer)) {
                n = n2;
            }
            stringBuffer.append(this.buffer, this.readPositionInBuffer, n);
            this.readPositionInBuffer += n;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readAsciiInto(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return -1;
                }
                this.readPositionInBuffer = 0;
            }
            if (n2 > (n3 = this.charactersInBuffer - this.readPositionInBuffer)) {
                n2 = n3;
            }
            char[] cArray = this.buffer;
            for (int i = 0; i < n2; ++i) {
                char c = cArray[this.readPositionInBuffer + i];
                int n4 = c <= '\u00ff' ? (int)((byte)c) : 63;
                byArray[n + i] = n4;
            }
            this.readPositionInBuffer += n2;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIn() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
            }
        }
    }

    private IOException utfFormatException(String string) {
        this.noMoreReads = true;
        this.closeIn();
        return new UTFDataFormatException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fillBuffer() throws IOException {
        if (this.in == null) {
            return true;
        }
        this.charactersInBuffer = 0;
        try {
            try {
                int n;
                this.parent.setupContextStack();
                if (this.positionedIn != null) {
                    try {
                        this.positionedIn.reposition(this.rawStreamPos);
                    }
                    catch (StandardException standardException) {
                        throw Util.generateCsSQLException(standardException);
                    }
                }
                block13: while (!(this.charactersInBuffer >= this.buffer.length || this.utfCount >= this.utfLen && this.utfLen != 0L || this.maxFieldSize != 0L && this.readerCharCount >= this.maxFieldSize)) {
                    int n2;
                    n = this.in.read();
                    if (n == -1) {
                        if (this.utfLen != 0L) throw this.utfFormatException("Reached EOF prematurely, read " + this.utfCount + " out of " + this.utfLen + " bytes");
                        this.closeIn();
                        break;
                    }
                    switch (n >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            ++this.utfCount;
                            n2 = n;
                            break;
                        }
                        case 12: 
                        case 13: {
                            this.utfCount += 2L;
                            int n3 = this.in.read();
                            if (n3 == -1) {
                                throw this.utfFormatException("Reached EOF when reading second byte in a two byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            }
                            if ((n3 & 0xC0) != 128) {
                                throw this.utfFormatException("Second byte in a two bytecharacter encoding invalid: (int)" + n3 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            }
                            n2 = (n & 0x1F) << 6 | n3 & 0x3F;
                            break;
                        }
                        case 14: {
                            this.utfCount += 3L;
                            int n3 = this.in.read();
                            int n4 = this.in.read();
                            if (n3 == -1) throw this.utfFormatException("Reached EOF when reading second/third byte in a three byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            if (n4 == -1) {
                                throw this.utfFormatException("Reached EOF when reading second/third byte in a three byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            }
                            if (n == 224 && n3 == 0 && n4 == 0) {
                                if (this.utfLen != 0L) throw this.utfFormatException("Internal error: Derby-specific EOF marker read");
                                this.closeIn();
                                break block13;
                            }
                            if ((n3 & 0xC0) != 128) throw this.utfFormatException("Second/third byte in a three byte character encoding invalid: (int)" + n3 + "/" + n4 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            if ((n4 & 0xC0) != 128) {
                                throw this.utfFormatException("Second/third byte in a three byte character encoding invalid: (int)" + n3 + "/" + n4 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            }
                            n2 = (n & 0xF) << 12 | (n3 & 0x3F) << 6 | (n4 & 0x3F) << 0;
                            break;
                        }
                        default: {
                            throw this.utfFormatException("Invalid UTF encoding at byte/char position " + this.utfCount + "/" + this.readerCharCount + ": (int)" + n);
                        }
                    }
                    this.buffer[this.charactersInBuffer++] = (char)n2;
                    ++this.readerCharCount;
                }
                if (this.utfLen != 0L && this.utfCount > this.utfLen) {
                    throw this.utfFormatException("Incorrect encoded length in stream, expected " + this.utfLen + ", have " + this.utfCount + " bytes");
                }
                if (this.charactersInBuffer != 0) {
                    if (this.positionedIn != null) {
                        this.rawStreamPos = this.positionedIn.getPosition();
                    }
                    n = 0;
                    return n != 0;
                }
                this.closeIn();
                n = 1;
                return n != 0;
            }
            finally {
                this.parent.restoreContextStack();
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException(sQLException.getSQLState() + ": " + sQLException.getMessage());
            iOException.initCause(sQLException);
            throw iOException;
        }
    }

    private final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException("Reached EOF when readingencoded length bytes");
        }
        return (n2 << 8) + (n << 0);
    }
}

