/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.store.access.TransactionController;

public final class StatementRoutinePermission
extends StatementPermission {
    private UUID routineUUID;

    public StatementRoutinePermission(UUID uUID) {
        this.routineUUID = uUID;
    }

    public void check(LanguageConnectionContext languageConnectionContext, String string, boolean bl) throws StandardException {
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        RoutinePermsDescriptor routinePermsDescriptor = dataDictionary.getRoutinePermissions(this.routineUUID, string);
        if (routinePermsDescriptor == null || !routinePermsDescriptor.getHasExecutePermission()) {
            routinePermsDescriptor = dataDictionary.getRoutinePermissions(this.routineUUID, "PUBLIC");
        }
        if (routinePermsDescriptor == null || !routinePermsDescriptor.getHasExecutePermission()) {
            AliasDescriptor aliasDescriptor = dataDictionary.getAliasDescriptor(this.routineUUID);
            if (aliasDescriptor == null) {
                throw StandardException.newException("4250E", "routine");
            }
            SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(aliasDescriptor.getSchemaUUID(), transactionController);
            if (schemaDescriptor == null) {
                throw StandardException.newException("4250E", "schema");
            }
            throw StandardException.newException(bl ? "42505" : "42504", string, (Object)aliasDescriptor.getDescriptorType(), (Object)schemaDescriptor.getSchemaName(), (Object)aliasDescriptor.getDescriptorName());
        }
    }

    public PermissionsDescriptor getPermissionDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        return dataDictionary.getRoutinePermissions(this.routineUUID, string);
    }
}

