/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jmx.application;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.explorer.ExplorerSupport;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.host.HostsSupport;
import com.sun.tools.visualvm.jmx.application.JmxApplication;
import com.sun.tools.visualvm.jmx.application.JmxApplicationsSupport;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.JmxModelFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.remote.JMXServiceURL;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

class JmxApplicationProvider {
    private static final Logger LOGGER = Logger.getLogger(JmxApplicationProvider.class.getName());
    private static final String SNAPSHOT_VERSION = "snapshot_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "0";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.0";
    private static final String PROPERTY_CONNECTION_STRING = "prop_conn_string";
    private static final String PROPERTY_HOSTNAME = "prop_conn_hostname";
    private static final String PROPERTY_USERNAME = "prop_username";
    private static final String PROPERTY_PASSWORD = "prop_password";
    private static final String PROPERTIES_FILE = "jmxapplication.properties";
    private static final String JMX_SUFFIX = ".jmx";
    private static JmxApplicationProvider sharedInstance;
    private boolean trackingNewHosts;
    private Map<String, Set<Storage>> persistedApplications = new HashMap<String, Set<Storage>>();

    JmxApplicationProvider() {
    }

    public static synchronized JmxApplicationProvider sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new JmxApplicationProvider();
        }
        return sharedInstance;
    }

    private static boolean isLocalHost(String hostname) throws IOException {
        InetAddress remoteAddr = InetAddress.getByName(hostname);
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        while (nis.hasMoreElements()) {
            NetworkInterface ni = nis.nextElement();
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress localAddr = addrs.nextElement();
                if (!localAddr.equals(remoteAddr)) continue;
                return true;
            }
        }
        return false;
    }

    private Host getHost(String hostname, JMXServiceURL url) throws IOException {
        if (hostname != null) {
            if (hostname.isEmpty() || JmxApplicationProvider.isLocalHost(hostname)) {
                return Host.LOCALHOST;
            }
            InetAddress addr = InetAddress.getByName(hostname);
            Host host = HostsSupport.getInstance().getHostByAddress(addr);
            if (host == null) {
                host = HostsSupport.getInstance().createHost(hostname);
            }
            return host;
        }
        return Host.UNKNOWN_HOST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJmxApplication(String connectionName, String displayName, String username, String password, boolean saveCredentials) {
        ProgressHandle pHandleF;
        final String normalizedConnectionName = this.normalizeConnectionName(connectionName);
        JMXServiceURL serviceURL = this.getServiceURL(normalizedConnectionName);
        if (serviceURL == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NetBeansProfiler.getDefaultNB().displayError(NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_Invalid_JMX_connection", (Object)normalizedConnectionName));
                }
            });
            return;
        }
        ProgressHandle pHandle = null;
        try {
            pHandle = ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(JmxApplicationProvider.class, (String)"LBL_Adding") + displayName + "..."));
            pHandle.setInitialDelay(0);
            pHandle.start();
            File storageDirectory = Utils.getUniqueFile((File)JmxApplicationsSupport.getStorageDirectory(), (String)("" + System.currentTimeMillis()), (String)JMX_SUFFIX);
            Utils.prepareDirectory((File)storageDirectory);
            Storage storage = new Storage(storageDirectory, PROPERTIES_FILE);
            String[] keys = new String[]{SNAPSHOT_VERSION, PROPERTY_CONNECTION_STRING, PROPERTY_USERNAME, PROPERTY_PASSWORD, "prop_name"};
            String hostName = this.getHostName(serviceURL);
            hostName = hostName == null ? "" : hostName;
            String user = "";
            String passwd = "";
            if (saveCredentials) {
                user = username;
                passwd = password;
            }
            String[] values = new String[]{CURRENT_SNAPSHOT_VERSION, normalizedConnectionName, user, Utils.encodePassword((String)passwd), displayName};
            storage.setCustomProperties(keys, values);
            this.addJmxApplication(serviceURL, normalizedConnectionName, hostName, username, password, saveCredentials, storage);
            pHandleF = pHandle;
        }
        catch (Throwable throwable) {
            ProgressHandle pHandleF2 = pHandle;
            SwingUtilities.invokeLater(new Runnable(pHandleF2){
                final /* synthetic */ ProgressHandle val$pHandleF;
                {
                    this.val$pHandleF = progressHandle;
                }

                public void run() {
                    if (this.val$pHandleF != null) {
                        this.val$pHandleF.finish();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void addJmxApplication(JMXServiceURL serviceURL, final String connectionName, final String hostName, String username, String password, boolean saveCredentials, Storage storage) {
        Host host;
        if (serviceURL == null) {
            serviceURL = this.getServiceURL(connectionName);
        }
        if (serviceURL == null) {
            File appStorage = storage.getDirectory();
            if (appStorage.isDirectory()) {
                Utils.delete((File)appStorage, (boolean)true);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NetBeansProfiler.getDefaultNB().displayError(NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_Invalid_JMX_connection", (Object)connectionName));
                }
            });
            return;
        }
        try {
            host = this.getHost(hostName, serviceURL);
        }
        catch (Exception e) {
            File appStorage = storage.getDirectory();
            if (appStorage.isDirectory()) {
                Utils.delete((File)appStorage, (boolean)true);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NetBeansProfiler.getDefaultNB().displayError(NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_Cannot_resolve_host", (Object)hostName));
                }
            });
            return;
        }
        storage.setCustomProperty(PROPERTY_HOSTNAME, host.getHostName());
        final JmxApplication application = new JmxApplication(host, serviceURL, username, password, saveCredentials, storage);
        Set jmxapps = host.getRepository().getDataSources(JmxApplication.class);
        if (jmxapps.contains((Object)application)) {
            File appStorage = storage.getDirectory();
            if (appStorage.isDirectory()) {
                Utils.delete((File)appStorage, (boolean)true);
            }
            JmxApplication tempapp = null;
            for (JmxApplication jmxapp : jmxapps) {
                if (!jmxapp.equals((Object)application)) continue;
                tempapp = jmxapp;
                break;
            }
            final JmxApplication app = tempapp;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ExplorerSupport.sharedInstance().selectDataSource((DataSource)application);
                    NetBeansProfiler.getDefaultNB().displayWarning(NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_JMX_connection") + application.getId() + NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_already_exists") + DataSourceDescriptorFactory.getDescriptor((DataSource)app).getName());
                }
            });
            return;
        }
        JmxModel model = JmxModelFactory.getJmxModelFor((Application)application);
        if (model == null || model.getConnectionState() != JmxModel.ConnectionState.CONNECTED) {
            application.setStateImpl(0);
            File appStorage = storage.getDirectory();
            if (appStorage.isDirectory()) {
                Utils.delete((File)appStorage, (boolean)true);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NetBeansProfiler.getDefaultNB().displayError(NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_Cannot_connect_using") + connectionName);
                }
            });
            return;
        }
        model.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == JmxModel.ConnectionState.CONNECTED) {
                    application.setStateImpl(1);
                } else {
                    application.setStateImpl(0);
                }
            }
        });
        application.jvm = JvmFactory.getJVMFor((Application)application);
        host.getRepository().addDataSource((DataSource)application);
    }

    private String normalizeConnectionName(String connectionName) {
        if (connectionName.startsWith("service:jmx:")) {
            return connectionName;
        }
        return "service:jmx:rmi:///jndi/rmi://" + connectionName + "/jmxrmi";
    }

    private String getHostName(JMXServiceURL serviceURL) {
        String hostname = serviceURL.getHost();
        if (hostname == null || hostname.isEmpty()) {
            hostname = null;
            if ("rmi".equals(serviceURL.getProtocol()) && serviceURL.getURLPath().startsWith("/jndi/rmi://")) {
                String urlPath = serviceURL.getURLPath().substring("/jndi/rmi://".length());
                if ('/' == urlPath.charAt(0)) {
                    hostname = "localhost";
                } else if ('[' == urlPath.charAt(0)) {
                    int closingSquareBracketIndex = urlPath.indexOf("]");
                    hostname = closingSquareBracketIndex == -1 ? null : urlPath.substring(0, closingSquareBracketIndex + 1);
                } else {
                    int slashIndex;
                    int colonIndex = urlPath.indexOf(":");
                    int min = Math.min(colonIndex, slashIndex = urlPath.indexOf("/"));
                    if (min == -1) {
                        min = 0;
                    }
                    if ((hostname = urlPath.substring(0, min)).isEmpty()) {
                        hostname = "localhost";
                    }
                }
            }
        }
        return hostname;
    }

    private JMXServiceURL getServiceURL(String connectionString) {
        try {
            return new JMXServiceURL(connectionString);
        }
        catch (MalformedURLException e) {
            LOGGER.throwing(JMXServiceURL.class.getName(), "getServiceURL", e);
            return null;
        }
    }

    private void initPersistedApplications() {
        File[] files;
        if (!JmxApplicationsSupport.storageDirectoryExists()) {
            return;
        }
        for (File file : files = JmxApplicationsSupport.getStorageDirectory().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(JmxApplicationProvider.JMX_SUFFIX);
            }
        })) {
            if (!file.isDirectory()) continue;
            Storage storage = new Storage(file, PROPERTIES_FILE);
            Set<Storage> storageSet = this.persistedApplications.get(storage.getCustomProperty(PROPERTY_HOSTNAME));
            if (storageSet == null) {
                storageSet = new HashSet<Storage>();
                this.persistedApplications.put(storage.getCustomProperty(PROPERTY_HOSTNAME), storageSet);
            }
            storageSet.add(storage);
        }
        DataChangeListener<Host> dataChangeListener = new DataChangeListener<Host>(){

            public synchronized void dataChanged(DataChangeEvent<Host> event) {
                Set hosts = event.getAdded();
                for (Host host : hosts) {
                    String hostName = host.getHostName();
                    Set storageSet = (Set)JmxApplicationProvider.this.persistedApplications.get(hostName);
                    if (storageSet == null) continue;
                    JmxApplicationProvider.this.persistedApplications.remove(hostName);
                    String[] keys = new String[]{JmxApplicationProvider.PROPERTY_CONNECTION_STRING, JmxApplicationProvider.PROPERTY_HOSTNAME, JmxApplicationProvider.PROPERTY_USERNAME, JmxApplicationProvider.PROPERTY_PASSWORD};
                    for (final Storage storage : storageSet) {
                        final String[] values = storage.getCustomProperties(keys);
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                JmxApplicationProvider.this.addJmxApplication(null, values[0], values[1], values[2], Utils.decodePassword((String)values[3]), false, storage);
                            }
                        });
                    }
                }
                if (JmxApplicationProvider.this.trackingNewHosts && JmxApplicationProvider.this.persistedApplications.isEmpty()) {
                    JmxApplicationProvider.this.trackingNewHosts = false;
                    DataSourceRepository.sharedInstance().removeDataChangeListener((DataChangeListener)this);
                }
            }
        };
        if (!this.persistedApplications.isEmpty()) {
            this.trackingNewHosts = true;
            DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)dataChangeListener, Host.class);
        }
    }

    public static void initialize() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        JmxApplicationProvider.sharedInstance().initPersistedApplications();
                    }
                });
            }
        });
    }
}

