/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jmx.application;

import com.sun.tools.visualvm.core.ui.actions.SingleDataSourceAction;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.jmx.application.JmxApplicationConfigurator;
import com.sun.tools.visualvm.jmx.application.JmxApplicationProvider;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.ImageIcon;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AddJMXConnectionAction
extends SingleDataSourceAction<Host> {
    private static final String ICON_PATH = "com/sun/tools/visualvm/jmx/application/resources/addJmxApplication.png";
    private static final Image ICON = Utilities.loadImage((String)"com/sun/tools/visualvm/jmx/application/resources/addJmxApplication.png");
    private boolean tracksSelection = false;
    private static AddJMXConnectionAction alwaysEnabled;
    private static AddJMXConnectionAction selectionAware;

    public static synchronized AddJMXConnectionAction alwaysEnabled() {
        if (alwaysEnabled == null) {
            alwaysEnabled = new AddJMXConnectionAction();
            alwaysEnabled.putValue("SmallIcon", new ImageIcon(ICON));
            alwaysEnabled.putValue("iconBase", ICON_PATH);
        }
        return alwaysEnabled;
    }

    public static synchronized AddJMXConnectionAction selectionAware() {
        if (selectionAware == null) {
            selectionAware = new AddJMXConnectionAction();
            AddJMXConnectionAction.selectionAware.tracksSelection = true;
        }
        return selectionAware;
    }

    protected void actionPerformed(Host host, ActionEvent actionEvent) {
        final JmxApplicationConfigurator appConfig = JmxApplicationConfigurator.addJmxConnection();
        if (appConfig != null) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    JmxApplicationProvider.sharedInstance().createJmxApplication(appConfig.getConnection(), appConfig.getDisplayName(), appConfig.getUsername(), appConfig.getPassword(), appConfig.getSaveCredentialsFlag());
                }
            });
        }
    }

    protected boolean isEnabled(Host host) {
        return host != Host.UNKNOWN_HOST;
    }

    protected void updateState(Set<Host> selectedHosts) {
        if (this.tracksSelection) {
            super.updateState(selectedHosts);
        }
    }

    private AddJMXConnectionAction() {
        super(Host.class);
        this.putValue("Name", NbBundle.getMessage(AddJMXConnectionAction.class, (String)"MSG_Add_JMX_Connection"));
        this.putValue("ShortDescription", NbBundle.getMessage(AddJMXConnectionAction.class, (String)"ToolTip_Add_JMX_Connection"));
    }
}

