/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.wizards.panels.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DirectorySelector
extends JPanel {
    public static final String PATH_PROPERTY = "path";
    private DocumentListener pathListener = new DocumentListener(){
        private String oldValue = "";

        public void changedUpdate(DocumentEvent e) {
            this.firePathChange(DirectorySelector.this.textPath.getText());
        }

        public void insertUpdate(DocumentEvent e) {
            this.firePathChange(DirectorySelector.this.textPath.getText());
        }

        public void removeUpdate(DocumentEvent e) {
            this.firePathChange(DirectorySelector.this.textPath.getText());
        }

        private void firePathChange(String newValue) {
            DirectorySelector.this.firePropertyChange(DirectorySelector.PATH_PROPERTY, this.oldValue, newValue);
            this.oldValue = newValue;
        }
    };
    private String label = NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.caption.text");
    private String initPath = "";
    private JButton buttonBrowse;
    private JScrollPane hintScroller;
    private JPanel jPanel1;
    private JTextArea labelHint;
    private JTextField textPath;

    public DirectorySelector() {
        this.initComponents();
    }

    private void initComponents() {
        this.hintScroller = new JScrollPane();
        this.labelHint = new JTextArea();
        this.jPanel1 = new JPanel();
        this.textPath = new JTextField();
        this.buttonBrowse = new JButton();
        this.setLayout(new BorderLayout());
        this.hintScroller.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.hintScroller.setVerticalScrollBarPolicy(21);
        this.labelHint.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.labelHint.setColumns(20);
        this.labelHint.setEditable(false);
        this.labelHint.setForeground(new Color(204, 204, 0));
        this.labelHint.setLineWrap(true);
        this.labelHint.setRows(5);
        this.labelHint.setText(NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.labelHint.text"));
        this.labelHint.setWrapStyleWord(true);
        this.labelHint.setEnabled(false);
        this.labelHint.setFocusable(false);
        this.labelHint.setRequestFocusEnabled(false);
        this.labelHint.setVerifyInputWhenFocusTarget(false);
        this.hintScroller.setViewportView(this.labelHint);
        this.labelHint.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.labelHint.AccessibleContext.accessibleName"));
        this.add((Component)this.hintScroller, "Center");
        this.textPath.setText(NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.textPath.text"));
        this.textPath.getDocument().addDocumentListener(this.pathListener);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonBrowse, (String)NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.buttonBrowse.text"));
        this.buttonBrowse.setMaximumSize(new Dimension(43, 23));
        this.buttonBrowse.setMinimumSize(new Dimension(43, 23));
        this.buttonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirectorySelector.this.buttonBrowseActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.textPath, -1, 171, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.buttonBrowse, -2, 25, -2)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.buttonBrowse, -2, 18, -2).add((Component)this.textPath, -2, -1, -2)));
        this.textPath.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.textPath.AccessibleContext.accessibleName"));
        this.textPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.textPath.AccessibleContext.accessibleDescription"));
        this.buttonBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.buttonBrowse.AccessibleContext.accessibleDescription"));
        this.add((Component)this.jPanel1, "North");
    }

    private void buttonBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        String dirPath = this.getPath();
        if (dirPath == null || dirPath.length() == 0) {
            dirPath = this.initPath;
        }
        File cur = new File(dirPath);
        chooser.setCurrentDirectory(cur);
        chooser.setDialogType(0);
        chooser.setDialogTitle(this.label);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File dir = chooser.getSelectedFile();
            this.setPath(dir.getAbsolutePath());
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPath() {
        return this.textPath.getText();
    }

    public void setPath(String path) {
        this.textPath.setText(path);
    }

    public void setInitialDir(String path) {
        this.initPath = path;
    }

    public String getInitialDir() {
        return this.initPath;
    }

    public String getHint() {
        return this.labelHint.getText();
    }

    public void setHint(String hint) {
        this.labelHint.setText(hint);
    }

    public Color getHintForeground() {
        return this.labelHint.getDisabledTextColor();
    }

    public void setHintForeground(Color color) {
        this.labelHint.setDisabledTextColor(color);
    }

    public Color getHintBackground() {
        return this.labelHint.getBackground();
    }

    public void setHintBackground(Color bgcolor) {
        this.labelHint.setBackground(bgcolor);
    }
}

