/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsConfigurator;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.ui.wizards.AttachWizard;
import org.openide.DialogDescriptor;
import org.openide.WizardDescriptor;

public class Utils {
    public static Dimension DIMENSION_SMALLEST = new Dimension(0, 0);
    private static int defaultSpinnerHeight = -1;

    public static AttachSettings getAttachSettings() {
        AttachSettings attachSettings = null;
        try {
            attachSettings = NetBeansProfiler.loadAttachSettings();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return attachSettings;
    }

    public static boolean isCPUSettings(ProfilingSettings settings) {
        if (settings == null) {
            return false;
        }
        return Utils.isCPUSettings(settings.getProfilingType());
    }

    public static boolean isCPUSettings(int type) {
        return type == 8 || type == 16 || type == 32;
    }

    public static int getDefaultSpinnerHeight() {
        if (defaultSpinnerHeight == -1) {
            defaultSpinnerHeight = new JTextField().getPreferredSize().height;
        }
        return defaultSpinnerHeight;
    }

    public static boolean isMemorySettings(ProfilingSettings settings) {
        if (settings == null) {
            return false;
        }
        return Utils.isMemorySettings(settings.getProfilingType());
    }

    public static boolean isMemorySettings(int type) {
        return type == 2 || type == 4;
    }

    public static boolean isMonitorSettings(ProfilingSettings settings) {
        if (settings == null) {
            return false;
        }
        return Utils.isMonitorSettings(settings.getProfilingType());
    }

    public static boolean isMonitorSettings(int type) {
        return type == 1;
    }

    public static String getProjectName() {
        return SelectProfilingTask.EXTERNAL_APPLICATION_STRING;
    }

    public static SelectProfilingTask.SettingsConfigurator getSettingsConfigurator() {
        return DefaultSettingsConfigurator.SHARED_INSTANCE;
    }

    public static JPanel createFillerPanel() {
        JPanel fillerPanel = new JPanel(new FlowLayout(0, 0, 3)){

            public Dimension getPreferredSize() {
                return DIMENSION_SMALLEST;
            }
        };
        fillerPanel.setOpaque(false);
        return fillerPanel;
    }

    public static JSeparator createHorizontalSeparator() {
        JSeparator horizontalSeparator = new JSeparator(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        return horizontalSeparator;
    }

    public static AttachSettings selectAttachSettings() {
        AttachSettings attachSettings = Utils.getAttachSettings();
        if (attachSettings == null) {
            attachSettings = new AttachSettings();
        }
        AttachWizard attachWizard = new AttachWizard();
        attachWizard.init(attachSettings);
        WizardDescriptor wd = attachWizard.getWizardDescriptor();
        Dialog d = ProfilerDialogs.createDialog((DialogDescriptor)wd);
        d.pack();
        d.setVisible(true);
        if (wd.getValue() != WizardDescriptor.FINISH_OPTION) {
            return null;
        }
        attachWizard.finish();
        return attachWizard.getAttachSettings();
    }
}

