/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.jps.JpsProxy;
import org.netbeans.lib.profiler.jps.RunningVM;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public final class PIDSelectPanel
extends JPanel
implements ActionListener {
    private static final String REFRESH_BUTTON_NAME = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_RefreshButtonName");
    private static final String PID_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_PidLabelText");
    private static final String MAIN_CLASS_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_MainClassLabelText");
    private static final String ARGUMENTS_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ArgumentsLabelText");
    private static final String VM_ARGUMENTS_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_VmArgumentsLabelText");
    private static final String VM_FLAGS_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_VmFlagsLabelText");
    private static final String VM_COMBO_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_VmComboItemText");
    private static final String PROCESSES_LIST_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ProcessesListItemText");
    private static final String ERROR_GETTING_PROCESSES_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ErrorGettingProcessesItemText");
    private static final String NO_PROCESSES_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_NoProcessesItemText");
    private static final String SELECT_PROCESS_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_SelectProcessItemText");
    private static final String OK_BUTTON_NAME = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_OkButtonName");
    private static final String SELECT_PROCESS_DIALOG_CAPTION = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_SelectProcessDialogCaption");
    private static final String COMBO_ACCESS_NAME = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ComboAccessName");
    private static final String COMBO_ACCESS_DESCR = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ComboAccessDescr");
    private static final String BUTTON_ACCESS_DESCR = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ButtonAccessDescr");
    private static final int MAX_WIDTH = 500;
    private JButton button;
    private JButton okButton;
    private JComboBox combo;
    private JLabel argumentsLabel;
    private JLabel mainClassLabel;
    private JLabel pidLabel;
    private JLabel vmArgumentsLabel;
    private JLabel vmFlagsLabel;

    public PIDSelectPanel(JButton okButton) {
        this.okButton = okButton;
        this.combo = new JComboBox();
        this.button = new JButton(REFRESH_BUTTON_NAME);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new GridBagLayout());
        GridBagConstraints labelGbc = new GridBagConstraints();
        labelGbc.insets = new Insets(3, 5, 0, 0);
        labelGbc.anchor = 17;
        GridBagConstraints valueGbc = new GridBagConstraints();
        valueGbc.weightx = 1.0;
        valueGbc.fill = 2;
        valueGbc.insets = new Insets(3, 5, 0, 5);
        valueGbc.gridwidth = 0;
        valueGbc.anchor = 17;
        JLabel l = new JLabel(PID_LABEL_TEXT);
        l.setFont(l.getFont().deriveFont(1));
        infoPanel.add((Component)l, labelGbc);
        this.pidLabel = new JLabel();
        infoPanel.add((Component)this.pidLabel, valueGbc);
        l = new JLabel(MAIN_CLASS_LABEL_TEXT);
        l.setFont(l.getFont().deriveFont(1));
        infoPanel.add((Component)l, labelGbc);
        this.mainClassLabel = new JLabel();
        infoPanel.add((Component)this.mainClassLabel, valueGbc);
        l = new JLabel(ARGUMENTS_LABEL_TEXT);
        l.setFont(l.getFont().deriveFont(1));
        infoPanel.add((Component)l, labelGbc);
        this.argumentsLabel = new JLabel();
        infoPanel.add((Component)this.argumentsLabel, valueGbc);
        l = new JLabel(VM_ARGUMENTS_LABEL_TEXT);
        l.setFont(l.getFont().deriveFont(1));
        infoPanel.add((Component)l, labelGbc);
        this.vmArgumentsLabel = new JLabel();
        infoPanel.add((Component)this.vmArgumentsLabel, valueGbc);
        l = new JLabel(VM_FLAGS_LABEL_TEXT);
        l.setFont(l.getFont().deriveFont(1));
        infoPanel.add((Component)l, labelGbc);
        this.vmFlagsLabel = new JLabel();
        infoPanel.add((Component)this.vmFlagsLabel, valueGbc);
        this.combo.setRenderer(new PIDComboRenderer());
        this.combo.getAccessibleContext().setAccessibleName(COMBO_ACCESS_NAME);
        this.combo.getAccessibleContext().setAccessibleDescription(COMBO_ACCESS_DESCR);
        this.button.getAccessibleContext().setAccessibleDescription(BUTTON_ACCESS_DESCR);
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new BorderLayout(0, 10));
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout(5, 0));
        northPanel.add((Component)this.combo, "Center");
        northPanel.add((Component)this.button, "East");
        this.add((Component)northPanel, "North");
        this.add((Component)infoPanel, "Center");
        okButton.setEnabled(false);
        this.refreshCombo();
        this.button.addActionListener(this);
        this.combo.addActionListener(this);
    }

    public int getPID() {
        Object sel = this.combo.getSelectedItem();
        if (sel != null && sel instanceof RunningVM) {
            return ((RunningVM)sel).getPid();
        }
        return -1;
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(Math.max(d.width, 500), d.height);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button) {
            this.refreshCombo();
        } else if (e.getSource() == this.combo) {
            this.okButton.setEnabled(this.combo.getSelectedItem() instanceof RunningVM);
            this.updateInfo();
        }
    }

    public static int selectPID() {
        JButton okButton = new JButton(OK_BUTTON_NAME);
        PIDSelectPanel pidSelect = new PIDSelectPanel(okButton);
        DialogDescriptor dd = new DialogDescriptor((Object)pidSelect, SELECT_PROCESS_DIALOG_CAPTION, true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog d = ProfilerDialogs.createDialog(dd);
        d.setVisible(true);
        if (dd.getValue() == okButton) {
            return pidSelect.getPID();
        }
        return -1;
    }

    private void refreshCombo() {
        this.okButton.setEnabled(false);
        this.combo.setEnabled(false);
        this.combo.setModel(new DefaultComboBoxModel<Object>(new Object[]{PROCESSES_LIST_ITEM_TEXT}));
        new NBSwingWorker(){
            private RunningVM[] vms = JpsProxy.getRunningVMs();
            private Object[] ar = new Object[(this.vms == null ? 0 : this.vms.length) + 1];

            protected void doInBackground() {
                if (this.vms == null) {
                    this.ar[0] = ERROR_GETTING_PROCESSES_ITEM_TEXT;
                } else if (this.vms.length == 0) {
                    this.ar[0] = NO_PROCESSES_ITEM_TEXT;
                } else {
                    this.ar[0] = SELECT_PROCESS_ITEM_TEXT;
                    System.arraycopy(this.vms, 0, this.ar, 1, this.vms.length);
                }
            }

            protected void done() {
                PIDSelectPanel.this.combo.setEnabled(true);
                PIDSelectPanel.this.combo.setModel(new DefaultComboBoxModel<Object>(this.ar));
                PIDSelectPanel.this.updateInfo();
            }
        }.execute();
    }

    private void updateInfo() {
        Object sel = this.combo.getSelectedItem();
        if (sel != null && sel instanceof RunningVM) {
            RunningVM vm = (RunningVM)sel;
            this.pidLabel.setText("" + vm.getPid());
            this.mainClassLabel.setText(vm.getMainClass());
            this.argumentsLabel.setText(vm.getMainArgs());
            this.vmArgumentsLabel.setText(vm.getVMArgs());
            this.vmFlagsLabel.setText(vm.getVMFlags());
        } else {
            this.pidLabel.setText("");
            this.mainClassLabel.setText("");
            this.argumentsLabel.setText("");
            this.vmArgumentsLabel.setText("");
            this.vmFlagsLabel.setText("");
        }
    }

    private static class PIDComboRenderer
    extends DefaultListCellRenderer {
        private PIDComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof RunningVM) {
                RunningVM vm = (RunningVM)value;
                String args = vm.getMainArgs();
                args = args == null ? "" : " " + args;
                String text = MessageFormat.format(VM_COMBO_ITEM_TEXT, vm.getMainClass(), "" + vm.getPid());
                return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

