/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class ManualMethodSelect
extends JPanel {
    private static final String SELECT_METHODS_DIALOG_CAPTION = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_SelectMethodsDialogCaption");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_OKButtonText");
    private static final String CLASS_NAME_LABEL_TEXT = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_ClassNameLabelText");
    private static final String METHOD_NAME_LABEL_TEXT = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_MethodNameLabelText");
    private static final String METHOD_SIGNATURE_LABEL_TEXT = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_MethodSignatureLabelText");
    private static final String HINT_MSG = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_HintMsg");
    private static final String CLASS_NAME_ACCESS_NAME = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_ClassNameAccessName");
    private static final String METHOD_NAME_ACCESS_NAME = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_MethodNameAccessName");
    private static final String METHOD_SIGNATURE_ACCESS_NAME = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_MethodSignatureAccessName");
    private static ManualMethodSelect mms;
    private static JButton okButton;
    private HTMLTextArea hintArea;
    private JTextField className;
    private JTextField methodName;
    private JTextField methodSignature;
    private MethodSelectDocumentListener documentListener = new MethodSelectDocumentListener();

    private ManualMethodSelect() {
        JLabel classNameLabel = new JLabel();
        this.className = new JTextField();
        JLabel methodNameLabel = new JLabel();
        this.methodName = new JTextField();
        JLabel methodSignatureLabel = new JLabel();
        this.methodSignature = new JTextField();
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.setLayout(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 0, 0, 0);
        labelConstraints.anchor = 17;
        fieldConstraints.insets = new Insets(5, 5, 0, 0);
        fieldConstraints.weightx = 1.0;
        fieldConstraints.fill = 2;
        classNameLabel.setLabelFor(this.className);
        Mnemonics.setLocalizedText((JLabel)classNameLabel, (String)CLASS_NAME_LABEL_TEXT);
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        this.add((Component)classNameLabel, labelConstraints);
        this.className.getAccessibleContext().setAccessibleName(CLASS_NAME_ACCESS_NAME);
        this.className.setPreferredSize(new Dimension(290, this.className.getPreferredSize().height));
        fieldConstraints.gridx = 1;
        fieldConstraints.gridy = 0;
        this.add((Component)this.className, fieldConstraints);
        methodNameLabel.setLabelFor(this.methodName);
        Mnemonics.setLocalizedText((JLabel)methodNameLabel, (String)METHOD_NAME_LABEL_TEXT);
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 1;
        this.add((Component)methodNameLabel, labelConstraints);
        this.methodName.getAccessibleContext().setAccessibleName(METHOD_NAME_ACCESS_NAME);
        fieldConstraints.gridx = 1;
        fieldConstraints.gridy = 1;
        this.add((Component)this.methodName, fieldConstraints);
        methodSignatureLabel.setLabelFor(this.methodSignature);
        Mnemonics.setLocalizedText((JLabel)methodSignatureLabel, (String)METHOD_SIGNATURE_LABEL_TEXT);
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 2;
        this.add((Component)methodSignatureLabel, labelConstraints);
        this.methodSignature.getAccessibleContext().setAccessibleName(METHOD_SIGNATURE_ACCESS_NAME);
        fieldConstraints.gridx = 1;
        fieldConstraints.gridy = 2;
        this.add((Component)this.methodSignature, fieldConstraints);
        Color panelBackground = UIManager.getColor("Panel.background");
        Color hintBackground = UIUtils.getSafeColor((int)(panelBackground.getRed() - 10), (int)(panelBackground.getGreen() - 10), (int)(panelBackground.getBlue() - 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        this.add((Component)new JPanel(), constraints);
        this.hintArea.setText(HINT_MSG);
        this.hintArea.setEnabled(false);
        this.hintArea.setDisabledTextColor(Color.darkGray);
        this.hintArea.setBackground(hintBackground);
        this.hintArea.setBorder((Border)BorderFactory.createMatteBorder(10, 10, 10, 10, hintBackground));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(18, 0, 0, 0);
        constraints.anchor = 18;
        constraints.fill = 1;
        this.add((Component)this.hintArea, constraints);
        this.setBorder(new EmptyBorder(12, 12, 0, 12));
        this.className.getDocument().addDocumentListener(this.documentListener);
        this.methodName.getDocument().addDocumentListener(this.documentListener);
        this.methodSignature.getDocument().addDocumentListener(this.documentListener);
        this.updateEnabledState();
    }

    public static ClientUtils.SourceCodeSelection selectMethod() {
        if (mms == null) {
            mms = new ManualMethodSelect();
        }
        DialogDescriptor dd = new DialogDescriptor((Object)mms, SELECT_METHODS_DIALOG_CAPTION, true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog d = ProfilerDialogs.createDialog(dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == okButton) {
            return mms.getSelectedMethod();
        }
        return null;
    }

    private String getClassName() {
        return this.className.getText().trim();
    }

    private String getMethodName() {
        String ret = this.methodName.getText().trim();
        if ("".equals(ret)) {
            return null;
        }
        return ret;
    }

    private String getMethodSignature() {
        String ret = this.methodSignature.getText().trim();
        if ("".equals(ret)) {
            return null;
        }
        return ret;
    }

    private ClientUtils.SourceCodeSelection getSelectedMethod() {
        return new ClientUtils.SourceCodeSelection(this.getClassName(), this.getMethodName(), this.getMethodSignature());
    }

    private void updateEnabledState() {
        boolean enabled = true;
        if ("".equals(this.className.getText().trim())) {
            enabled = false;
        } else if ("".equals(this.methodName.getText().trim())) {
            enabled = false;
        } else if ("".equals(this.methodSignature.getText().trim())) {
            enabled = false;
        } else {
            try {
                this.methodSignature.setForeground(UIManager.getColor("Label.foreground"));
            }
            catch (Exception e) {
                this.methodSignature.setForeground(Color.red);
                enabled = false;
            }
        }
        okButton.setEnabled(enabled);
    }

    static {
        okButton = new JButton(OK_BUTTON_TEXT);
    }

    private final class MethodSelectDocumentListener
    implements DocumentListener {
        private MethodSelectDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            ManualMethodSelect.this.updateEnabledState();
        }

        public void insertUpdate(DocumentEvent e) {
            ManualMethodSelect.this.updateEnabledState();
        }

        public void removeUpdate(DocumentEvent e) {
            ManualMethodSelect.this.updateEnabledState();
        }
    }
}

