/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ImagePreviewPanel
extends JPanel {
    private static final String NOT_AVAILABLE_MSG = NbBundle.getMessage(ImagePreviewPanel.class, (String)"ImagePreviewPanel_NotAvailableMsg");
    private static final String GENERATING_PREVIEW_MSG = NbBundle.getMessage(ImagePreviewPanel.class, (String)"ImagePreviewPanel_GeneratingPreviewMsg");
    private static final String NO_IMAGE_MSG = NbBundle.getMessage(ImagePreviewPanel.class, (String)"ImagePreviewPanel_NoImageMsg");
    private static final int PREVIEW_THRESHOLD = 2000000;
    private static int instanceCounter = 0;
    private static final Dimension ZERO_SIZE = new Dimension();
    private RequestProcessor.Task currentTask;
    private JLabel displayer;
    private RequestProcessor processor = new RequestProcessor("ImagePreviewPanel-Processor-" + instanceCounter++, 1, true);

    public ImagePreviewPanel() {
        this.initComponents();
    }

    public void setImage(final ImageProvider imageProvider) {
        this.clearImage();
        this.currentTask = this.processor.post(new Runnable(){

            public void run() {
                try {
                    ImageIcon scaledPreview;
                    if (Thread.interrupted()) {
                        ImagePreviewPanel.this.displayer.setIcon(null);
                        ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                        return;
                    }
                    BufferedImage image = imageProvider.getImage();
                    if (Thread.interrupted()) {
                        image = null;
                    }
                    if (image == null) {
                        ImagePreviewPanel.this.displayer.setIcon(null);
                        ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                        return;
                    }
                    Dimension fitSize = ImagePreviewPanel.this.getImageFitSize(image.getWidth(), image.getHeight());
                    int width = fitSize.width;
                    int height = fitSize.height;
                    if (Thread.interrupted()) {
                        image = null;
                        ImagePreviewPanel.this.displayer.setIcon(null);
                        ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                        return;
                    }
                    if (image.getWidth() * image.getHeight() > 2000000) {
                        scaledPreview = new ImageIcon(image.getScaledInstance(Math.max(1, width), Math.max(1, height), 2));
                        if (Thread.interrupted()) {
                            image = null;
                            ImagePreviewPanel.this.displayer.setIcon(null);
                            ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                            return;
                        }
                        ImagePreviewPanel.this.displayer.setText(null);
                        ImagePreviewPanel.this.repaint();
                        ImagePreviewPanel.this.displayer.setIcon(scaledPreview);
                    }
                    if (Thread.interrupted()) {
                        image = null;
                        ImagePreviewPanel.this.displayer.setIcon(null);
                        ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                        return;
                    }
                    scaledPreview = new ImageIcon(image.getScaledInstance(Math.max(1, width), Math.max(1, height), 4));
                    image = null;
                    if (Thread.interrupted()) {
                        ImagePreviewPanel.this.displayer.setIcon(null);
                        ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                        return;
                    }
                    ImagePreviewPanel.this.displayer.setText(null);
                    ImagePreviewPanel.this.repaint();
                    ImagePreviewPanel.this.displayer.setIcon(scaledPreview);
                }
                catch (OutOfMemoryError e) {
                    ImagePreviewPanel.this.displayer.setIcon(null);
                    ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                }
            }
        });
    }

    public void clearImage() {
        this.displayer.setIcon(null);
        this.displayer.setText(GENERATING_PREVIEW_MSG);
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
    }

    public void reset() {
        this.displayer.setIcon(null);
        this.displayer.setText(NO_IMAGE_MSG);
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
    }

    private Dimension getClientSize() {
        Insets insets = this.displayer.getInsets();
        Dimension size = this.displayer.getSize().equals(ZERO_SIZE) ? this.displayer.getPreferredSize() : this.displayer.getSize();
        return new Dimension(size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
    }

    private Dimension getImageFitSize(int imageWidth, int imageHeight) {
        Dimension displayerSize = this.getClientSize();
        float imageRatio = (float)imageWidth / (float)imageHeight;
        int displayerWidth = displayerSize.width;
        int displayerHeight = displayerSize.height;
        float displayerRatio = (float)displayerWidth / (float)displayerHeight;
        if (imageRatio > displayerRatio) {
            int newWidth = displayerWidth;
            int newHeight = (int)((float)newWidth / imageRatio);
            return new Dimension(newWidth, newHeight);
        }
        if (imageRatio < displayerRatio) {
            int newHeight = displayerHeight;
            int newWidth = (int)((float)newHeight * imageRatio);
            return new Dimension(newWidth, newHeight);
        }
        return displayerSize;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.displayer = new JLabel();
        this.displayer.setHorizontalAlignment(0);
        this.displayer.setBackground(UIUtils.getProfilerResultsBackground());
        this.displayer.setOpaque(true);
        this.displayer.setPreferredSize(new Dimension(200, 200));
        this.displayer.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.add((Component)this.displayer, "Center");
    }

    public static interface ImageProvider {
        public BufferedImage getImage();
    }
}

