/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.modules.profiler.heapwalk.ClassPresenterPanel;
import org.netbeans.modules.profiler.heapwalk.InstancesController;
import org.netbeans.modules.profiler.heapwalk.LegendPanel;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class InstancesControllerUI
extends JPanel {
    private static final String NO_CLASS_DEFINED_MSG = NbBundle.getMessage(InstancesControllerUI.class, (String)"InstancesControllerUI_NoClassDefinedMsg");
    private static final String VIEW_CAPTION = NbBundle.getMessage(InstancesControllerUI.class, (String)"InstancesControllerUI_ViewCaption");
    private static final String VIEW_DESCR = NbBundle.getMessage(InstancesControllerUI.class, (String)"InstancesControllerUI_ViewDescr");
    private static final String DATA = "Data";
    private static final String NO_DATA = "No data";
    private AbstractButton presenter;
    private CardLayout contents;
    private InstancesController instancesController;
    private JPanel dataPanel;
    private JPanel noDataPanel;
    private JSplitPane browsersSplit;
    private JSplitPane contentsSplit;
    private LegendPanel legendPanel;

    public InstancesControllerUI(InstancesController instancesController) {
        this.instancesController = instancesController;
        this.initComponents();
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter();
        }
        return this.presenter;
    }

    public void update() {
        if (this.contents != null) {
            if (this.instancesController.getSelectedClass() == null) {
                this.contents.show(this, NO_DATA);
            } else {
                this.contents.show(this, DATA);
            }
        }
    }

    private void initComponents() {
        JPanel fieldsBrowserPanel = this.instancesController.getFieldsBrowserController().getPanel();
        JPanel referencesBrowserPanel = this.instancesController.getReferencesBrowserController().getPanel();
        JPanel instancesListPanel = this.instancesController.getInstancesListController().getPanel();
        this.browsersSplit = new JExtendedSplitPane(0, (Component)fieldsBrowserPanel, (Component)referencesBrowserPanel);
        this.tweakSplitPaneUI(this.browsersSplit);
        this.browsersSplit.setResizeWeight(0.5);
        this.contentsSplit = new JExtendedSplitPane(1, (Component)instancesListPanel, (Component)this.browsersSplit);
        this.tweakSplitPaneUI(this.contentsSplit);
        this.contentsSplit.setDividerLocation(instancesListPanel.getPreferredSize().width);
        ClassPresenterPanel classPresenterPanel = this.instancesController.getClassPresenterPanel();
        classPresenterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, this.getBackground()), classPresenterPanel.getBorder()));
        this.legendPanel = new LegendPanel(true);
        this.dataPanel = new JPanel(new BorderLayout());
        this.dataPanel.add((Component)classPresenterPanel, "North");
        this.dataPanel.add((Component)this.contentsSplit, "Center");
        this.dataPanel.add((Component)this.legendPanel, "South");
        this.noDataPanel = new JPanel(new BorderLayout());
        this.noDataPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        HTMLTextArea hintArea = new HTMLTextArea(){

            protected void showURL(URL url) {
                InstancesControllerUI.this.instancesController.getHeapFragmentWalker().switchToClassesView();
            }
        };
        hintArea.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 8));
        String hintText = MessageFormat.format(NO_CLASS_DEFINED_MSG, "<a href='#'><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/class.png'></a>");
        hintArea.setText(hintText);
        this.noDataPanel.add((Component)hintArea, "Center");
        this.contents = new CardLayout();
        this.setLayout(this.contents);
        this.add((Component)this.noDataPanel, NO_DATA);
        this.add((Component)this.dataPanel, DATA);
        LegendUpdater legendUpdater = new LegendUpdater();
        fieldsBrowserPanel.addHierarchyListener(legendUpdater);
        referencesBrowserPanel.addHierarchyListener(legendUpdater);
    }

    private void tweakSplitPaneUI(JSplitPane splitPane) {
        splitPane.setBorder(null);
        splitPane.setDividerSize(3);
        if (!(splitPane.getUI() instanceof BasicSplitPaneUI)) {
            return;
        }
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)splitPane.getUI()).getDivider();
        if (divider != null) {
            divider.setBorder(null);
        }
    }

    private class LegendUpdater
    implements HierarchyListener {
        private LegendUpdater() {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            JPanel fieldsBrowserPanel = InstancesControllerUI.this.instancesController.getFieldsBrowserController().getPanel();
            JPanel referencesBrowserPanel = InstancesControllerUI.this.instancesController.getReferencesBrowserController().getPanel();
            if ((e.getChangeFlags() & 4L) != 0L) {
                InstancesControllerUI.this.legendPanel.setGCRootVisible(referencesBrowserPanel.isShowing());
                InstancesControllerUI.this.legendPanel.setVisible(fieldsBrowserPanel.isShowing() || referencesBrowserPanel.isShowing());
            }
        }
    }

    private static class Presenter
    extends JToggleButton {
        private static ImageIcon ICON_INSTANCE = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/instance.png"));

        public Presenter() {
            this.setText(VIEW_CAPTION);
            this.setToolTipText(VIEW_DESCR);
            this.setIcon(ICON_INSTANCE);
            this.setMargin(new Insets(this.getMargin().top, this.getMargin().top, this.getMargin().bottom, this.getMargin().top));
        }
    }
}

