/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.memorylint.FieldAccess;
import org.netbeans.modules.profiler.heapwalk.memorylint.IteratingRule;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class CollapsedHashMap
extends IteratingRule {
    private FieldAccess fldHMSize;
    private FieldAccess fldHMTable;
    private FieldAccess fldWHMSize;
    private FieldAccess fldWHMTable;
    private JavaClass clsHM;
    private JavaClass clsWHM;
    private Set<HMRecord> poorHM = new HashSet<HMRecord>();
    private float ratio = 1.5f;

    public CollapsedHashMap() {
        super(NbBundle.getMessage(CollapsedHashMap.class, (String)"LBL_CHM_Name"), NbBundle.getMessage(CollapsedHashMap.class, (String)"LBL_CHM_Desc"), "java.util.HashMap|java.util.WeakHashMap");
    }

    public String getHTMLDescription() {
        return NbBundle.getMessage(CollapsedHashMap.class, (String)"LBL_CHM_LongDesc");
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
    }

    protected void perform(Instance hm) {
        if (this.clsHM.equals(hm.getJavaClass())) {
            this.scanHashmap(hm, this.fldHMSize, this.fldHMTable);
        } else {
            this.scanHashmap(hm, this.fldWHMSize, this.fldWHMTable);
        }
    }

    protected void prepareRule(MemoryLint context) {
        Heap heap = context.getHeap();
        this.clsHM = heap.getJavaClassByName("java.util.HashMap");
        this.fldHMTable = new FieldAccess(this.clsHM, "table");
        this.fldHMSize = new FieldAccess(this.clsHM, "size");
        this.clsWHM = heap.getJavaClassByName("java.util.WeakHashMap");
        this.fldWHMTable = new FieldAccess(this.clsWHM, "table");
        this.fldWHMSize = new FieldAccess(this.clsWHM, "size");
    }

    protected void summary() {
        for (HMRecord hm : this.poorHM) {
            this.getContext().appendResults(hm.toString() + "<br>");
        }
    }

    private void scanHashmap(Instance hm, FieldAccess sizeAccess, FieldAccess tableAccess) {
        int size = sizeAccess.getIntValue(hm);
        if (size < 5) {
            return;
        }
        ObjectArrayInstance table = (ObjectArrayInstance)tableAccess.getRefValue(hm);
        if (table != null) {
            int slots = 0;
            List tval = table.getValues();
            for (Instance entry : tval) {
                if (entry == null) continue;
                ++slots;
            }
            if (slots > 0 && (float)(size / slots) > this.ratio) {
                this.poorHM.add(new HMRecord(hm, size, slots));
            }
        }
    }

    private class HMRecord {
        private Instance hm;
        private int size;
        private int slots;

        HMRecord(Instance hm, int size, int slots) {
            this.hm = hm;
            this.size = size;
            this.slots = slots;
        }

        public String toString() {
            boolean reallyBad = this.slots == 1;
            return NbBundle.getMessage(CollapsedHashMap.class, (String)"FMT_CHM_Record", (Object[])new Object[]{Utils.printClass(CollapsedHashMap.this.getContext(), CollapsedHashMap.this.getContext().getRootIncommingString(this.hm)), Utils.printInstance(this.hm), this.size, this.slots});
        }
    }
}

