/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapFactory;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.heapwalk.ClassesListController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.heapwalk.ui.HeapWalkerUI;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class HeapWalker {
    private static final String HEAPWALKER_DEFAULT_NAME = NbBundle.getMessage(ClassesListController.class, (String)"ClassesListController_HeapWalkerDefaultName");
    private static final String HEAPWALKER_CUSTOM_NAME = NbBundle.getMessage(ClassesListController.class, (String)"ClassesListController_HeapWalkerCustomName");
    private static final String LOADING_DUMP_MSG = NbBundle.getMessage(ClassesListController.class, (String)"ClassesListController_LoadingDumpMsg");
    private File heapDumpFile;
    private HeapFragmentWalker mainHeapWalker;
    private HeapWalkerUI heapWalkerUI;
    private String heapWalkerName = HEAPWALKER_DEFAULT_NAME;

    public HeapWalker(Heap heap) {
        this.createMainFragment(heap);
    }

    public HeapWalker(File heapFile) throws FileNotFoundException, IOException {
        this(HeapWalker.createHeap(heapFile));
        String fileNamePart;
        this.heapDumpFile = heapFile;
        String fileName = this.heapDumpFile.getName();
        int extensionIndex = fileName.lastIndexOf(".");
        if (extensionIndex == -1) {
            fileNamePart = fileName;
        } else {
            fileNamePart = fileName.substring(0, extensionIndex);
            if (fileNamePart.startsWith("heapdump-")) {
                String time = fileNamePart.substring("heapdump-".length(), fileNamePart.length());
                try {
                    long timeStamp = Long.parseLong(time);
                    fileNamePart = StringUtils.formatUserDate((Date)new Date(timeStamp));
                }
                catch (NumberFormatException e) {
                    fileNamePart = fileName;
                }
            } else {
                fileNamePart = fileName;
            }
        }
        this.heapWalkerName = MessageFormat.format(HEAPWALKER_CUSTOM_NAME, fileNamePart);
    }

    public File getHeapDumpFile() {
        return this.heapDumpFile;
    }

    public HeapFragmentWalker getMainHeapWalker() {
        return this.mainHeapWalker;
    }

    public String getName() {
        return this.heapWalkerName;
    }

    public void open() {
        HeapWalkerManager.getDefault().openHeapWalker(this);
    }

    public TopComponent getTopComponent() {
        if (this.heapWalkerUI == null) {
            this.heapWalkerUI = new HeapWalkerUI(this);
        }
        return this.heapWalkerUI;
    }

    void createMainFragment(Heap heap) {
        this.mainHeapWalker = new HeapFragmentWalker(heap, this);
    }

    void createReachableFragment(Instance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }

    void createRetainedFragment(Instance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Heap createHeap(File heapFile) throws FileNotFoundException, IOException {
        ProgressHandle pHandle = null;
        try {
            pHandle = ProgressHandleFactory.createHandle((String)LOADING_DUMP_MSG);
            pHandle.setInitialDelay(0);
            pHandle.start();
            Heap heap = HeapFactory.createHeap((File)heapFile);
            heap.getSummary();
            Heap heap2 = heap;
            return heap2;
        }
        finally {
            if (pHandle != null) {
                pHandle.finish();
            }
        }
    }
}

