/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class HeapDumpWatch {
    public static final String OOME_PROTECTION_ENABLED_KEY = "profiler.info.oomeprotection";
    public static final String OOME_PROTECTION_DUMPPATH_KEY = "profiler.info.oomeprotection.dumppath";
    private static HeapDumpWatch instance;
    private Collection<FileObject> watchedFolders = new ArrayList<FileObject>();
    private HeapDumpFolderListener listener = new HeapDumpFolderListener();
    private Thread refreshThread;

    private HeapDumpWatch() {
    }

    public static synchronized HeapDumpWatch getDefault() {
        if (instance == null) {
            instance = new HeapDumpWatch();
        }
        return instance;
    }

    public void monitor(String path) throws IllegalArgumentException {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("The path \"" + path + "\" can't be null.");
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(path)));
        if (fo != null) {
            if (!fo.isFolder()) {
                throw new IllegalArgumentException("The given path \"" + path + "\" is invalid. It must be a folder");
            }
            fo.getChildren();
            fo.addFileChangeListener((FileChangeListener)this.listener);
            this.watchedFolders.add(fo);
        }
    }

    public void releaseAll() {
        for (FileObject fo : this.watchedFolders) {
            fo.removeFileChangeListener((FileChangeListener)this.listener);
        }
        this.watchedFolders.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureHeapDump(FileObject heapDump) {
        if (!heapDump.getExt().equals("hprof")) {
            return;
        }
        if (heapDump.getName().startsWith("heapdump-")) {
            return;
        }
        ProfilerControlPanel2.getDefault().refreshSnapshotsList();
        try {
            NotifyDescriptor.Confirmation ndOpen = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(this.getClass(), (String)"OOME_PROTECTION_OPEN_HEAPDUMP"), 0, 3);
            NotifyDescriptor.Confirmation ndDelete = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(this.getClass(), (String)"OOME_PROTECTION_REMOVE_HEAPDUMP"), 0, 3);
            if (ProfilerDialogs.notify((NotifyDescriptor)ndOpen) == NotifyDescriptor.YES_OPTION) {
                HeapWalkerManager.getDefault().openHeapWalker(FileUtil.toFile((FileObject)heapDump));
            } else if (ProfilerDialogs.notify((NotifyDescriptor)ndDelete) == NotifyDescriptor.YES_OPTION) {
                heapDump.delete();
                ProfilerControlPanel2.getDefault().refreshSnapshotsList();
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            this.release(heapDump.getParent());
        }
    }

    private void release(FileObject watchedFolder) {
        watchedFolder.removeFileChangeListener((FileChangeListener)this.listener);
        this.watchedFolders.remove(watchedFolder);
    }

    private class HeapDumpFolderListener
    extends FileChangeAdapter {
        private HeapDumpFolderListener() {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            HeapDumpWatch.this.captureHeapDump(fileEvent.getFile());
        }
    }
}

