/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.ChartActionListener;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChart;
import org.netbeans.lib.profiler.ui.components.FlatToolBar;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.MemoryGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.SurvivingGenerationsGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.ThreadsGraphPanel;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public final class TelemetryWindow
extends TopComponent {
    private static final String THREADS_STATISTICS_TAB_NAME = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ThreadsStatisticsTabName");
    private static final String MEMORY_HEAP_TAB_NAME = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_MemoryHeapTabName");
    private static final String MEMORY_GC_TAB_NAME = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_MemoryGCTabName");
    private static final String ZOOM_IN_TOOLTIP = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ZoomInTooltip");
    private static final String ZOOM_OUT_TOOLTIP = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ZoomOutTooltip");
    private static final String FIXED_SCALE_TOOLTIP = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_FixedScaleTooltip");
    private static final String SCALE_TO_FIT_TOOLTIP = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ScaleToFitTooltip");
    private static final String THREADS_STATISTICS_TAB_DESCR = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ThreadsStatisticsTabDescr");
    private static final String MEMORY_HEAP_TAB_DESCR = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_MemoryHeapTabDescr");
    private static final String MEMORY_GC_TAB_DESCR = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_MemoryGCTabDescr");
    private static final String TELEMETRY_ACCESS_DESCR = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_TelemetryAccessDescr");
    private static final String HELP_CTX_KEY = "TelemetryWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("TelemetryWindow.HelpCtx");
    private static TelemetryWindow defaultInstance;
    private static final Image windowIcon;
    private final GraphTab generationsPanel;
    private final GraphTab heapPanel;
    private final GraphTab threadsStatsPanel;
    private final JTabbedPane tabs;
    private final MemoryGraphPanel heapGraph;
    private final SurvivingGenerationsGraphPanel generationsGraph;
    private final ThreadsGraphPanel threadsStatsGraph;
    private Component lastFocusOwner;

    public TelemetryWindow() {
        this.setName(NbBundle.getMessage(TelemetryWindow.class, (String)"LAB_TelemetryWindowName"));
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(TELEMETRY_ACCESS_DESCR);
        this.setLayout(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.setOpaque(true);
        this.tabs.setBackground(new HTMLTextArea().getBackground());
        this.tabs.setTabPlacement(3);
        this.add(this.tabs, "Center");
        this.heapGraph = new MemoryGraphPanel(true, Color.WHITE, ((NetBeansProfiler)Profiler.getDefault()).getMemoryXYChartModel(), null);
        this.generationsGraph = new SurvivingGenerationsGraphPanel(true, Color.WHITE, ((NetBeansProfiler)Profiler.getDefault()).getSurvivingGenerationsXYChartModel(), null);
        this.threadsStatsGraph = new ThreadsGraphPanel(true, Color.WHITE, ((NetBeansProfiler)Profiler.getDefault()).getThreadsXYChartModel(), null);
        this.heapGraph.setBorder((Border)BorderFactory.createMatteBorder(0, 0, 0, 20, Color.WHITE));
        this.generationsGraph.setBorder((Border)BorderFactory.createMatteBorder(0, 0, 0, 20, Color.WHITE));
        this.threadsStatsGraph.setBorder((Border)BorderFactory.createMatteBorder(0, 0, 0, 20, Color.WHITE));
        this.heapGraph.setOpaque(false);
        this.generationsGraph.setOpaque(false);
        this.threadsStatsGraph.setOpaque(false);
        this.heapPanel = new GraphTab((GraphPanel)this.heapGraph);
        this.generationsPanel = new GraphTab((GraphPanel)this.generationsGraph);
        this.threadsStatsPanel = new GraphTab((GraphPanel)this.threadsStatsGraph);
        this.heapPanel.setOpaque(false);
        this.generationsPanel.setOpaque(false);
        this.threadsStatsPanel.setOpaque(false);
        this.tabs.addTab(MEMORY_HEAP_TAB_NAME, null, this.heapPanel, MEMORY_HEAP_TAB_DESCR);
        this.tabs.addTab(MEMORY_GC_TAB_NAME, null, this.generationsPanel, MEMORY_GC_TAB_DESCR);
        this.tabs.addTab(THREADS_STATISTICS_TAB_NAME, null, this.threadsStatsPanel, THREADS_STATISTICS_TAB_DESCR);
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TelemetryWindow.this.moveToPreviousSubTab();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TelemetryWindow.this.moveToNextSubTab();
            }
        });
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
    }

    public static TelemetryWindow getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new TelemetryWindow();
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static void closeIfOpened() {
        if (defaultInstance != null) {
            IDEUtils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    if (defaultInstance.isOpened()) {
                        defaultInstance.close();
                    }
                }
            });
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentActivated() {
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.threadsStatsGraph != null) {
            this.threadsStatsGraph.requestFocus();
        }
    }

    public void componentDeactivated() {
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public void showGC() {
        this.tabs.setSelectedComponent(this.generationsPanel);
        this.open();
        this.requestActive();
    }

    public void showHeap() {
        this.tabs.setSelectedComponent(this.heapPanel);
        this.open();
        this.requestActive();
    }

    public void showThreads() {
        this.tabs.setSelectedComponent(this.threadsStatsPanel);
        this.open();
        this.requestActive();
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void moveToNextSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void moveToPreviousSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    static {
        windowIcon = Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/telemetryWindow.png");
    }

    private static final class GraphTab
    extends JPanel
    implements ActionListener,
    ChartActionListener,
    SaveViewAction.ViewProvider {
        private static final ImageIcon zoomInIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/zoomIn.png"));
        private static final ImageIcon zoomOutIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/zoomOut.png"));
        private static final ImageIcon zoomIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/zoom.png"));
        private static final ImageIcon scaleToFitIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/scaleToFit.png"));
        private final GraphPanel panel;
        private final JButton scaleToFitButton;
        private final JButton zoomInButton;
        private final JButton zoomOutButton;
        private final JScrollBar scrollBar;
        private boolean lastTrackingEnd;
        private double lastScale;
        private long lastOffset;

        public GraphTab(GraphPanel panel) {
            this.panel = panel;
            this.setLayout(new BorderLayout());
            FlatToolBar toolBar = new FlatToolBar(){

                public Component add(Component comp) {
                    if (comp instanceof JButton) {
                        UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
                    }
                    return super.add(comp);
                }
            };
            boolean scaleToFit = panel.getChart().isFitToWindow();
            this.zoomInButton = new JButton(zoomInIcon);
            this.zoomOutButton = new JButton(zoomOutIcon);
            this.scaleToFitButton = new JButton(scaleToFit ? zoomIcon : scaleToFitIcon);
            this.scrollBar = new JScrollBar(0);
            this.zoomInButton.setEnabled(!scaleToFit);
            this.zoomOutButton.setEnabled(!scaleToFit);
            this.scrollBar.setEnabled(!scaleToFit);
            this.zoomInButton.setToolTipText(ZOOM_IN_TOOLTIP);
            this.zoomOutButton.setToolTipText(ZOOM_OUT_TOOLTIP);
            this.scaleToFitButton.setToolTipText(scaleToFit ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
            if (!panel.getChart().containsValidData()) {
                this.scaleToFitButton.setEnabled(false);
                this.zoomInButton.setEnabled(false);
                this.zoomOutButton.setEnabled(false);
            }
            toolBar.setFloatable(false);
            toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            toolBar.add(new SaveViewAction(this));
            toolBar.addSeparator();
            toolBar.add(this.zoomInButton);
            toolBar.add(this.zoomOutButton);
            toolBar.add(this.scaleToFitButton);
            JPanel graphPanel = new JPanel();
            graphPanel.setLayout(new BorderLayout());
            graphPanel.setBorder(new CompoundBorder(new EmptyBorder(new Insets(0, 5, 0, 5)), new BevelBorder(1)));
            graphPanel.add((Component)panel, "Center");
            graphPanel.add((Component)this.scrollBar, "South");
            JPanel legendContainer = new JPanel();
            legendContainer.setLayout(new FlowLayout(4));
            if (panel.getBigLegendPanel() != null) {
                legendContainer.add(panel.getBigLegendPanel());
                panel.getBigLegendPanel().setOpaque(false);
            }
            this.add((Component)toolBar, "North");
            this.add((Component)graphPanel, "Center");
            this.add((Component)legendContainer, "South");
            this.setOpaque(true);
            this.setBackground(new HTMLTextArea().getBackground());
            toolBar.setOpaque(true);
            toolBar.setBackground(this.getBackground());
            graphPanel.setOpaque(true);
            graphPanel.setBackground(this.getBackground());
            legendContainer.setOpaque(true);
            legendContainer.setBackground(this.getBackground());
            this.zoomInButton.addActionListener(this);
            this.zoomOutButton.addActionListener(this);
            this.scaleToFitButton.addActionListener(this);
            panel.getChart().associateJScrollBar(this.scrollBar);
            panel.getChart().addChartActionListener((ChartActionListener)this);
        }

        public BufferedImage getViewImage(boolean onlyVisibleArea) {
            return UIUtils.createScreenshot((Component)this.panel);
        }

        public String getViewName() {
            if (this.panel instanceof MemoryGraphPanel) {
                return "memory-heap";
            }
            if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                return "memory-gc";
            }
            if (this.panel instanceof ThreadsGraphPanel) {
                return "threads-statistics";
            }
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            SynchronousXYChart xyChart = this.panel.getChart();
            if (e.getSource() == this.scaleToFitButton) {
                if (xyChart.isFitToWindow()) {
                    if (this.lastTrackingEnd) {
                        xyChart.setTrackingEnd(this.lastScale);
                    } else {
                        xyChart.setScaleAndOffsetX(this.lastScale, this.lastOffset);
                    }
                } else {
                    this.lastScale = xyChart.getScale();
                    this.lastOffset = xyChart.getViewOffsetX();
                    this.lastTrackingEnd = xyChart.isTrackingEnd();
                    xyChart.setFitToWindow();
                }
            } else if (e.getSource() == this.zoomInButton) {
                xyChart.setScale(xyChart.getScale() * 2.0);
            } else if (e.getSource() == this.zoomOutButton) {
                xyChart.setScale(xyChart.getScale() / 2.0);
            }
        }

        public void chartDataChanged() {
            this.updateZoomButtons();
        }

        public void chartFitToWindowChanged() {
            if (this.panel.getChart().isFitToWindow()) {
                this.scaleToFitButton.setIcon(zoomIcon);
                this.scaleToFitButton.setToolTipText(FIXED_SCALE_TOOLTIP);
            } else {
                this.scaleToFitButton.setIcon(scaleToFitIcon);
                this.scaleToFitButton.setToolTipText(SCALE_TO_FIT_TOOLTIP);
            }
            this.updateZoomButtons();
        }

        public void chartPanned() {
        }

        public void chartTrackingEndChanged() {
        }

        public void chartZoomed() {
            this.updateZoomButtons();
        }

        public boolean fitsVisibleArea() {
            return true;
        }

        public boolean hasView() {
            return true;
        }

        private void updateZoomButtons() {
            if (!this.panel.getChart().containsValidData()) {
                this.scaleToFitButton.setEnabled(false);
                this.zoomInButton.setEnabled(false);
                this.zoomOutButton.setEnabled(false);
            } else {
                this.scaleToFitButton.setEnabled(true);
                if (this.panel.getChart().isFitToWindow()) {
                    this.zoomInButton.setEnabled(false);
                    this.zoomOutButton.setEnabled(false);
                } else {
                    if (this.panel.getChart().isMaximumZoom()) {
                        this.zoomInButton.setEnabled(false);
                    } else {
                        this.zoomInButton.setEnabled(true);
                    }
                    if (this.panel.getChart().isMinimumZoom()) {
                        this.zoomOutButton.setEnabled(false);
                    } else {
                        this.zoomOutButton.setEnabled(true);
                    }
                }
            }
        }
    }
}

