/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.core.startup.layers.NonCacheManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayerCacheManager {
    static final Logger err = Logger.getLogger("org.netbeans.core.projects.cache");
    private final File cacheDir;
    private static LayerCacheManager emptyManager = null;

    public static LayerCacheManager emptyManager() {
        if (emptyManager == null) {
            emptyManager = new NonCacheManager();
        }
        return emptyManager;
    }

    protected LayerCacheManager(File file) {
        this.cacheDir = file;
    }

    public final File getCacheDirectory() {
        return this.cacheDir;
    }

    public abstract boolean cacheExists();

    public abstract void cleanupCache() throws IOException;

    public boolean supportsLoad() {
        return true;
    }

    public FileSystem createEmptyFileSystem() throws IOException {
        if (this.supportsLoad()) {
            throw new NotImplementedException();
        }
        return new XMLFileSystem();
    }

    public FileSystem createLoadedFileSystem() throws IOException {
        if (!this.supportsLoad()) {
            throw new IOException("Does not support loading!");
        }
        FileSystem fileSystem = this.createEmptyFileSystem();
        this.load(fileSystem);
        return fileSystem;
    }

    public void load(FileSystem fileSystem) throws IOException {
        throw new NotImplementedException();
    }

    public void store(FileSystem fileSystem, List<URL> list) throws IOException {
        throw new NotImplementedException();
    }

    public FileSystem store(List<URL> list) throws IOException {
        throw new NotImplementedException();
    }
}

