/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.dnd.EnhancedDragPainter;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.swing.tabcontrol.plaf.EqualPolygon;

public final class DropTargetGlassPane
extends JPanel
implements DropTargetListener {
    private final Observer observer;
    private final Informer informer;
    private WindowDnDManager windowDragAndDrop;
    private static boolean isHardwareDoubleBuffer = false;
    private Point location;
    private TopComponentDroppable droppable;
    private static final boolean DEBUG = Debug.isLoggable(DropTargetGlassPane.class);
    private Point dragLocation = null;
    private boolean guidedPaint = false;
    private DragRepaintManager dragRepaintManager = null;
    private static final Color FILL_COLOR = new Color(200, 200, 200, 120);
    private static final Rectangle scratch = new Rectangle();

    public DropTargetGlassPane(WindowDnDManager windowDnDManager) {
        this.observer = windowDnDManager;
        this.informer = windowDnDManager;
        this.windowDragAndDrop = windowDnDManager;
        isHardwareDoubleBuffer = !RepaintManager.currentManager(this).isDoubleBufferingEnabled();
        this.setOpaque(false);
    }

    public void initialize() {
        if (this.isVisible()) {
            this.revalidate();
        } else {
            this.setVisible(true);
        }
    }

    public void uninitialize() {
        if (this.location != null) {
            this.dragFinished();
        }
        this.setVisible(false);
    }

    void dragOver(Point point, TopComponentDroppable topComponentDroppable) {
        this.droppable = topComponentDroppable;
        if (this.dragRepaintManager == null) {
            this.setDragRepaintManager(new DragRepaintManager(this));
        }
        this.setDragLocation(point);
    }

    private void setDragLocation(Point point) {
        Point point2 = this.dragLocation;
        this.dragLocation = point;
        if (point != null && point.equals(point2)) {
            return;
        }
        if (point == null) {
            return;
        }
        if (this.droppable != null) {
            Component component = this.droppable.getDropComponent();
            Shape shape = this.droppable.getIndicationForLocation(SwingUtilities.convertPoint(this, point, component));
            EnhancedDragPainter enhancedDragPainter = null;
            if (this.droppable instanceof EnhancedDragPainter) {
                enhancedDragPainter = (EnhancedDragPainter)((Object)this.droppable);
            }
            this.dragRepaintManager.setShapeAndTarget(shape, component, enhancedDragPainter);
        } else {
            this.dragRepaintManager.eraseLastIndication(null);
        }
    }

    private void dragExited() {
        this.clear();
    }

    private void setGuidedPaint(boolean bl) {
        this.guidedPaint = bl;
    }

    private boolean isGuidedPaint() {
        return this.guidedPaint;
    }

    public void clearIndications() {
        this.clear();
    }

    private void dragActionChanged(Point point) {
        this.setDragLocation(point);
    }

    private void dragFinished() {
        this.clear();
        this.setDragRepaintManager(null);
    }

    private void setDragRepaintManager(DragRepaintManager dragRepaintManager) {
        this.dragRepaintManager = dragRepaintManager;
    }

    private void clear() {
        this.droppable = null;
        if (this.dragRepaintManager != null) {
            this.dragRepaintManager.setShapeAndTarget(null, null, null);
        }
        this.setDragLocation(null);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.isGuidedPaint() && this.dragRepaintManager != null) {
            this.dragRepaintManager.paintCurrentIndication((Graphics2D)graphics);
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("dragEnter");
        }
        if ((n = dropTargetDragEvent.getDropAction()) == 0) {
            n = 2;
        }
        if ((n & 3) > 0) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        Component component;
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("dragExit");
        }
        if ((component = dropTargetEvent.getDropTargetContext().getComponent()) == this) {
            this.dragExited();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("dragOver");
        }
        if (this.dragRepaintManager == null) {
            this.setDragRepaintManager(new DragRepaintManager(this));
        }
        this.observer.setLastDropTarget(this);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        boolean bl;
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("dropActionChanged");
        }
        if (bl = (n = dropTargetDragEvent.getDropAction()) == 2 || n == 1 && this.informer.isCopyOperationPossible()) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
        Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
        if (component == this) {
            this.dragActionChanged(bl ? dropTargetDragEvent.getLocation() : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        int n;
        Component component;
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("drop");
        }
        if ((component = dropTargetDropEvent.getDropTargetContext().getComponent()) == this) {
            this.dragFinished();
        }
        if ((n = dropTargetDropEvent.getDropAction()) != 2 && n != 1) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        dropTargetDropEvent.acceptDrop(n);
        boolean bl = false;
        try {
            Point point = dropTargetDropEvent.getLocation();
            SwingUtilities.convertPointToScreen(point, component);
            if (WindowDnDManager.isAroundCenterPanel(point)) {
                return;
            }
            bl = this.windowDragAndDrop.tryPerformDrop(this.informer.getController(), this.informer.getFloatingFrames(), point, n, dropTargetDropEvent.getTransferable());
        }
        finally {
            this.observer.setDropSuccess(bl);
            dropTargetDropEvent.dropComplete(false);
        }
    }

    private static void debugLog(String string) {
        Debug.log(DropTargetGlassPane.class, string);
    }

    private static class DragRepaintManager {
        private Shape shape = null;
        private Component lastDropComponent;
        private EnhancedDragPainter lastEnhanced;
        DropTargetGlassPane pane;
        private Graphics2D g = null;

        public DragRepaintManager(DropTargetGlassPane dropTargetGlassPane) {
            this.pane = dropTargetGlassPane;
            if (isHardwareDoubleBuffer && !Boolean.getBoolean("nb.winsys.mac.no.double.buffer")) {
                RepaintManager.currentManager(dropTargetGlassPane).setDoubleBufferingEnabled(true);
            }
        }

        protected void finalize() {
            if (this.g != null) {
                this.g.dispose();
            }
            if (isHardwareDoubleBuffer && !Boolean.getBoolean("nb.winsys.mac.no.double.buffer")) {
                RepaintManager.currentManager(this.pane).setDoubleBufferingEnabled(false);
            }
        }

        private Graphics2D getGraphics() {
            if (this.g == null) {
                this.g = (Graphics2D)this.pane.getGraphics();
            }
            return this.g;
        }

        public void clear() {
            this.lastDropComponent = null;
            this.lastEnhanced = null;
        }

        public void setShapeAndTarget(Shape shape, Component component, EnhancedDragPainter enhancedDragPainter) {
            Shape shape2 = this.shape;
            if (shape2 != null && shape != null) {
                if (!this.shape.equals(shape)) {
                    this.shape = shape;
                    this.shapeChange(shape2, this.shape, component, enhancedDragPainter);
                }
            } else if (shape2 == null != (shape == null)) {
                this.shape = shape;
                this.shapeChange(shape2, shape, component, enhancedDragPainter);
            }
        }

        public void paintCurrentIndication(Graphics2D graphics2D) {
            if (this.shape != null) {
                this.paintShapeOnGlassPane(this.shape, graphics2D);
            }
        }

        public void eraseLastIndication(Graphics2D graphics2D) {
            if (this.shape == null) {
                return;
            }
            this.eraseShape(graphics2D);
        }

        private void shapeChange(Shape shape, Shape shape2, Component component, EnhancedDragPainter enhancedDragPainter) {
            if (shape != null) {
                this.eraseShape(this.g);
            }
            this.lastDropComponent = component;
            this.lastEnhanced = enhancedDragPainter;
            if (shape2 != null) {
                this.paintShapeOnGlassPane(shape2, this.g);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eraseShape(Graphics2D graphics2D) {
            if (graphics2D == null) {
                graphics2D = this.getGraphics();
            }
            if (graphics2D == null) {
                return;
            }
            this.pane.setGuidedPaint(true);
            try {
                JRootPane jRootPane = ((JComponent)this.lastDropComponent).getRootPane();
                jRootPane.paint(graphics2D);
                graphics2D.setClip(null);
            }
            finally {
                this.pane.setGuidedPaint(false);
            }
            if (isHardwareDoubleBuffer) {
                Toolkit.getDefaultToolkit().sync();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintShapeOnGlassPane(Shape shape, Graphics2D graphics2D) {
            if (graphics2D == null) {
                graphics2D = this.getGraphics();
            }
            if (graphics2D == null) {
                return;
            }
            this.pane.setGuidedPaint(true);
            try {
                JComponent jComponent = (JComponent)this.lastDropComponent;
                if (this.lastEnhanced != null) {
                    this.lastEnhanced.additionalDragPaint(graphics2D);
                }
                Shape shape2 = this.getClipForIndication(shape, true, this.lastDropComponent);
                graphics2D.setClip(shape2);
                this.paintShape(shape, graphics2D);
                graphics2D.setClip(null);
            }
            finally {
                this.pane.setGuidedPaint(false);
            }
            if (isHardwareDoubleBuffer) {
                Toolkit.getDefaultToolkit().sync();
            }
        }

        private void paintShape(Shape shape, Graphics2D graphics2D) {
            Color color;
            Color color2 = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            Paint paint = graphics2D.getPaint();
            Color color3 = UIManager.getColor("Panel.dropTargetGlassPane");
            if (color3 == null) {
                color3 = Color.red;
            }
            graphics2D.setColor(color3);
            graphics2D.setStroke(this.createIndicationStroke());
            graphics2D.setPaint(this.createPaint());
            Color color4 = color = Constants.SWITCH_DROP_INDICATION_FADE ? FILL_COLOR : null;
            if (shape instanceof Rectangle) {
                this.drawIndicationRectangle(graphics2D, (Rectangle)shape, this.lastDropComponent, color);
            } else if (shape instanceof GeneralPath) {
                this.drawIndicationGeneralPath(graphics2D, (GeneralPath)shape, this.lastDropComponent, color);
            } else if (shape instanceof Polygon) {
                this.drawIndicationPolygon(graphics2D, (Polygon)shape, this.lastDropComponent, color);
            }
            graphics2D.setColor(color2);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
        }

        private Stroke createIndicationStroke() {
            return new BasicStroke(3.0f);
        }

        private Shape getClipForIndication(Shape shape, boolean bl, Component component) {
            Shape shape2;
            if (shape instanceof Rectangle) {
                scratch.setBounds((Rectangle)shape);
                scratch.x -= 3;
                scratch.y -= 3;
                scratch.width += 6;
                scratch.height += 6;
                Area area = new Area(scratch);
                scratch.setBounds((Rectangle)shape);
                scratch.x += 4;
                scratch.y += 4;
                scratch.width -= 8;
                scratch.height -= 8;
                area.subtract(new Area(scratch));
                if (bl) {
                    Point point = new Point(0, 0);
                    point = SwingUtilities.convertPoint(this.lastDropComponent, point, this.pane);
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(point.x, point.y);
                    area.transform(affineTransform);
                }
                shape2 = area;
            } else {
                if (shape instanceof Polygon) {
                    if (bl) {
                        shape = this.getTransformedPath((Polygon)shape, component);
                    }
                } else if (shape instanceof GeneralPath) {
                    if (bl) {
                        shape = this.getTransformedPath((GeneralPath)shape, component);
                    }
                } else {
                    return null;
                }
                shape2 = new BasicStroke(5.0f).createStrokedShape(shape);
            }
            return shape2;
        }

        private Polygon getTransformedPath(Polygon polygon, Component component) {
            EqualPolygon equalPolygon = new EqualPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(component, point, this.pane);
            equalPolygon.translate(point.x, point.y);
            return equalPolygon;
        }

        private GeneralPath getTransformedPath(GeneralPath generalPath, Component component) {
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(component, point, this.pane);
            generalPath = (GeneralPath)generalPath.clone();
            generalPath.transform(new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)point.x, (double)point.y));
            return generalPath;
        }

        private void drawIndicationPolygon(Graphics2D graphics2D, Polygon polygon, Component component, Color color) {
            if (graphics2D == null) {
                graphics2D = this.getGraphics();
            }
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(component, point, this.pane);
            polygon = new EqualPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            polygon.translate(point.x, point.y);
            graphics2D.drawPolygon(polygon);
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fillPolygon(polygon);
            }
        }

        private void drawIndicationRectangle(Graphics2D graphics2D, Rectangle rectangle, Component component, Color color) {
            if (graphics2D == null) {
                graphics2D = this.getGraphics();
            }
            rectangle = SwingUtilities.convertRectangle(component, rectangle, this.pane);
            graphics2D.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            }
        }

        private void drawIndicationGeneralPath(Graphics2D graphics2D, GeneralPath generalPath, Component component, Color color) {
            if (graphics2D == null) {
                graphics2D = this.getGraphics();
            }
            generalPath = this.getTransformedPath(generalPath, component);
            graphics2D.draw(generalPath);
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
            }
        }

        private TexturePaint createPaint() {
            BufferedImage bufferedImage = new BufferedImage(2, 2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Color color = UIManager.getColor("Panel.dropTargetGlassPane");
            if (color == null) {
                color = new Color(255, 90, 0);
            }
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, 1, 1);
            graphics2D.fillRect(1, 1, 1, 1);
            graphics2D.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 0));
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.75f));
            graphics2D.fillRect(1, 0, 1, 1);
            graphics2D.fillRect(0, 1, 1, 1);
            return new TexturePaint(bufferedImage, new Rectangle(0, 0, 2, 2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Informer {
        public boolean isCopyOperationPossible();

        public Controller getController();

        public Set<Component> getFloatingFrames();
    }

    static interface Observer {
        public void setDropSuccess(boolean var1);

        public void setLastDropTarget(DropTargetGlassPane var1);
    }
}

