/**
 * \file seq/seq_event.c
 * \brief Sequencer Event Types
 * \author Takashi Iwai <tiwai@suse.de>
 * \date 2001
 */

#include "local.h"

#ifndef DOC_HIDDEN
#define FIXED_EV(x)	(_SND_SEQ_TYPE(SND_SEQ_EVFLG_FIXED) | _SND_SEQ_TYPE(x))
#endif

/** Event types conversion array */
const unsigned int snd_seq_event_types[256] = {
	[SND_SEQ_EVENT_SYSTEM ... SND_SEQ_EVENT_RESULT]
	= FIXED_EV(SND_SEQ_EVFLG_RESULT),
	[SND_SEQ_EVENT_NOTE]
	= FIXED_EV(SND_SEQ_EVFLG_NOTE) | _SND_SEQ_TYPE_OPT(SND_SEQ_EVFLG_NOTE_TWOARG),
	[SND_SEQ_EVENT_NOTEON ... SND_SEQ_EVENT_KEYPRESS]
	= FIXED_EV(SND_SEQ_EVFLG_NOTE),
	[SND_SEQ_EVENT_CONTROLLER ... SND_SEQ_EVENT_REGPARAM]
	= FIXED_EV(SND_SEQ_EVFLG_CONTROL),
	[SND_SEQ_EVENT_START ... SND_SEQ_EVENT_STOP]
	= FIXED_EV(SND_SEQ_EVFLG_QUEUE),
	[SND_SEQ_EVENT_SETPOS_TICK]
	= FIXED_EV(SND_SEQ_EVFLG_QUEUE) | _SND_SEQ_TYPE_OPT(SND_SEQ_EVFLG_QUEUE_TICK),
	[SND_SEQ_EVENT_SETPOS_TIME]
	= FIXED_EV(SND_SEQ_EVFLG_QUEUE) | _SND_SEQ_TYPE_OPT(SND_SEQ_EVFLG_QUEUE_TIME),
	[SND_SEQ_EVENT_TEMPO ... SND_SEQ_EVENT_SYNC_POS]
	= FIXED_EV(SND_SEQ_EVFLG_QUEUE) | _SND_SEQ_TYPE_OPT(SND_SEQ_EVFLG_QUEUE_VALUE),
	[SND_SEQ_EVENT_TUNE_REQUEST ... SND_SEQ_EVENT_SENSING]
	= FIXED_EV(SND_SEQ_EVFLG_NONE),
	[SND_SEQ_EVENT_ECHO ... SND_SEQ_EVENT_OSS]
	= FIXED_EV(SND_SEQ_EVFLG_RAW) | FIXED_EV(SND_SEQ_EVFLG_SYSTEM),
	[SND_SEQ_EVENT_CLIENT_START ... SND_SEQ_EVENT_PORT_CHANGE]
	= FIXED_EV(SND_SEQ_EVFLG_MESSAGE),
	[SND_SEQ_EVENT_PORT_SUBSCRIBED ... SND_SEQ_EVENT_PORT_UNSUBSCRIBED]
	= FIXED_EV(SND_SEQ_EVFLG_CONNECTION),
	[SND_SEQ_EVENT_SAMPLE ... SND_SEQ_EVENT_SAMPLE_PRIVATE1]
	= FIXED_EV(SND_SEQ_EVFLG_SAMPLE),
	[SND_SEQ_EVENT_USR0 ... SND_SEQ_EVENT_USR9]
	= FIXED_EV(SND_SEQ_EVFLG_RAW) | FIXED_EV(SND_SEQ_EVFLG_USERS),
	[SND_SEQ_EVENT_INSTR_BEGIN ... SND_SEQ_EVENT_INSTR_CHANGE]
	= _SND_SEQ_TYPE(SND_SEQ_EVFLG_INSTR) | _SND_SEQ_TYPE(SND_SEQ_EVFLG_VARUSR),
	[SND_SEQ_EVENT_SYSEX ... SND_SEQ_EVENT_BOUNCE]
	= _SND_SEQ_TYPE(SND_SEQ_EVFLG_VARIABLE),
	[SND_SEQ_EVENT_USR_VAR0 ... SND_SEQ_EVENT_USR_VAR4]
	= _SND_SEQ_TYPE(SND_SEQ_EVFLG_VARIABLE) | _SND_SEQ_TYPE(SND_SEQ_EVFLG_USERS),
	[SND_SEQ_EVENT_NONE]
	= FIXED_EV(SND_SEQ_EVFLG_NONE),
};

