/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11SecureRandom
extends SecureRandomSpi {
    private static final long serialVersionUID = -8939510236124553291L;
    private final Token token;
    private volatile SecureRandom mixRandom;
    private byte[] mixBuffer;
    private int buffered;

    P11SecureRandom(Token token) {
        this.token = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void engineSetSeed(byte[] byArray) {
        block9: {
            if (byArray == null) {
                throw new NullPointerException("seed must not be null");
            }
            Session session = null;
            try {
                session = this.token.getOpSession();
                this.token.p11.C_SeedRandom(session.id(), byArray);
            }
            catch (PKCS11Exception pKCS11Exception) {
                SecureRandom secureRandom = this.mixRandom;
                if (secureRandom != null) {
                    secureRandom.setSeed(byArray);
                    break block9;
                }
                try {
                    this.mixBuffer = new byte[20];
                    secureRandom = SecureRandom.getInstance("SHA1PRNG");
                    secureRandom.setSeed(byArray);
                    this.mixRandom = secureRandom;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new ProviderException(noSuchAlgorithmException);
                }
            }
            finally {
                this.token.releaseSession(session);
            }
        }
    }

    protected void engineNextBytes(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.token.p11.C_GenerateRandom(session.id(), byArray);
            this.mix(byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("nextBytes() failed", pKCS11Exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    protected byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        this.engineNextBytes(byArray);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mix(byte[] byArray) {
        SecureRandom secureRandom = this.mixRandom;
        if (secureRandom == null) {
            return;
        }
        P11SecureRandom p11SecureRandom = this;
        synchronized (p11SecureRandom) {
            int n = 0;
            int n2 = byArray.length;
            while (n2-- > 0) {
                if (this.buffered == 0) {
                    secureRandom.nextBytes(this.mixBuffer);
                    this.buffered = this.mixBuffer.length;
                }
                int n3 = n++;
                byArray[n3] = (byte)(byArray[n3] ^ this.mixBuffer[this.mixBuffer.length - this.buffered]);
                --this.buffered;
            }
        }
    }
}

