/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.SymbolTable;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.JNIHandleBlock;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.AbstractHeapGraphWriter;
import sun.jvm.hotspot.utilities.Assert;

public class HeapHprofBinWriter
extends AbstractHeapGraphWriter {
    private static final String HPROF_HEADER = "JAVA PROFILE 1.0.1";
    private static final int HPROF_UTF8 = 1;
    private static final int HPROF_LOAD_CLASS = 2;
    private static final int HPROF_UNLOAD_CLASS = 3;
    private static final int HPROF_FRAME = 4;
    private static final int HPROF_TRACE = 5;
    private static final int HPROF_ALLOC_SITES = 6;
    private static final int HPROF_HEAP_SUMMARY = 7;
    private static final int HPROF_START_THREAD = 10;
    private static final int HPROF_END_THREAD = 11;
    private static final int HPROF_HEAP_DUMP = 12;
    private static final int HPROF_CPU_SAMPLES = 13;
    private static final int HPROF_CONTROL_SETTINGS = 14;
    private static final int HPROF_GC_ROOT_UNKNOWN = 255;
    private static final int HPROF_GC_ROOT_JNI_GLOBAL = 1;
    private static final int HPROF_GC_ROOT_JNI_LOCAL = 2;
    private static final int HPROF_GC_ROOT_JAVA_FRAME = 3;
    private static final int HPROF_GC_ROOT_NATIVE_STACK = 4;
    private static final int HPROF_GC_ROOT_STICKY_CLASS = 5;
    private static final int HPROF_GC_ROOT_THREAD_BLOCK = 6;
    private static final int HPROF_GC_ROOT_MONITOR_USED = 7;
    private static final int HPROF_GC_ROOT_THREAD_OBJ = 8;
    private static final int HPROF_GC_CLASS_DUMP = 32;
    private static final int HPROF_GC_INSTANCE_DUMP = 33;
    private static final int HPROF_GC_OBJ_ARRAY_DUMP = 34;
    private static final int HPROF_GC_PRIM_ARRAY_DUMP = 35;
    private static final int HPROF_ARRAY_OBJECT = 1;
    private static final int HPROF_NORMAL_OBJECT = 2;
    private static final int HPROF_BOOLEAN = 4;
    private static final int HPROF_CHAR = 5;
    private static final int HPROF_FLOAT = 6;
    private static final int HPROF_DOUBLE = 7;
    private static final int HPROF_BYTE = 8;
    private static final int HPROF_SHORT = 9;
    private static final int HPROF_INT = 10;
    private static final int HPROF_LONG = 11;
    private static final int JVM_SIGNATURE_BOOLEAN = 90;
    private static final int JVM_SIGNATURE_CHAR = 67;
    private static final int JVM_SIGNATURE_BYTE = 66;
    private static final int JVM_SIGNATURE_SHORT = 83;
    private static final int JVM_SIGNATURE_INT = 73;
    private static final int JVM_SIGNATURE_LONG = 74;
    private static final int JVM_SIGNATURE_FLOAT = 70;
    private static final int JVM_SIGNATURE_DOUBLE = 68;
    private static final int JVM_SIGNATURE_ARRAY = 91;
    private static final int JVM_SIGNATURE_CLASS = 76;
    private static final int DUMMY_STACK_TRACE_ID = 1;
    private static final int EMPTY_FRAME_DEPTH = -1;
    private DataOutputStream out;
    private Debugger dbg;
    private ObjectHeap objectHeap;
    private SymbolTable symTbl;
    private int OBJ_ID_SIZE;
    private long BOOLEAN_BASE_OFFSET;
    private long BYTE_BASE_OFFSET;
    private long CHAR_BASE_OFFSET;
    private long SHORT_BASE_OFFSET;
    private long INT_BASE_OFFSET;
    private long LONG_BASE_OFFSET;
    private long FLOAT_BASE_OFFSET;
    private long DOUBLE_BASE_OFFSET;
    private long OBJECT_BASE_OFFSET;
    private long BOOLEAN_SIZE;
    private long BYTE_SIZE;
    private long CHAR_SIZE;
    private long SHORT_SIZE;
    private long INT_SIZE;
    private long LONG_SIZE;
    private long FLOAT_SIZE;
    private long DOUBLE_SIZE;
    private Map classDataCache = new HashMap();

    public synchronized void write(String fileName) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        FileChannel chn = fos.getChannel();
        this.out = new DataOutputStream(new BufferedOutputStream(fos));
        VM vm = VM.getVM();
        this.dbg = vm.getDebugger();
        this.objectHeap = vm.getObjectHeap();
        this.symTbl = vm.getSymbolTable();
        this.OBJ_ID_SIZE = (int)vm.getOopSize();
        this.BOOLEAN_BASE_OFFSET = TypeArray.baseOffsetInBytes(BasicType.T_BOOLEAN);
        this.BYTE_BASE_OFFSET = TypeArray.baseOffsetInBytes(BasicType.T_BYTE);
        this.CHAR_BASE_OFFSET = TypeArray.baseOffsetInBytes(BasicType.T_CHAR);
        this.SHORT_BASE_OFFSET = TypeArray.baseOffsetInBytes(BasicType.T_SHORT);
        this.INT_BASE_OFFSET = TypeArray.baseOffsetInBytes(BasicType.T_INT);
        this.LONG_BASE_OFFSET = TypeArray.baseOffsetInBytes(BasicType.T_LONG);
        this.FLOAT_BASE_OFFSET = TypeArray.baseOffsetInBytes(BasicType.T_FLOAT);
        this.DOUBLE_BASE_OFFSET = TypeArray.baseOffsetInBytes(BasicType.T_DOUBLE);
        this.OBJECT_BASE_OFFSET = TypeArray.baseOffsetInBytes(BasicType.T_OBJECT);
        this.BOOLEAN_SIZE = this.objectHeap.getBooleanSize();
        this.BYTE_SIZE = this.objectHeap.getByteSize();
        this.CHAR_SIZE = this.objectHeap.getCharSize();
        this.SHORT_SIZE = this.objectHeap.getShortSize();
        this.INT_SIZE = this.objectHeap.getIntSize();
        this.LONG_SIZE = this.objectHeap.getLongSize();
        this.FLOAT_SIZE = this.objectHeap.getFloatSize();
        this.DOUBLE_SIZE = this.objectHeap.getDoubleSize();
        this.writeFileHeader();
        this.writeDummyTrace();
        this.writeSymbols();
        this.writeClasses();
        this.out.writeByte(12);
        this.out.writeInt(0);
        this.out.flush();
        long dumpStart = chn.position();
        this.out.writeInt(0);
        this.writeClassDumpRecords();
        super.write();
        this.out.flush();
        this.out = null;
        long dumpEnd = chn.position();
        int dumpLen = (int)(dumpEnd - dumpStart - 4L);
        chn.position(dumpStart);
        fos.write(dumpLen >>> 24 & 0xFF);
        fos.write(dumpLen >>> 16 & 0xFF);
        fos.write(dumpLen >>> 8 & 0xFF);
        fos.write(dumpLen >>> 0 & 0xFF);
        fos.close();
    }

    private void writeClassDumpRecords() throws IOException {
        SystemDictionary sysDict = VM.getVM().getSystemDictionary();
        try {
            sysDict.allClassesDo(new SystemDictionary.ClassVisitor(){

                public void visit(Klass k) {
                    try {
                        HeapHprofBinWriter.this.writeClassDumpRecord(k);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
        }
    }

    protected void writeClass(Instance instance) throws IOException {
        Klass reflectedKlass = OopUtilities.classOopToKlass(instance);
        if (reflectedKlass == null) {
            this.writeInstance(instance);
        }
    }

    private void writeClassDumpRecord(Klass k) throws IOException {
        this.out.writeByte(32);
        this.writeObjectID(k.getJavaMirror());
        this.out.writeInt(1);
        Klass superKlass = k.getJavaSuper();
        if (superKlass != null) {
            this.writeObjectID(superKlass.getJavaMirror());
        } else {
            this.writeObjectID(null);
        }
        if (k instanceof InstanceKlass) {
            InstanceKlass ik = (InstanceKlass)k;
            this.writeObjectID(ik.getClassLoader());
            this.writeObjectID(ik.getSigners());
            this.writeObjectID(ik.getProtectionDomain());
            this.writeObjectID(null);
            this.writeObjectID(null);
            List fields = HeapHprofBinWriter.getInstanceFields(ik);
            int instSize = this.getSizeForFields(fields);
            this.classDataCache.put(ik, new ClassData(instSize, fields));
            this.out.writeInt(instSize);
            this.out.writeShort(0);
            List declaredFields = ik.getImmediateFields();
            ArrayList<Field> staticFields = new ArrayList<Field>();
            ArrayList<Field> instanceFields = new ArrayList<Field>();
            Iterator itr = null;
            itr = declaredFields.iterator();
            while (itr.hasNext()) {
                Field field = (Field)itr.next();
                if (field.isStatic()) {
                    staticFields.add(field);
                    continue;
                }
                instanceFields.add(field);
            }
            this.writeFieldDescriptors(staticFields, ik);
            this.writeFieldDescriptors(instanceFields, null);
        } else {
            if (k instanceof ObjArrayKlass) {
                ObjArrayKlass oak = (ObjArrayKlass)k;
                Klass bottomKlass = oak.getBottomKlass();
                if (bottomKlass instanceof InstanceKlass) {
                    InstanceKlass ik = (InstanceKlass)bottomKlass;
                    this.writeObjectID(ik.getClassLoader());
                    this.writeObjectID(ik.getSigners());
                    this.writeObjectID(ik.getProtectionDomain());
                } else {
                    this.writeObjectID(null);
                    this.writeObjectID(null);
                    this.writeObjectID(null);
                }
            } else {
                this.writeObjectID(null);
                this.writeObjectID(null);
                this.writeObjectID(null);
            }
            this.writeObjectID(null);
            this.writeObjectID(null);
            this.out.writeInt(0);
            this.out.writeShort(0);
            this.out.writeShort(0);
            this.out.writeShort(0);
        }
    }

    protected void writeJavaThread(JavaThread jt, int index) throws IOException {
        this.out.writeByte(8);
        this.writeObjectID(jt.getThreadObj());
        this.out.writeInt(index);
        this.out.writeInt(1);
        this.writeLocalJNIHandles(jt, index);
    }

    protected void writeLocalJNIHandles(JavaThread jt, int index) throws IOException {
        final int threadIndex = index;
        JNIHandleBlock blk = jt.activeHandles();
        if (blk != null) {
            try {
                blk.oopsDo(new AddressVisitor(){

                    public void visitAddress(Address handleAddr) {
                        try {
                            if (handleAddr != null) {
                                OopHandle oopHandle = handleAddr.getOopHandleAt(0L);
                                Oop oop = HeapHprofBinWriter.this.objectHeap.newOop(oopHandle);
                                if (oop != null && HeapHprofBinWriter.this.isJavaVisible(oop)) {
                                    HeapHprofBinWriter.this.out.writeByte(2);
                                    HeapHprofBinWriter.this.writeObjectID(oop);
                                    HeapHprofBinWriter.this.out.writeInt(threadIndex);
                                    HeapHprofBinWriter.this.out.writeInt(-1);
                                }
                            }
                        }
                        catch (IOException exp) {
                            throw new RuntimeException(exp);
                        }
                    }
                });
            }
            catch (RuntimeException re) {
                this.handleRuntimeException(re);
            }
        }
    }

    protected void writeGlobalJNIHandle(Address handleAddr) throws IOException {
        OopHandle oopHandle = handleAddr.getOopHandleAt(0L);
        Oop oop = this.objectHeap.newOop(oopHandle);
        if (oop != null && this.isJavaVisible(oop)) {
            this.out.writeByte(1);
            this.writeObjectID(oop);
            this.writeObjectID(this.getAddressValue(handleAddr));
        }
    }

    protected void writeObjectArray(ObjArray array) throws IOException {
        this.out.writeByte(34);
        this.writeObjectID(array);
        this.out.writeInt(1);
        this.out.writeInt((int)array.getLength());
        this.writeObjectID(array.getKlass().getJavaMirror());
        int length = (int)array.getLength();
        for (int index = 0; index < length; ++index) {
            long offset = this.OBJECT_BASE_OFFSET + (long)(index * this.OBJ_ID_SIZE);
            OopHandle handle = array.getHandle().getOopHandleAt(offset);
            this.writeObjectID(this.getAddressValue(handle));
        }
    }

    protected void writePrimitiveArray(TypeArray array) throws IOException {
        this.out.writeByte(35);
        this.writeObjectID(array);
        this.out.writeInt(1);
        this.out.writeInt((int)array.getLength());
        TypeArrayKlass tak = (TypeArrayKlass)array.getKlass();
        int type = tak.getElementType();
        this.out.writeByte((byte)type);
        switch (type) {
            case 4: {
                this.writeBooleanArray(array);
                break;
            }
            case 5: {
                this.writeCharArray(array);
                break;
            }
            case 6: {
                this.writeFloatArray(array);
                break;
            }
            case 7: {
                this.writeDoubleArray(array);
                break;
            }
            case 8: {
                this.writeByteArray(array);
                break;
            }
            case 9: {
                this.writeShortArray(array);
                break;
            }
            case 10: {
                this.writeIntArray(array);
                break;
            }
            case 11: {
                this.writeLongArray(array);
                break;
            }
            default: {
                throw new RuntimeException("should not reach here");
            }
        }
    }

    private void writeBooleanArray(TypeArray array) throws IOException {
        int length = (int)array.getLength();
        for (int index = 0; index < length; ++index) {
            long offset = this.BOOLEAN_BASE_OFFSET + (long)index * this.BOOLEAN_SIZE;
            this.out.writeBoolean(array.getHandle().getJBooleanAt(offset));
        }
    }

    private void writeByteArray(TypeArray array) throws IOException {
        int length = (int)array.getLength();
        for (int index = 0; index < length; ++index) {
            long offset = this.BYTE_BASE_OFFSET + (long)index * this.BYTE_SIZE;
            this.out.writeByte(array.getHandle().getJByteAt(offset));
        }
    }

    private void writeShortArray(TypeArray array) throws IOException {
        int length = (int)array.getLength();
        for (int index = 0; index < length; ++index) {
            long offset = this.SHORT_BASE_OFFSET + (long)index * this.SHORT_SIZE;
            this.out.writeShort(array.getHandle().getJShortAt(offset));
        }
    }

    private void writeIntArray(TypeArray array) throws IOException {
        int length = (int)array.getLength();
        for (int index = 0; index < length; ++index) {
            long offset = this.INT_BASE_OFFSET + (long)index * this.INT_SIZE;
            this.out.writeInt(array.getHandle().getJIntAt(offset));
        }
    }

    private void writeLongArray(TypeArray array) throws IOException {
        int length = (int)array.getLength();
        for (int index = 0; index < length; ++index) {
            long offset = this.LONG_BASE_OFFSET + (long)index * this.LONG_SIZE;
            this.out.writeLong(array.getHandle().getJLongAt(offset));
        }
    }

    private void writeCharArray(TypeArray array) throws IOException {
        int length = (int)array.getLength();
        for (int index = 0; index < length; ++index) {
            long offset = this.CHAR_BASE_OFFSET + (long)index * this.CHAR_SIZE;
            this.out.writeChar(array.getHandle().getJCharAt(offset));
        }
    }

    private void writeFloatArray(TypeArray array) throws IOException {
        int length = (int)array.getLength();
        for (int index = 0; index < length; ++index) {
            long offset = this.FLOAT_BASE_OFFSET + (long)index * this.FLOAT_SIZE;
            this.out.writeFloat(array.getHandle().getJFloatAt(offset));
        }
    }

    private void writeDoubleArray(TypeArray array) throws IOException {
        int length = (int)array.getLength();
        for (int index = 0; index < length; ++index) {
            long offset = this.DOUBLE_BASE_OFFSET + (long)index * this.DOUBLE_SIZE;
            this.out.writeDouble(array.getHandle().getJDoubleAt(offset));
        }
    }

    protected void writeInstance(Instance instance) throws IOException {
        this.out.writeByte(33);
        this.writeObjectID(instance);
        this.out.writeInt(1);
        Klass klass = instance.getKlass();
        this.writeObjectID(klass.getJavaMirror());
        ClassData cd = (ClassData)this.classDataCache.get(klass);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(cd != null, "can not get class data for " + klass.getName().asString() + klass.getHandle());
        }
        List fields = cd.fields;
        int size = cd.instSize;
        this.out.writeInt(size);
        Iterator itr = fields.iterator();
        while (itr.hasNext()) {
            this.writeField((Field)itr.next(), instance);
        }
    }

    private void writeFieldDescriptors(List fields, InstanceKlass ik) throws IOException {
        this.out.writeShort((short)fields.size());
        Iterator itr = fields.iterator();
        while (itr.hasNext()) {
            Field field = (Field)itr.next();
            Symbol name = this.symTbl.probe(field.getID().getName());
            this.writeObjectID(name);
            char typeCode = (char)field.getSignature().getByteAt(0L);
            int kind = HeapHprofBinWriter.signatureToHprofKind(typeCode);
            this.out.writeByte((byte)kind);
            if (ik == null) continue;
            this.writeField(field, ik);
        }
    }

    public static int signatureToHprofKind(char ch) {
        switch (ch) {
            case 'L': 
            case '[': {
                return 2;
            }
            case 'Z': {
                return 4;
            }
            case 'C': {
                return 5;
            }
            case 'F': {
                return 6;
            }
            case 'D': {
                return 7;
            }
            case 'B': {
                return 8;
            }
            case 'S': {
                return 9;
            }
            case 'I': {
                return 10;
            }
            case 'J': {
                return 11;
            }
        }
        throw new RuntimeException("should not reach here");
    }

    private void writeField(Field field, Oop oop) throws IOException {
        char typeCode = (char)field.getSignature().getByteAt(0L);
        switch (typeCode) {
            case 'Z': {
                this.out.writeBoolean(((BooleanField)field).getValue(oop));
                break;
            }
            case 'C': {
                this.out.writeChar(((CharField)field).getValue(oop));
                break;
            }
            case 'B': {
                this.out.writeByte(((ByteField)field).getValue(oop));
                break;
            }
            case 'S': {
                this.out.writeShort(((ShortField)field).getValue(oop));
                break;
            }
            case 'I': {
                this.out.writeInt(((IntField)field).getValue(oop));
                break;
            }
            case 'J': {
                this.out.writeLong(((LongField)field).getValue(oop));
                break;
            }
            case 'F': {
                this.out.writeFloat(((FloatField)field).getValue(oop));
                break;
            }
            case 'D': {
                this.out.writeDouble(((DoubleField)field).getValue(oop));
                break;
            }
            case 'L': 
            case '[': {
                OopHandle handle = ((OopField)field).getValueAsOopHandle(oop);
                this.writeObjectID(this.getAddressValue(handle));
                break;
            }
            default: {
                throw new RuntimeException("should not reach here");
            }
        }
    }

    private void writeHeader(int tag, int len) throws IOException {
        this.out.writeByte((byte)tag);
        this.out.writeInt(0);
        this.out.writeInt(len);
    }

    private void writeDummyTrace() throws IOException {
        this.writeHeader(5, 12);
        this.out.writeInt(1);
        this.out.writeInt(0);
        this.out.writeInt(0);
    }

    private void writeSymbols() throws IOException {
        try {
            this.symTbl.symbolsDo(new SymbolTable.SymbolVisitor(){

                public void visit(Symbol sym) {
                    try {
                        HeapHprofBinWriter.this.writeSymbol(sym);
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }
            });
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
        }
    }

    private void writeSymbol(Symbol sym) throws IOException {
        byte[] buf = sym.asString().getBytes("UTF-8");
        this.writeHeader(1, buf.length + this.OBJ_ID_SIZE);
        this.writeObjectID(sym);
        this.out.write(buf);
    }

    private void writeClasses() throws IOException {
        SystemDictionary sysDict = VM.getVM().getSystemDictionary();
        try {
            sysDict.allClassesDo(new SystemDictionary.ClassVisitor(){
                private int serialNum = 1;

                public void visit(Klass k) {
                    try {
                        Instance clazz = k.getJavaMirror();
                        HeapHprofBinWriter.this.writeHeader(2, 2 * (HeapHprofBinWriter.this.OBJ_ID_SIZE + 4));
                        HeapHprofBinWriter.this.out.writeInt(this.serialNum);
                        HeapHprofBinWriter.this.writeObjectID(clazz);
                        HeapHprofBinWriter.this.out.writeInt(1);
                        HeapHprofBinWriter.this.writeObjectID(k.getName());
                        ++this.serialNum;
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }
            });
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
        }
    }

    private void writeFileHeader() throws IOException {
        this.out.writeBytes(HPROF_HEADER);
        this.out.writeByte(0);
        this.out.writeInt(this.OBJ_ID_SIZE);
        this.out.writeLong(System.currentTimeMillis());
    }

    private void writeObjectID(Oop oop) throws IOException {
        OopHandle handle = oop != null ? oop.getHandle() : null;
        long address = this.getAddressValue(handle);
        this.writeObjectID(address);
    }

    private void writeObjectID(long address) throws IOException {
        if (this.OBJ_ID_SIZE == 4) {
            this.out.writeInt((int)address);
        } else {
            this.out.writeLong(address);
        }
    }

    private long getAddressValue(Address addr) {
        return addr == null ? 0L : this.dbg.getAddressValue(addr);
    }

    private static List getInstanceFields(InstanceKlass ik) {
        ArrayList<Field> res = new ArrayList<Field>();
        for (InstanceKlass klass = ik; klass != null; klass = (InstanceKlass)klass.getSuper()) {
            List curFields = klass.getImmediateFields();
            Iterator itr = curFields.iterator();
            while (itr.hasNext()) {
                Field f = (Field)itr.next();
                if (f.isStatic()) continue;
                res.add(f);
            }
        }
        return res;
    }

    private int getSizeForFields(List fields) {
        int size = 0;
        Iterator itr = fields.iterator();
        block7: while (itr.hasNext()) {
            Field field = (Field)itr.next();
            char typeCode = (char)field.getSignature().getByteAt(0L);
            switch (typeCode) {
                case 'B': 
                case 'Z': {
                    ++size;
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    size += 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    size += 4;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    size += this.OBJ_ID_SIZE;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    size += 8;
                    continue block7;
                }
            }
            throw new RuntimeException("should not reach here");
        }
        return size;
    }

    private static class ClassData {
        int instSize;
        List fields;

        ClassData(int instSize, List fields) {
            this.instSize = instSize;
            this.fields = fields;
        }
    }
}

