/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.CompilerThread;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaThreadFactory;
import sun.jvm.hotspot.runtime.JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.JvmtiAgentThread;
import sun.jvm.hotspot.runtime.LowMemoryDetectorThread;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VirtualConstructor;
import sun.jvm.hotspot.runtime.linux_amd64.LinuxAMD64JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.linux_ia64.LinuxIA64JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.linux_sparc.LinuxSPARCJavaThreadPDAccess;
import sun.jvm.hotspot.runtime.linux_x86.LinuxX86JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.solaris_amd64.SolarisAMD64JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.solaris_sparc.SolarisSPARCJavaThreadPDAccess;
import sun.jvm.hotspot.runtime.solaris_x86.SolarisX86JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.win32_amd64.Win32AMD64JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.win32_ia64.Win32IA64JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.win32_x86.Win32X86JavaThreadPDAccess;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class Threads {
    private static JavaThreadFactory threadFactory;
    private static AddressField threadListField;
    private static VirtualConstructor virtualConstructor;
    private static JavaThreadPDAccess access;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("Threads");
        threadListField = type.getAddressField("_thread_list");
        String os = VM.getVM().getOS();
        String cpu = VM.getVM().getCPU();
        access = null;
        if (os.equals("solaris")) {
            if (cpu.equals("sparc")) {
                access = new SolarisSPARCJavaThreadPDAccess();
            } else if (cpu.equals("x86")) {
                access = new SolarisX86JavaThreadPDAccess();
            } else if (cpu.equals("amd64")) {
                access = new SolarisAMD64JavaThreadPDAccess();
            }
        } else if (os.equals("win32")) {
            if (cpu.equals("x86")) {
                access = new Win32X86JavaThreadPDAccess();
            } else if (cpu.equals("amd64")) {
                access = new Win32AMD64JavaThreadPDAccess();
            } else if (cpu.equals("ia64")) {
                access = new Win32IA64JavaThreadPDAccess();
            }
        } else if (os.equals("linux")) {
            if (cpu.equals("x86")) {
                access = new LinuxX86JavaThreadPDAccess();
            } else if (cpu.equals("ia64")) {
                access = new LinuxIA64JavaThreadPDAccess();
            } else if (cpu.equals("amd64")) {
                access = new LinuxAMD64JavaThreadPDAccess();
            } else if (cpu.equals("sparc")) {
                access = new LinuxSPARCJavaThreadPDAccess();
            }
        }
        if (access == null) {
            throw new RuntimeException("OS/CPU combination " + os + "/" + cpu + " not yet supported");
        }
        virtualConstructor = new VirtualConstructor(db);
        virtualConstructor.addMapping("JavaThread", JavaThread.class);
        if (!VM.getVM().isCore()) {
            virtualConstructor.addMapping("CompilerThread", CompilerThread.class);
        }
        virtualConstructor.addMapping("SurrogateLockerThread", JavaThread.class);
        virtualConstructor.addMapping("JvmtiAgentThread", JvmtiAgentThread.class);
        virtualConstructor.addMapping("LowMemoryDetectorThread", LowMemoryDetectorThread.class);
    }

    public JavaThread first() {
        Address threadAddr = threadListField.getValue();
        if (threadAddr == null) {
            return null;
        }
        return this.createJavaThreadWrapper(threadAddr);
    }

    public JavaThread createJavaThreadWrapper(Address threadAddr) {
        try {
            JavaThread thread = (JavaThread)virtualConstructor.instantiateWrapperFor(threadAddr);
            thread.setThreadPDAccess(access);
            return thread;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to deduce type of thread from address " + threadAddr + " (expected type JavaThread, CompilerThread, LowMemoryDetectorThread, JvmtiAgentThread, or SurrogateLockerThread)", e);
        }
    }

    public void oopsDo(AddressVisitor oopVisitor) {
        for (JavaThread thread = this.first(); thread != null; thread = thread.next()) {
            thread.oopsDo(oopVisitor);
        }
    }

    public JavaThread owningThreadFromMonitor(Address o) {
        if (o == null) {
            return null;
        }
        for (JavaThread thread = this.first(); thread != null; thread = thread.next()) {
            if (!((Object)o).equals(thread.threadObjectAddress())) continue;
            return thread;
        }
        long leastDiff = 0L;
        boolean leastDiffInitialized = false;
        JavaThread theOwner = null;
        for (JavaThread thread = this.first(); thread != null; thread = thread.next()) {
            Address addr = thread.highestLock();
            if (addr == null || addr.lessThan(o)) continue;
            long diff = addr.minus(o);
            if (leastDiffInitialized && diff >= leastDiff) continue;
            leastDiffInitialized = true;
            leastDiff = diff;
            theOwner = thread;
        }
        return theOwner;
    }

    public JavaThread owningThreadFromMonitor(ObjectMonitor monitor) {
        return this.owningThreadFromMonitor(monitor.owner());
    }

    public List getPendingThreads(ObjectMonitor monitor) {
        ArrayList<JavaThread> pendingThreads = new ArrayList<JavaThread>();
        for (JavaThread thread = this.first(); thread != null; thread = thread.next()) {
            ObjectMonitor pending;
            if (thread.isCompilerThread() || !monitor.equals(pending = thread.getCurrentPendingMonitor())) continue;
            pendingThreads.add(thread);
        }
        return pendingThreads;
    }

    public List getWaitingThreads(ObjectMonitor monitor) {
        ArrayList<JavaThread> pendingThreads = new ArrayList<JavaThread>();
        for (JavaThread thread = this.first(); thread != null; thread = thread.next()) {
            ObjectMonitor waiting = thread.getCurrentWaitingMonitor();
            if (!monitor.equals(waiting)) continue;
            pendingThreads.add(thread);
        }
        return pendingThreads;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Threads.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

