/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class StubRoutines {
    private static AddressField callStubReturnAddressField;
    private static AddressField callStubCompiledReturnAddressField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("StubRoutines");
        callStubReturnAddressField = type.getAddressField("_call_stub_return_address");
        try {
            callStubCompiledReturnAddressField = type.getAddressField("_call_stub_compiled_return");
        }
        catch (RuntimeException re) {
            callStubCompiledReturnAddressField = null;
        }
    }

    public boolean returnsToCallStub(Address returnPC) {
        Address addr = callStubReturnAddressField.getValue();
        boolean result = false;
        result = addr == null ? addr == returnPC : ((Object)addr).equals(returnPC);
        if (result || callStubCompiledReturnAddressField == null) {
            return result;
        }
        addr = callStubCompiledReturnAddressField.getValue();
        if (addr == null) {
            return addr == returnPC;
        }
        return ((Object)addr).equals(returnPC);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                StubRoutines.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

