/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.parallelScavenge;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.PSOldGen;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.PSPermGen;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.PSYoungGen;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.gc_interface.CollectedHeapName;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class ParallelScavengeHeap
extends CollectedHeap {
    private static AddressField youngGenField;
    private static AddressField oldGenField;
    private static AddressField permGenField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ParallelScavengeHeap");
        youngGenField = type.getAddressField("_young_gen");
        oldGenField = type.getAddressField("_old_gen");
        permGenField = type.getAddressField("_perm_gen");
    }

    public ParallelScavengeHeap(Address addr) {
        super(addr);
    }

    public PSYoungGen youngGen() {
        return (PSYoungGen)VMObjectFactory.newObject(PSYoungGen.class, youngGenField.getValue());
    }

    public PSOldGen oldGen() {
        return (PSOldGen)VMObjectFactory.newObject(PSOldGen.class, oldGenField.getValue());
    }

    public PSPermGen permGen() {
        return (PSPermGen)VMObjectFactory.newObject(PSPermGen.class, permGenField.getValue());
    }

    public long capacity() {
        return this.youngGen().capacity() + this.oldGen().capacity();
    }

    public long used() {
        return this.youngGen().used() + this.oldGen().used();
    }

    public boolean isIn(Address a) {
        if (this.youngGen().isIn(a)) {
            return true;
        }
        if (this.oldGen().isIn(a)) {
            return true;
        }
        return this.permGen().isIn(a);
    }

    public CollectedHeapName kind() {
        return CollectedHeapName.PARALLEL_SCAVENGE_HEAP;
    }

    public void printOn(PrintStream tty) {
        tty.print("ParallelScavengeHeap [ ");
        this.youngGen().printOn(tty);
        this.oldGen().printOn(tty);
        this.permGen().printOn(tty);
        tty.print(" ] ");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                ParallelScavengeHeap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

