/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;

final class IntBufferImpl
extends IntBuffer {
    private boolean readOnly;

    IntBufferImpl(int capacity) {
        this(new int[capacity], 0, capacity, capacity, 0, -1, false);
    }

    IntBufferImpl(int[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(buffer, offset, capacity, limit, position, mark);
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public IntBuffer slice() {
        return new IntBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public IntBuffer duplicate() {
        return new IntBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public IntBuffer asReadOnlyBuffer() {
        return new IntBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public IntBuffer compact() {
        int copied = 0;
        while (this.remaining() > 0) {
            this.put(copied, this.get());
            ++copied;
        }
        this.position(copied);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public final int get() {
        int result = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return result;
    }

    public final IntBuffer put(int value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = value;
        this.position(this.position() + 1);
        return this;
    }

    public final int get(int index) {
        return this.backing_buffer[index];
    }

    public final IntBuffer put(int index, int value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[index] = value;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

