/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class InetAddress
implements Serializable {
    private static final long serialVersionUID = 3286316764910316507L;
    static InetAddress ANY_IF;
    private static final byte[] localhostAddress;
    private static InetAddress localhost;
    private int address;
    transient byte[] addr;
    String hostName;
    int family;

    InetAddress(byte[] address) {
        this(address, null);
    }

    InetAddress(byte[] address, String hostname) {
        this.addr = address;
        this.hostName = hostname;
        if (address != null) {
            this.family = InetAddress.getFamily(address);
        }
    }

    public boolean isMulticastAddress() {
        if (this.addr.length == 4) {
            return (this.addr[0] & 0xF0) == 224;
        }
        if (this.addr.length == 16) {
            return this.addr[0] == -1;
        }
        return false;
    }

    public boolean isAnyLocalAddress() {
        return this.equals(ANY_IF);
    }

    public boolean isLoopbackAddress() {
        return this.addr[0] == 127;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        if (this.addr[0] == 10) {
            return true;
        }
        if (this.addr[0] == 172 && (this.addr[1] & 0xF0) == 1) {
            return true;
        }
        return this.addr[0] == 192 && this.addr[1] == 168;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return this.addr[0] == 224 && this.addr[1] == 0 && this.addr[2] == 0;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public String getHostName() {
        if (this.hostName == null) {
            InetAddress.lookup(null, this, false);
        }
        return this.hostName;
    }

    public String getCanonicalHostName() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkConnect(this.hostName, -1);
            }
            catch (SecurityException e) {
                return this.getHostAddress();
            }
        }
        InetAddress address = new InetAddress(this.getAddress(), null);
        return address.getHostName();
    }

    public byte[] getAddress() {
        return (byte[])this.addr.clone();
    }

    private static InetAddress[] allocArray(int count) {
        return new InetAddress[count];
    }

    private static SecurityException checkConnect(String hostname) {
        SecurityManager s = System.getSecurityManager();
        if (s == null) {
            return null;
        }
        try {
            s.checkConnect(hostname, -1);
            return null;
        }
        catch (SecurityException ex) {
            return ex;
        }
    }

    public String getHostAddress() {
        StringBuffer sb = new StringBuffer(40);
        int len = this.addr.length;
        int i = 0;
        if (len == 16) {
            while (true) {
                boolean empty;
                if (i >= 16) {
                    return sb.toString();
                }
                int x = (this.addr[i] & 0xFF) << 8 | this.addr[i + 1] & 0xFF;
                boolean bl = empty = sb.length() == 0;
                if (empty) {
                    if (i == 10 && x == 65535) {
                        sb.append(":FFFF:");
                        break;
                    }
                    if (i == 12) {
                        sb.append(':');
                        break;
                    }
                    if (i > 0) {
                        sb.append("::");
                    }
                } else {
                    sb.append(':');
                }
                if (x != 0 || i >= 14) {
                    sb.append(Integer.toHexString(x).toUpperCase());
                }
                i += 2;
            }
        }
        while (true) {
            sb.append(this.addr[i] & 0xFF);
            if (++i == len) break;
            sb.append('.');
        }
        return sb.toString();
    }

    public int hashCode() {
        int i;
        int hash = 0;
        int len = this.addr.length;
        int n = i = len > 4 ? len - 4 : 0;
        while (i < len) {
            hash = hash << 8 | this.addr[i] & 0xFF;
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InetAddress)) {
            return false;
        }
        byte[] addr2 = ((InetAddress)obj).addr;
        if (this.addr.length != addr2.length) {
            return false;
        }
        for (int i = 0; i < this.addr.length; ++i) {
            if (this.addr[i] == addr2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String address = this.getHostAddress();
        String host = this.hostName != null ? this.hostName : address;
        return host + "/" + address;
    }

    public static InetAddress getByAddress(byte[] addr) throws UnknownHostException {
        return InetAddress.getByAddress(null, addr);
    }

    public static InetAddress getByAddress(String host, byte[] addr) throws UnknownHostException {
        if (addr.length == 4) {
            return new Inet4Address(addr, host);
        }
        if (addr.length == 16) {
            return new Inet6Address(addr, host);
        }
        throw new UnknownHostException("IP address has illegal length");
    }

    private static native byte[] aton(String var0);

    private static native InetAddress[] lookup(String var0, InetAddress var1, boolean var2);

    private static native int getFamily(byte[] var0);

    public static InetAddress getByName(String hostname) throws UnknownHostException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkConnect(hostname, -1);
        }
        if (hostname == null) {
            return InetAddress.getLocalHost();
        }
        byte[] address = InetAddress.aton(hostname);
        if (address != null) {
            if (address.length == 4) {
                return new Inet4Address(address, null);
            }
            if (address.length == 16) {
                if (address[10] == 255 && address[11] == 255) {
                    byte[] ip4addr = new byte[]{address[12], address[13], address[14], address[15]};
                    return new Inet4Address(ip4addr, null);
                }
                return new Inet6Address(address, null);
            }
            throw new UnknownHostException("Address has invalid length");
        }
        InetAddress[] addresses = InetAddress.getAllByName(hostname);
        return addresses[0];
    }

    public static InetAddress[] getAllByName(String hostname) throws UnknownHostException {
        byte[] address;
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkConnect(hostname, -1);
        }
        if ((address = InetAddress.aton(hostname)) != null) {
            InetAddress[] result = new InetAddress[]{new InetAddress(address, null)};
            return result;
        }
        return InetAddress.lookup(hostname, null, true);
    }

    private static native String getLocalHostname();

    public static InetAddress getLocalHost() throws UnknownHostException {
        SecurityManager s = System.getSecurityManager();
        if (localhost == null || s != null && InetAddress.localhost.addr != localhostAddress) {
            InetAddress.getLocalHost(s);
        }
        return localhost;
    }

    private static synchronized void getLocalHost(SecurityManager s) throws UnknownHostException {
        if (s == null && localhost != null) {
            return;
        }
        String hostname = InetAddress.getLocalHostname();
        if (s != null) {
            try {
                s.checkConnect(hostname, -1);
            }
            catch (SecurityException ex) {
                hostname = null;
            }
        }
        if (hostname != null) {
            try {
                localhost = new InetAddress(null, null);
                InetAddress.lookup(hostname, localhost, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (localhost == null) {
            localhost = new InetAddress(localhostAddress, "localhost");
        }
    }

    private void readResolve() throws ObjectStreamException {
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.addr = new byte[4];
        this.addr[3] = (byte)this.address;
        for (int i = 2; i >= 0; --i) {
            this.addr[i] = (byte)(this.address >>= 8);
        }
        this.family = InetAddress.getFamily(this.addr);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int len = this.addr.length;
        for (int i = len - 4; i < len; ++i) {
            this.address = this.address << 8 | this.addr[i] & 0xFF;
        }
        oos.defaultWriteObject();
    }

    static {
        localhostAddress = new byte[]{127, 0, 0, 1};
        localhost = null;
        byte[] zeros = new byte[]{0, 0, 0, 0};
        ANY_IF = new InetAddress(zeros, "0.0.0.0");
    }
}

