/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.der;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DER;
import gnu.java.security.der.DEREncodingException;
import gnu.java.security.der.DERValue;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DERReader
implements DER {
    protected InputStream in;
    protected final ByteArrayOutputStream encBuf;

    public DERReader(byte[] in) {
        this(new ByteArrayInputStream(in));
    }

    public DERReader(InputStream in) {
        this.in = !in.markSupported() ? new BufferedInputStream(in, 16384) : in;
        this.encBuf = new ByteArrayOutputStream(2048);
    }

    public static DERValue read(byte[] encoded) throws IOException {
        return new DERReader(encoded).read();
    }

    public DERValue read() throws IOException {
        int tag = this.in.read();
        if (tag == -1) {
            throw new EOFException();
        }
        this.encBuf.write(tag);
        int len = this.readLength();
        DERValue value = null;
        if ((tag & 0x20) == 32) {
            this.in.mark(2048);
            byte[] encoded = new byte[len];
            this.in.read(encoded);
            this.encBuf.write(encoded);
            value = new DERValue(tag, len, DER.CONSTRUCTED_VALUE, this.encBuf.toByteArray());
            this.in.reset();
            this.encBuf.reset();
            return value;
        }
        switch (tag & 0xC0) {
            case 0: {
                value = new DERValue(tag, len, this.readUniversal(tag, len), this.encBuf.toByteArray());
                this.encBuf.reset();
                break;
            }
            case 128: {
                byte[] encoded = new byte[len];
                this.in.read(encoded);
                this.encBuf.write(encoded);
                value = new DERValue(tag, len, encoded, this.encBuf.toByteArray());
                this.encBuf.reset();
                break;
            }
            case 64: {
                throw new DEREncodingException("non-constructed APPLICATION data");
            }
            default: {
                throw new DEREncodingException("PRIVATE class not supported");
            }
        }
        return value;
    }

    private Object readUniversal(int tag, int len) throws IOException {
        byte[] value = new byte[len];
        this.in.read(value);
        this.encBuf.write(value);
        switch (tag & 0x1F) {
            case 1: {
                if (value.length != 1) {
                    throw new DEREncodingException();
                }
                return value[0] != 0;
            }
            case 5: {
                if (len != 0) {
                    throw new DEREncodingException();
                }
                return null;
            }
            case 2: 
            case 10: {
                return new BigInteger(value);
            }
            case 3: {
                byte[] bits = new byte[len - 1];
                System.arraycopy(value, 1, bits, 0, bits.length);
                return new BitString(bits, value[0] & 0xFF);
            }
            case 4: {
                return value;
            }
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                return this.makeString(tag, value);
            }
            case 23: 
            case 24: {
                return this.makeTime(tag, value);
            }
            case 6: {
                return new OID(value);
            }
            case 13: {
                return new OID(value, true);
            }
        }
        throw new DEREncodingException("unknown tag " + tag);
    }

    private int readLength() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            throw new EOFException();
        }
        this.encBuf.write(i);
        if ((i & 0xFFFFFF80) == 0) {
            return i;
        }
        if (i < 255) {
            byte[] octets = new byte[i & 0x7F];
            this.in.read(octets);
            this.encBuf.write(octets);
            return new BigInteger(1, octets).intValue();
        }
        throw new DEREncodingException();
    }

    private String makeString(int tag, byte[] value) throws IOException {
        Charset charset = null;
        switch (tag & 0x1F) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                charset = Charset.forName("ISO-8859-1");
                break;
            }
            case 28: 
            case 30: {
                charset = Charset.forName("UTF-16BE");
                break;
            }
            case 12: {
                charset = Charset.forName("UTF-8");
                break;
            }
            default: {
                throw new DEREncodingException("unknown string tag");
            }
        }
        if (charset == null) {
            throw new DEREncodingException("no decoder");
        }
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer result = decoder.decode(ByteBuffer.wrap(value));
        char[] buf = new char[result.remaining()];
        result.get(buf);
        return new String(buf);
    }

    private Date makeTime(int tag, byte[] value) throws IOException {
        String str;
        Calendar calendar = Calendar.getInstance();
        String date = str = this.makeString(19, value);
        String tz = "";
        if (str.indexOf("+") > 0) {
            date = str.substring(0, str.indexOf("+"));
            tz = str.substring(str.indexOf("+"));
        } else if (str.indexOf("-") > 0) {
            date = str.substring(0, str.indexOf("-"));
            tz = str.substring(str.indexOf("-"));
        } else if (str.endsWith("Z")) {
            date = str.substring(0, str.length() - 2);
            tz = "Z";
        }
        if (!tz.equals("Z") && tz.length() > 0) {
            calendar.setTimeZone(TimeZone.getTimeZone(tz));
        } else {
            calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        if ((tag & 0x1F) == 23) {
            if (date.length() < 10) {
                throw new DEREncodingException("cannot parse date");
            }
            try {
                int year = Integer.parseInt(str.substring(0, 2));
                year = year < 50 ? (year += 2000) : (year += 1900);
                calendar.set(year, Integer.parseInt(str.substring(2, 4)) - 1, Integer.parseInt(str.substring(4, 6)), Integer.parseInt(str.substring(6, 8)), Integer.parseInt(str.substring(8, 10)));
                if (date.length() == 12) {
                    // empty if block
                }
                calendar.set(13, Integer.parseInt(str.substring(10, 12)));
            }
            catch (NumberFormatException nfe) {
                throw new DEREncodingException("cannot parse date");
            }
        }
        if (date.length() < 10) {
            throw new DEREncodingException("cannot parse date");
        }
        try {
            calendar.set(Integer.parseInt(date.substring(0, 4)), Integer.parseInt(date.substring(4, 6)) - 1, Integer.parseInt(date.substring(6, 8)), Integer.parseInt(date.substring(8, 10)), 0);
            switch (date.length()) {
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    calendar.set(14, Integer.parseInt(date.substring(15)));
                }
                case 14: {
                    calendar.set(13, Integer.parseInt(date.substring(12, 14)));
                }
                case 12: {
                    calendar.set(12, Integer.parseInt(date.substring(10, 12)));
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new DEREncodingException("cannot parse date");
        }
        return calendar.getTime();
    }
}

