/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import sun.tools.jconsole.inspector.XObject;
import sun.tools.jconsole.inspector.XTextField;

public class Utils {
    private static int uniqueId = (int)(new Date().getTime() % 100L);
    private static Object objectClipBoard;
    private static int locationX;
    private static int locationY;
    private static String INDENT_UNIT;

    private Utils() {
    }

    public static synchronized Object getClipboardContents() {
        return objectClipBoard;
    }

    public static synchronized void setClipboardContents(Object object) {
        objectClipBoard = object;
    }

    public static Point getNextLocation() {
        Point point = new Point(locationX, locationY);
        locationX += 30;
        locationY += 30;
        return point;
    }

    public static String generateName(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(n + 1, string.length()) + uniqueId++;
        }
        return string + uniqueId++;
    }

    public static String getUniqueId() {
        return Integer.toString(uniqueId++);
    }

    public static Class getClass(String string) throws Exception {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string.equals("int")) {
                return Integer.TYPE;
            }
            if (string.equals("long")) {
                return Long.TYPE;
            }
            if (string.equals("short")) {
                return Short.TYPE;
            }
            if (string.equals("double")) {
                return Double.TYPE;
            }
            if (string.equals("byte")) {
                return Byte.TYPE;
            }
            if (string.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (string.equals("float")) {
                return Float.TYPE;
            }
            if (string.equals("byte")) {
                return Byte.TYPE;
            }
            if (string.equals("char")) {
                return Character.TYPE;
            }
            throw classNotFoundException;
        }
    }

    public static boolean isSupportedDataStructure(Object object) {
        if (Utils.isSupportedArray(object)) {
            return true;
        }
        if (object instanceof Collection) {
            return true;
        }
        return object instanceof Map && !(object instanceof TabularData);
    }

    public static boolean isSupportedArray(Object object) {
        return object != null && object.getClass().isArray() && !object.getClass().getComponentType().isArray();
    }

    public static String getArrayClassName(String string) {
        String string2 = null;
        if (string.startsWith("[")) {
            int n = string.lastIndexOf("[");
            string2 = string.substring(n + 1, string.length());
            char c = string2.charAt(0);
            switch (c) {
                case 'L': {
                    string2 = string2.substring(1, string2.length() - 1);
                    break;
                }
                case 'B': {
                    string2 = Byte.TYPE.getName();
                    break;
                }
                case 'C': {
                    string2 = Character.TYPE.getName();
                    break;
                }
                case 'D': {
                    string2 = Double.TYPE.getName();
                    break;
                }
                case 'F': {
                    string2 = Float.TYPE.getName();
                    break;
                }
                case 'I': {
                    string2 = Integer.TYPE.getName();
                    break;
                }
                case 'J': {
                    string2 = Long.TYPE.getName();
                    break;
                }
                case 'S': {
                    string2 = Short.TYPE.getName();
                    break;
                }
                default: {
                    string2 = Boolean.TYPE.getName();
                }
            }
        }
        return string2;
    }

    public static String getReadableClassName(String string) {
        String string2 = Utils.getArrayClassName(string);
        if (string2 == null) {
            return string;
        }
        int n = string.lastIndexOf("[");
        StringBuffer stringBuffer = new StringBuffer(string2);
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append("[ ]");
        }
        return stringBuffer.toString();
    }

    public static boolean isEditableType(String string) {
        return string.equals("int") || string.equals("long") || string.equals("float") || string.equals("short") || string.equals("double") || string.equals("char") || string.equals("byte") || string.equals("boolean") || string.equals("java.lang.Number") || string.equals("java.math.BigInteger") || string.equals("java.math.BigDecimal") || string.equals("java.lang.Integer") || string.equals("java.lang.Long") || string.equals("java.lang.Float") || string.equals("java.lang.Short") || string.equals("java.lang.Double") || string.equals("java.lang.Boolean") || string.equals("java.lang.Byte") || string.equals("java.lang.String") || string.equals("javax.management.ObjectName");
    }

    public static String getDefaultValue(String string) {
        if (string.equals("int") || string.equals("long") || string.equals("float") || string.equals("short") || string.equals("double") || string.equals("char") || string.equals("byte") || string.equals("java.lang.Number") || string.equals("java.math.BigInteger") || string.equals("java.math.BigDecimal") || string.equals("java.lang.Integer") || string.equals("java.lang.Long") || string.equals("java.lang.Float") || string.equals("java.lang.Short") || string.equals("java.lang.Double") || string.equals("java.lang.Byte")) {
            return "0";
        }
        if (string.equals("boolean")) {
            return "true";
        }
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    public static Object createObjectFromString(String string, String string2) throws Exception {
        Serializable serializable;
        if (string.equals("int")) {
            serializable = new Integer(string2);
        } else if (string.equals("long")) {
            serializable = new Long(string2);
        } else if (string.equals("double")) {
            serializable = new Double(string2);
        } else if (string.equals("float")) {
            serializable = new Float(string2);
        } else if (string.equals("short")) {
            serializable = new Short(string2);
        } else if (string.equals("boolean")) {
            serializable = new Boolean(string2);
        } else if (string.equals("char")) {
            serializable = new Character(string2.charAt(0));
        } else if (string.equals("byte")) {
            serializable = new Byte(string2);
        } else if (string.equals("java.lang.Integer")) {
            serializable = new Integer(string2);
        } else if (string.equals("java.lang.Long")) {
            serializable = new Long(string2);
        } else if (string.equals("java.lang.Float")) {
            serializable = new Float(string2);
        } else if (string.equals("java.lang.Double")) {
            serializable = new Double(string2);
        } else if (string.equals("java.lang.Short")) {
            serializable = new Short(string2);
        } else if (string.equals("java.lang.Boolean")) {
            serializable = new Boolean(string2);
        } else if (Utils.getClass("java.lang.Number").isAssignableFrom(Utils.getClass(string))) {
            serializable = Utils.createNumberFromString(string2);
        } else if (string2.toString().equals("null")) {
            serializable = null;
        } else {
            if (string.equals("javax.management.ObjectName")) {
                serializable = new ObjectName(string2);
            }
            Class[] classArray = new Class[]{string2.toString().getClass()};
            Constructor constructor = Utils.getClass(string).getConstructor(classArray);
            Object[] objectArray = new Object[]{string2};
            serializable = constructor.newInstance(objectArray);
        }
        return serializable;
    }

    public static Object[] getParameters(XTextField[] xTextFieldArray, String[] stringArray) throws Exception {
        Object[] objectArray = new Object[xTextFieldArray.length];
        for (int i = 0; i < xTextFieldArray.length; ++i) {
            Object object = xTextFieldArray[i].getValue();
            if (object instanceof XObject) {
                objectArray[i] = ((XObject)object).getObject();
                continue;
            }
            objectArray[i] = null;
            if (stringArray[i].toString().equals("int")) {
                objectArray[i] = new Integer((String)object);
                continue;
            }
            if (stringArray[i].toString().equals("long")) {
                objectArray[i] = new Long((String)object);
                continue;
            }
            if (stringArray[i].toString().equals("float")) {
                objectArray[i] = new Float((String)object);
                continue;
            }
            if (stringArray[i].toString().equals("double")) {
                objectArray[i] = new Double((String)object);
                continue;
            }
            if (stringArray[i].toString().equals("short")) {
                objectArray[i] = new Short((String)object);
                continue;
            }
            if (stringArray[i].toString().equals("char")) {
                objectArray[i] = new Character(((String)object).charAt(0));
                continue;
            }
            if (stringArray[i].toString().equals("boolean")) {
                objectArray[i] = new Boolean((String)object);
                continue;
            }
            if (Utils.getClass("java.lang.Number").isAssignableFrom(Utils.getClass(stringArray[i]))) {
                objectArray[i] = Utils.createNumberFromString((String)object);
                continue;
            }
            if (object.toString().equals("null")) {
                objectArray[i] = null;
                continue;
            }
            Class[] classArray = new Class[]{object.toString().getClass()};
            Constructor constructor = Utils.getClass(stringArray[i]).getConstructor(classArray);
            Object[] objectArray2 = new Object[]{object};
            objectArray[i] = constructor.newInstance(objectArray2);
        }
        return objectArray;
    }

    private static Number createNumberFromString(String string) throws NumberFormatException {
        try {
            Integer n = new Integer(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Long l = new Long(string);
                return l;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    Float f = new Float(string);
                    return f;
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        Double d = new Double(string);
                        return d;
                    }
                    catch (NumberFormatException numberFormatException4) {
                        try {
                            Short s = new Short(string);
                            return s;
                        }
                        catch (NumberFormatException numberFormatException5) {
                            try {
                                Byte by = new Byte(string);
                                return by;
                            }
                            catch (NumberFormatException numberFormatException6) {
                                try {
                                    BigDecimal bigDecimal = new BigDecimal(string);
                                    return bigDecimal;
                                }
                                catch (NumberFormatException numberFormatException7) {
                                    try {
                                        BigInteger bigInteger = new BigInteger(string);
                                        return bigInteger;
                                    }
                                    catch (NumberFormatException numberFormatException8) {
                                        throw new NumberFormatException("Cannot convert String \"" + string + "\" to java.lang.Number");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static boolean acceptDrag4337114WorkAround(DragGestureEvent dragGestureEvent) {
        Iterator<InputEvent> iterator = dragGestureEvent.iterator();
        InputEvent inputEvent = null;
        while (iterator.hasNext()) {
            inputEvent = iterator.next();
        }
        if (inputEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)inputEvent;
            return mouseEvent.getID() != 505;
        }
        return true;
    }

    public static Throwable getActualException(Throwable throwable) {
        if (throwable.getClass().getName().equals("javax.management.MBeanException")) {
            return Utils.invokeMethod(throwable, "getTargetException");
        }
        if (throwable.getClass().getName().equals("javax.management.RuntimeMBeanException")) {
            return Utils.invokeMethod(throwable, "getTargetException");
        }
        if (throwable.getClass().getName().equals("javax.management.ReflectionException")) {
            return Utils.invokeMethod(throwable, "getTargetException");
        }
        if (throwable.getClass().getName().equals("com.sun.jdmk.comm.CommunicationException")) {
            return Utils.invokeMethod(throwable, "getTargetException");
        }
        if (throwable.getClass().getName().equals("com.sun.jdmk.ProxyMBeanInstantiationException")) {
            return Utils.invokeMethod(throwable, "getTargetException");
        }
        return throwable;
    }

    private static Throwable invokeMethod(Throwable throwable, String string) {
        try {
            Method method = throwable.getClass().getDeclaredMethod(string, null);
            return (Throwable)method.invoke((Object)throwable, (Object[])null);
        }
        catch (Throwable throwable2) {
            return throwable;
        }
    }

    public static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        locationX = 0;
        locationY = 0;
        INDENT_UNIT = "   ";
    }

    public static class CopyKeyAdapter
    extends KeyAdapter {
        private static final String defaultEditorKitCopyActionName = "copy-to-clipboard";
        private static final String transferHandlerCopyActionName = (String)TransferHandler.getCopyAction().getValue("Name");

        public void keyPressed(KeyEvent keyEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
            boolean bl = false;
            JComponent jComponent = (JComponent)keyEvent.getSource();
            for (int i = 0; i < 3; ++i) {
                InputMap inputMap = jComponent.getInputMap(i);
                Object object = inputMap.get(keyStroke);
                if (!defaultEditorKitCopyActionName.equals(object) && !transferHandlerCopyActionName.equals(object)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                keyEvent.consume();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            keyEvent.consume();
        }
    }

    public static class EditFocusAdapter
    extends FocusAdapter {
        private CellEditor editor;

        public EditFocusAdapter(CellEditor cellEditor) {
            this.editor = cellEditor;
        }

        public void focusLost(FocusEvent focusEvent) {
            this.editor.stopCellEditing();
        }
    }

    public static class ReadOnlyTableCellEditor
    extends DefaultCellEditor {
        public ReadOnlyTableCellEditor(JTextField jTextField) {
            super(jTextField);
            jTextField.addFocusListener(new EditFocusAdapter(this));
            jTextField.addKeyListener(new CopyKeyAdapter());
        }
    }
}

