/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XSheet;
import sun.tools.jconsole.inspector.XTree;
import sun.tools.jconsole.inspector.XTreeRenderer;

public class MBeansTab
extends Tab
implements NotificationListener,
PropertyChangeListener,
TreeSelectionListener {
    private XTree tree;
    private XSheet sheet;
    private XDataViewer viewer;
    private MouseListener ml = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() == 1 && (n = MBeansTab.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY())) != -1) {
                TreePath treePath = MBeansTab.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (MBeansTab.this.sheet.isMBeanNode(defaultMutableTreeNode)) {
                    MBeansTab.this.tree.expandPath(treePath);
                }
            }
        }
    };

    public static String getTabName() {
        return Resources.getText("MBeans", new Object[0]);
    }

    public MBeansTab(VMPanel vMPanel) {
        super(vMPanel, MBeansTab.getTabName());
        this.addPropertyChangeListener(this);
        this.setupTab();
    }

    public XDataViewer getDataViewer() {
        return this.viewer;
    }

    public XTree getTree() {
        return this.tree;
    }

    public XSheet getSheet() {
        return this.sheet;
    }

    public void dispose() {
        super.dispose();
        this.sheet.dispose();
    }

    public int getUpdateInterval() {
        return this.vmPanel.getUpdateInterval();
    }

    void synchroniseMBeanServerView() {
        try {
            this.getMBeanServerConnection().addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this, null, null);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            if (JConsole.isDebug()) {
                instanceNotFoundException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            if (JConsole.isDebug()) {
                iOException.printStackTrace();
            }
            this.vmPanel.getProxyClient().markAsDead();
            return;
        }
        Set<ObjectName> set = null;
        try {
            set = this.getMBeanServerConnection().queryNames(null, null);
        }
        catch (IOException iOException) {
            if (JConsole.isDebug()) {
                iOException.printStackTrace();
            }
            this.vmPanel.getProxyClient().markAsDead();
            return;
        }
        this.tree.removeAll();
        this.tree.setVisible(false);
        for (ObjectName objectName : set) {
            this.tree.addMBeanToView(objectName);
        }
        this.tree.setVisible(true);
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.vmPanel.getProxyClient().getMBeanServerConnection();
    }

    public void update() {
        try {
            this.getMBeanServerConnection().getDefaultDomain();
        }
        catch (IOException iOException) {
            this.vmPanel.getProxyClient().markAsDead();
        }
    }

    private void setupTab() {
        this.setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setDividerLocation(160);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.tree = new XTree(this);
        this.tree.setCellRenderer(new XTreeRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(this.ml);
        JScrollPane jScrollPane = new JScrollPane(this.tree, 20, 30);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jSplitPane.add(jPanel, "left", 0);
        this.viewer = new XDataViewer(this);
        this.sheet = new XSheet(this);
        jSplitPane.add(this.sheet, "right", 0);
        this.add(jSplitPane);
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification instanceof MBeanServerNotification) {
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            if (notification.getType().equals("JMX.mbean.registered")) {
                this.tree.addMBeanToView(objectName);
            } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                this.tree.delMBeanFromView(objectName);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "connectionState") {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.workerAdd(new Runnable(){

                    public void run() {
                        MBeansTab.this.synchroniseMBeanServerView();
                    }
                });
            } else {
                this.sheet.dispose();
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        this.sheet.displayNode(defaultMutableTreeNode);
    }
}

